/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.diff.SVNDiffWindowBuilder;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNCommitEditor;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.ISVNCredentials;
import org.tmatesoft.svn.core.io.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNLogEntry;
import org.tmatesoft.svn.core.io.SVNLogEntryPath;
import org.tmatesoft.svn.core.io.SVNNodeKind;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;

public class SVNRepositoryImpl
extends SVNRepository
implements ISVNReporter {
    private SVNConnection myConnection;
    private ISVNCredentials myCredentials;
    private String myFullRoot;

    protected SVNRepositoryImpl(SVNRepositoryLocation location) {
        super(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection() throws SVNException {
        try {
            this.openConnection();
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatestRevision() throws SVNException {
        Object[] buffer = new Object[]{"get-latest-rev"};
        try {
            this.openConnection();
            this.write("(w())", buffer);
            this.authenticate();
            buffer = this.read("[(N)]", buffer);
        }
        finally {
            this.closeConnection();
        }
        return SVNReader.getLong(buffer, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDatedRevision(Date date) throws SVNException {
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        Object[] buffer = new Object[]{"get-dated-rev", date};
        try {
            this.openConnection();
            this.write("(w(s))", buffer);
            this.authenticate();
            buffer = this.read("[(N)]", buffer);
        }
        finally {
            this.closeConnection();
        }
        return SVNReader.getLong(buffer, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getRevisionProperties(long revision, Map properties) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(revision);
        if (properties == null) {
            properties = new HashMap();
        }
        Object[] buffer = new Object[]{"rev-proplist", SVNRepositoryImpl.getRevisionObject(revision)};
        try {
            this.openConnection();
            this.write("(w(n))", buffer);
            this.authenticate();
            buffer[0] = properties;
            this.read("[((*P))]", buffer);
        }
        finally {
            this.closeConnection();
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRevisionPropertyValue(long revision, String propertyName) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(revision);
        Object[] buffer = new Object[]{"rev-prop", SVNRepositoryImpl.getRevisionObject(revision), propertyName};
        try {
            this.openConnection();
            this.write("(w(ns))", buffer);
            this.authenticate();
            buffer = this.read("[((?S))]", buffer);
        }
        finally {
            this.closeConnection();
        }
        return (String)buffer[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNNodeKind checkPath(String path, long revision) throws SVNException {
        try {
            this.openConnection();
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"check-path", path, SVNRepositoryImpl.getRevisionObject(revision)};
            this.write("(w(s(n)))", buffer);
            this.authenticate();
            this.read("[(W)]", buffer);
            SVNNodeKind sVNNodeKind = SVNNodeKind.parseKind((String)buffer[0]);
            return sVNNodeKind;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocations(String path, long pegRevision, long[] revisions, ISVNLocationEntryHandler handler) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(pegRevision);
        for (int i = 0; i < revisions.length; ++i) {
            SVNRepositoryImpl.assertValidRevision(revisions[i]);
        }
        int count = 0;
        try {
            this.openConnection();
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"get-locations", path, SVNRepositoryImpl.getRevisionObject(pegRevision), revisions};
            this.write("(w(sn(*n)))", buffer);
            this.authenticate();
            try {
                while (true) {
                    this.read("(NS)", buffer);
                    ++count;
                    if (handler == null) continue;
                    long revision = SVNReader.getLong(buffer, 0);
                    String location = SVNReader.getString(buffer, 1);
                    if (location == null) continue;
                    handler.handleLocationEntry(new SVNLocationEntry(revision, location));
                }
            }
            catch (SVNException e) {
                this.read("x", buffer);
                this.read("[()]", buffer);
                this.closeConnection();
            }
        }
        catch (Throwable throwable) {
            this.closeConnection();
            throw throwable;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFile(String path, long revision, Map properties, OutputStream contents) throws SVNException {
        Long rev = revision > 0L ? new Long(revision) : null;
        try {
            this.openConnection();
            Object[] buffer = new Object[]{"get-file", this.getRepositoryPath(path), rev, properties != null, contents != null};
            this.write("(w(s(n)ww))", buffer);
            this.authenticate();
            buffer[2] = properties;
            buffer = this.read("[((?S)N(*P))]", buffer);
            if (properties != null) {
                properties.put("svn:entry:revision", buffer[1].toString());
                properties.put("svn:entry:checksum", buffer[0].toString());
            }
            if (contents != null) {
                Object[] buffer2 = new Object[]{contents};
                this.read("*I", buffer2);
                this.read("[()]", buffer2);
            }
            long l = SVNReader.getLong(buffer, 1);
            return l;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDir(String path, long revision, Map properties, ISVNDirEntryHandler handler) throws SVNException {
        Long rev = SVNRepositoryImpl.getRevisionObject(revision);
        try {
            long start = System.currentTimeMillis();
            this.openConnection();
            DebugLog.log("openConnection(): " + (System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"get-dir", path, rev, properties != null, handler != null};
            this.write("(w(s(n)ww))", buffer);
            this.authenticate();
            buffer[1] = properties;
            buffer = this.read("[(N(*P)", buffer);
            long l = revision = buffer[0] != null ? SVNReader.getLong(buffer, 0) : revision;
            if (handler != null) {
                buffer[0] = handler;
                this.read("(*D)))", buffer);
            }
            DebugLog.log("getDir() finished: " + (System.currentTimeMillis() - start));
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            long start = System.currentTimeMillis();
            this.closeConnection();
            DebugLog.log("closeConnection(): " + (System.currentTimeMillis() - start));
            throw throwable;
        }
        long start = System.currentTimeMillis();
        this.closeConnection();
        DebugLog.log("closeConnection(): " + (System.currentTimeMillis() - start));
        return revision;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getFileRevisions(String path, long sRevision, long eRevision, ISVNFileRevisionHandler handler) throws SVNException {
        srev = SVNRepositoryImpl.getRevisionObject(sRevision);
        erev = SVNRepositoryImpl.getRevisionObject(eRevision);
        count = 0;
        try {
            this.openConnection();
            buffer = new Object[]{"get-file-revs", this.getRepositoryPath(path), srev, erev};
            this.write("(w(s(n)(n)))", buffer);
            this.authenticate();
lbl9:
            // 2 sources

            while (true) {
                fileRevision = null;
                try {
                    this.read("(SN(*P)(*Z))", buffer);
                    ++count;
                }
                catch (SVNException e) {
                    this.read("x", buffer);
                    var13_13 = count;
                    this.closeConnection();
                    return var13_13;
                }
                break;
            }
        }
        catch (Throwable var21_22) {
            this.closeConnection();
            throw var21_22;
        }
        {
            name = null;
            if (handler != null) {
                name = (String)buffer[0];
                revision = SVNReader.getLong(buffer, 1);
                properties = SVNReader.getMap(buffer, 2);
                propertiesDelta = SVNReader.getMap(buffer, 3);
                if (name != null) {
                    fileRevision = new SVNFileRevision(name, revision, properties, propertiesDelta);
                }
                buffer[2] = null;
                buffer[3] = null;
            }
            if (handler != null && fileRevision != null) {
                handler.hanldeFileRevision(fileRevision);
                fileRevision = null;
            }
            builder = SVNDiffWindowBuilder.newInstance();
            while (true) {
                if ((line = (byte[])this.read("?W?B", buffer)[1]) == null) {
                    this.read("[]", buffer);
                    break;
                }
                if (line.length == 0) break;
                builder.accept(line, 0);
                window = builder.getDiffWindow();
                if (window == null) continue;
                builder.reset(1);
                os = handler.handleDiffWindow(name == null ? path : name, window);
                length = window.getNewDataLength();
                while (length > 0L) {
                    contents = (byte[])this.myConnection.read("B", null)[0];
                    length -= (long)contents.length;
                    try {
                        if (os == null) continue;
                        os.write(contents);
                    }
                    catch (IOException th) {}
                }
                try {
                    os.close();
                }
                catch (IOException th) {}
            }
            handler.hanldeDiffWindowClosed(name == null ? path : name);
            ** continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int log(String[] targetPaths, long startRevision, long endRevision, boolean changedPaths, boolean strictNode, ISVNLogEntryHandler handler) throws SVNException {
        int count = 0;
        try {
            this.openConnection();
            String[] realTargetPaths = new String[targetPaths.length];
            for (int i = 0; i < realTargetPaths.length; ++i) {
                realTargetPaths[i] = this.getRepositoryPath(targetPaths[i]);
            }
            Object[] buffer = new Object[]{"log", realTargetPaths, SVNRepositoryImpl.getRevisionObject(startRevision), SVNRepositoryImpl.getRevisionObject(endRevision), changedPaths, strictNode};
            this.write("(w((*s)(n)(n)ww))", buffer);
            this.authenticate();
            try {
                while (true) {
                    this.read("((", buffer);
                    HashMap<String, SVNLogEntryPath> changedPathsMap = null;
                    if (changedPaths) {
                        changedPathsMap = handler != null ? new HashMap<String, SVNLogEntryPath>() : null;
                        try {
                            while (true) {
                                String path;
                                this.read("(SW(?S?N))", buffer);
                                if (changedPathsMap == null || (path = SVNReader.getString(buffer, 0)) == null || "".equals(path.trim())) continue;
                                String type = SVNReader.getString(buffer, 1);
                                String copyPath = SVNReader.getString(buffer, 2);
                                long copyRev = SVNReader.getLong(buffer, 3);
                                changedPathsMap.put(path, new SVNLogEntryPath(path, type.charAt(0), copyPath, copyRev));
                            }
                        }
                        catch (SVNException e) {
                            // empty catch block
                        }
                    }
                    this.read(")N(?S)(?S)(?S))", buffer);
                    if (handler != null) {
                        long revision = SVNReader.getLong(buffer, 0);
                        String author = SVNReader.getString(buffer, 1);
                        Date date = SVNReader.getDate(buffer, 2);
                        String message = SVNReader.getString(buffer, 3);
                        handler.handleLogEntry(new SVNLogEntry(changedPathsMap, revision, author, date, message));
                    }
                    ++count;
                }
            }
            catch (SVNException e) {
                this.read("x", buffer);
                int n = count;
                return n;
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        target = target == null ? "" : target;
        Object[] buffer = new Object[]{"update", SVNRepositoryImpl.getRevisionObject(revision), target, recursive};
        try {
            this.openConnection();
            this.write("(w((n)sw))", buffer);
            this.authenticate();
            reporter.report(this);
            this.authenticate();
            this.read("*E", new Object[]{editor});
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String url, long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        target = target == null ? "" : target;
        if ((url = SVNRepositoryImpl.getCanonicalURL(url)) == null) {
            throw new SVNException(url + ": not valid URL");
        }
        Object[] buffer = new Object[]{"switch", SVNRepositoryImpl.getRevisionObject(revision), target, recursive, url};
        try {
            this.openConnection();
            this.write("(w((n)sws))", buffer);
            this.authenticate();
            reporter.report(this);
            this.authenticate();
            this.read("*E", new Object[]{editor});
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diff(String url, long revision, String target, boolean ignoreAncestry, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        target = target == null ? "" : target;
        if ((url = SVNRepositoryImpl.getCanonicalURL(url)) == null) {
            throw new SVNException(url + ": not valid URL");
        }
        Object[] buffer = new Object[]{"diff", SVNRepositoryImpl.getRevisionObject(revision), target, ignoreAncestry, recursive, url};
        try {
            this.openConnection();
            this.write("(w((n)swws))", buffer);
            this.authenticate();
            reporter.report(this);
            this.authenticate();
            this.read("*E", new Object[]{editor});
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void status(long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        target = target == null ? "" : target;
        Object[] buffer = new Object[]{"status", target, recursive, SVNRepositoryImpl.getRevisionObject(revision)};
        try {
            this.openConnection();
            this.write("(w(sw(n)))", buffer);
            this.authenticate();
            reporter.report(this);
            this.authenticate();
            this.read("*E", new Object[]{editor});
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRevisionPropertyValue(long revision, String propertyName, String propertyValue) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(revision);
        Object[] buffer = new Object[]{"change-rev-prop", SVNRepositoryImpl.getRevisionObject(revision), propertyName, propertyValue};
        try {
            this.openConnection();
            this.write("(w(nss))", buffer);
            this.authenticate();
            this.read("[()]", buffer);
        }
        finally {
            this.closeConnection();
        }
    }

    public ISVNEditor getCommitEditor(String logMessage, ISVNWorkspaceMediator mediator) throws SVNException {
        try {
            this.openConnection();
            this.write("(w(s))", new Object[]{"commit", logMessage});
            this.authenticate();
            this.read("[()]", null);
            SVNCommitEditor editor = new SVNCommitEditor(this, this.myConnection, mediator, new Runnable(){

                public void run() {
                    SVNRepositoryImpl.this.closeConnection();
                }
            });
            return editor;
        }
        catch (SVNException e) {
            this.closeConnection();
            throw e;
        }
    }

    void updateCredentials(String uuid, String root) {
        if (this.getRepositoryRoot() != null) {
            return;
        }
        root = root == null ? this.getRepositoryRoot() : root;
        String string = uuid = uuid == null ? this.getRepositoryUUID() : uuid;
        if (root != null) {
            this.myFullRoot = root;
            root = root.startsWith("svn://") ? root.substring("svn://".length()) : root.substring("svn+ssh://".length());
            root = PathUtil.removeTrailingSlash(root);
            root = root.indexOf(47) >= 0 ? root.substring(root.indexOf(47)) : "/";
        }
        DebugLog.log("root: " + root);
        DebugLog.log("full root: " + this.myFullRoot);
        this.setRepositoryCredentials(uuid, root);
    }

    private void openConnection() throws SVNException {
        this.lock();
        ISVNConnector connector = SVNRepositoryFactoryImpl.getConnectorFactory().createConnector(this);
        this.myConnection = new SVNConnection(connector);
        this.myConnection.open(this);
        this.authenticate();
    }

    void authenticate() throws SVNException {
        if (this.myConnection != null) {
            this.myConnection.authenticate(this, this.myCredentials);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection() {
        if (this.myConnection != null) {
            try {
                this.myConnection.close();
            }
            catch (SVNException sVNException) {
            }
            finally {
                this.myConnection = null;
            }
        }
        this.unlock();
    }

    private void write(String template, Object[] values) throws SVNException {
        if (this.myConnection == null) {
            throw new SVNException("connection is closed, can't write");
        }
        this.myConnection.write(template, values);
    }

    private Object[] read(String template, Object[] values) throws SVNException {
        if (this.myConnection == null) {
            throw new SVNException("connection is closed, can't read");
        }
        return this.myConnection.read(template, values);
    }

    public void setPath(String path, long revision, boolean startEmpty) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(revision);
        this.write("(w(snw))", new Object[]{"set-path", path, SVNRepositoryImpl.getRevisionObject(revision), startEmpty});
    }

    public void deletePath(String path) throws SVNException {
        this.write("(w(s))", new Object[]{"delete-path", path});
    }

    public void linkPath(SVNRepositoryLocation repository, String path, long revison, boolean startEmtpy) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(revison);
        this.write("(w(ssnw))", new Object[]{"link-path", path, repository.toString(), SVNRepositoryImpl.getRevisionObject(revison), startEmtpy});
    }

    public void finishReport() throws SVNException {
        this.write("(w())", new Object[]{"finish-report"});
    }

    public void abortReport() throws SVNException {
        this.write("(w())", new Object[]{"abort-report"});
    }

    public String getRepositoryPath(String path) {
        if (path != null && path.startsWith("/")) {
            return path;
        }
        String fullPath = PathUtil.append(PathUtil.decode(this.getLocation().getPath()), path);
        if (fullPath.startsWith(this.getRepositoryRoot())) {
            fullPath = fullPath.substring(this.getRepositoryRoot().length());
        }
        if (!fullPath.startsWith("/")) {
            fullPath = "/" + fullPath;
        }
        return PathUtil.removeTrailingSlash(PathUtil.isEmpty(fullPath) ? "/" : fullPath);
    }

    public void setCredentials(ISVNCredentials credentials) {
        this.myCredentials = credentials;
    }

    public ISVNCredentials getCredentials() {
        return this.myCredentials;
    }

    public String getFullRoot() {
        return this.myFullRoot;
    }
}

