/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import org.tmatesoft.svn.core.internal.io.svn.ISVNConnectorFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNAuthRepository;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;

public final class SVNRepositoryFactoryImpl
extends SVNRepositoryFactory {
    private static ISVNConnectorFactory ourConnectorFactory;

    public static void setup() {
        SVNRepositoryFactoryImpl.setup(null);
    }

    public static void setup(ISVNConnectorFactory connectorFactory) {
        if (ourConnectorFactory == null) {
            ourConnectorFactory = connectorFactory == null ? ISVNConnectorFactory.DEFAULT : connectorFactory;
        }
        SVNRepositoryFactory.registerRepositoryFactory("^svn(\\+ssh)?://.*$", new SVNRepositoryFactoryImpl());
    }

    public SVNRepository createRepositoryImpl(SVNRepositoryLocation location) {
        if ("svn+ssh".equals(location.getProtocol())) {
            return new SVNRepositoryImpl(location);
        }
        return new SVNAuthRepository(location, new SVNRepositoryImpl(location));
    }

    static ISVNConnectorFactory getConnectorFactory() {
        return ourConnectorFactory;
    }
}

