/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.SocketFactory;

public class SVNPlainConnector
implements ISVNConnector {
    private Socket mySocket;
    private OutputStream myOutputStream;
    private InputStream myInputStream;

    public void open(SVNRepositoryImpl repository) throws SVNException {
        if (this.mySocket != null) {
            return;
        }
        try {
            SVNRepositoryLocation location = repository.getLocation();
            this.mySocket = SocketFactory.createPlainSocket(location.getHost(), location.getPort());
        }
        catch (IOException e) {
            throw new SVNException(e);
        }
    }

    public void close() throws SVNException {
        if (this.mySocket != null) {
            try {
                this.mySocket.close();
            }
            catch (IOException ex) {
                throw new SVNException(ex);
            }
            finally {
                this.mySocket = null;
            }
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.myInputStream == null) {
            this.myInputStream = this.mySocket.getInputStream();
        }
        return this.myInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.myOutputStream == null) {
            this.myOutputStream = this.mySocket.getOutputStream();
        }
        return this.myOutputStream;
    }
}

