/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.io.ISVNCredentials;
import org.tmatesoft.svn.core.io.ISVNSSHCredentials;
import org.tmatesoft.svn.core.io.SVNAuthenticationException;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.DebugLog;

public class SVNJSchSession {
    private static final int TIMEOUT = 10000;
    private static Map ourSessionsPool = new Hashtable();

    static Session getSession(SVNRepositoryLocation location, ISVNCredentials credentials) throws SVNAuthenticationException {
        if ("".equals(credentials.getName()) || credentials.getName() == null) {
            throw new SVNAuthenticationException("User name is required to establish svn+shh connection");
        }
        String key = credentials.getName() + ":" + location.getHost() + ":" + location.getPort();
        Session session = (Session)ourSessionsPool.get(key);
        if (session != null && !session.isConnected()) {
            ourSessionsPool.remove(key);
            DebugLog.log("SESSION " + key + " disposed");
            session = null;
        }
        try {
            if (session == null) {
                JSch jsch = new JSch();
                String privateKey = null;
                String passphrase = null;
                if (credentials instanceof ISVNSSHCredentials) {
                    ISVNSSHCredentials sshCredentials = (ISVNSSHCredentials)credentials;
                    privateKey = sshCredentials.getPrivateKeyID();
                    passphrase = sshCredentials.getPassphrase();
                    if (privateKey != null && passphrase != null) {
                        jsch.addIdentity(privateKey, passphrase);
                    } else if (privateKey != null) {
                        jsch.addIdentity(privateKey);
                    }
                }
                session = jsch.getSession(credentials.getName(), location.getHost(), location.getPort());
                EmptyUserInfo userInfo = new EmptyUserInfo(credentials.getPassword(), passphrase);
                session.setUserInfo((UserInfo)userInfo);
                session.setSocketFactory((SocketFactory)new SimpleSocketFactory());
                DebugLog.log("SESSION " + key + " created");
                session.setTimeout(10000);
                session.connect();
                session.setTimeout(0);
                ourSessionsPool.put(key, session);
                DebugLog.log("SESSION " + key + " connected");
            } else {
                DebugLog.log("SESSION " + key + " reused");
            }
            return session;
        }
        catch (JSchException e) {
            DebugLog.error(e);
            if (session != null && session.isConnected()) {
                session.disconnect();
                DebugLog.log("DISCONNECTING: " + session);
            }
            DebugLog.log("SESSION " + key + " diconnected");
            ourSessionsPool.remove(key);
            DebugLog.log("SESSION " + key + " disposed");
            throw new SVNAuthenticationException(e);
        }
    }

    public static void shutdown() {
        if (ourSessionsPool.size() > 0) {
            Iterator e = ourSessionsPool.values().iterator();
            while (e.hasNext()) {
                Session session = (Session)e.next();
                try {
                    session.disconnect();
                    DebugLog.log("DISCONNECTING: " + session);
                }
                catch (Exception exception) {}
            }
            ourSessionsPool.clear();
        }
    }

    private static class EmptyUserInfo
    implements UserInfo {
        private String myPassword;
        private String myPassphrase;

        public EmptyUserInfo(String password, String passphrase) {
            this.myPassword = password;
            this.myPassphrase = passphrase;
        }

        public String getPassphrase() {
            return this.myPassphrase;
        }

        public String getPassword() {
            return this.myPassword;
        }

        public boolean promptPassword(String arg0) {
            return this.myPassword != null;
        }

        public boolean promptPassphrase(String arg0) {
            return this.myPassphrase != null;
        }

        public boolean promptYesNo(String arg0) {
            return true;
        }

        public void showMessage(String arg0) {
            DebugLog.log("jsch message: " + arg0);
        }
    }

    private static class SimpleSocketFactory
    implements SocketFactory {
        private InputStream myInputStream = null;
        private OutputStream myOutputStream = null;

        private SimpleSocketFactory() {
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            Socket socket = null;
            socket = new Socket(host, port);
            socket.setKeepAlive(true);
            socket.setReuseAddress(true);
            return socket;
        }

        public InputStream getInputStream(Socket socket) throws IOException {
            if (this.myInputStream == null) {
                this.myInputStream = socket.getInputStream();
            }
            return this.myInputStream;
        }

        public OutputStream getOutputStream(Socket socket) throws IOException {
            if (this.myOutputStream == null) {
                this.myOutputStream = socket.getOutputStream();
            }
            return this.myOutputStream;
        }
    }
}

