/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.List;
import org.tmatesoft.svn.core.internal.io.svn.CramMD5;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.RollbackInputStream;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.io.svn.SVNWriter;
import org.tmatesoft.svn.core.io.ISVNCredentials;
import org.tmatesoft.svn.core.io.SVNAuthenticationException;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.LoggingInputStream;
import org.tmatesoft.svn.util.LoggingOutputStream;

class SVNConnection {
    private final ISVNConnector myConnector;
    private LoggingOutputStream myOutputStream;
    private LoggingInputStream myInputStream;
    private static final String SUCCESS = "success";
    private static final String FAILURE = "failure";
    private static final String STEP = "step";
    private static final String EDIT_PIPELINE = "edit-pipeline";
    private boolean myIsCredentialsReceived = false;

    public SVNConnection(ISVNConnector connector) {
        this.myConnector = connector;
    }

    public void open(SVNRepositoryImpl repository) throws SVNException {
        this.myIsCredentialsReceived = false;
        this.myConnector.open(repository);
        this.handshake(repository);
    }

    protected void handshake(SVNRepositoryImpl repository) throws SVNException {
        Object[] items = this.read("[(*N(*W)(*W))]", null);
        if (!SVNReader.hasValue(items, 0, 2) || !SVNReader.hasValue(items, 2, EDIT_PIPELINE)) {
            throw new SVNException("unsupported version or capability");
        }
        this.write("(n(w)s)", new Object[]{"2", EDIT_PIPELINE, repository.getLocation().toString()});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void authenticate(SVNRepositoryImpl repository, ISVNCredentials credentials) throws SVNException {
        CramMD5 authenticator;
        String mech;
        String failureReason = null;
        Object[] items = this.read("[((*W)?S)]", null);
        List mechs = SVNReader.getList(items, 0);
        if (mechs == null) return;
        if (mechs.size() == 0) {
            return;
        }
        int i = 0;
        while (true) {
            if (i >= mechs.size()) {
                throw new SVNException(failureReason);
            }
            mech = (String)mechs.get(i);
            if ("EXTERNAL".equals(mech)) {
                this.write("(w(s))", new Object[]{mech, credentials.getName()});
                failureReason = this.readAuthResponse(repository);
                if (failureReason == null) {
                    return;
                }
            } else if ("ANONYMOUS".equals(mech)) {
                this.write("(w())", new Object[]{mech});
                failureReason = this.readAuthResponse(repository);
                if (failureReason == null) {
                    return;
                }
            } else {
                if ("CRAM-MD5".equals(mech)) {
                    authenticator = new CramMD5();
                    if (credentials == null) {
                        throw new SVNAuthenticationException("authentication failed, no credentials");
                    }
                    break;
                }
                failureReason = mech + " authorization requested, but not supported";
            }
            ++i;
        }
        this.write("(w())", new Object[]{mech});
        while (true) {
            authenticator.setUserCredentials(credentials);
            items = this.read("(W(?B))", null);
            if (SUCCESS.equals(items[0])) {
                if (!this.myIsCredentialsReceived) {
                    Object[] creds = this.read("[(S?S)]", null);
                    if (creds != null && creds.length == 2 && creds[0] != null && creds[1] != null) {
                        repository.updateCredentials((String)creds[0], (String)creds[1]);
                    }
                    this.myIsCredentialsReceived = true;
                }
                return;
            }
            if (FAILURE.equals(items[0])) {
                failureReason = new String((byte[])items[1]);
                throw new SVNAuthenticationException("authentication failed: " + failureReason);
            }
            if (!STEP.equals(items[0])) continue;
            byte[] response = authenticator.buildChallengeReponse((byte[])items[1]);
            try {
                this.getOutputStream().write(response);
                continue;
            }
            catch (IOException e) {
                throw new SVNException(e);
            }
            finally {
                this.getOutputStream().log();
                continue;
            }
            break;
        }
    }

    private String readAuthResponse(SVNRepositoryImpl repository) throws SVNException {
        Object[] items = this.read("(W(?S))", null);
        if (SUCCESS.equals(items[0])) {
            if (!this.myIsCredentialsReceived) {
                Object[] creds = this.read("[(?S?S)]", null);
                if (repository != null && repository.getRepositoryRoot() == null) {
                    repository.updateCredentials((String)creds[0], (String)creds[1]);
                }
                this.myIsCredentialsReceived = true;
            }
            return null;
        }
        if (FAILURE.equals(items[0])) {
            return (String)items[1];
        }
        return "unexpected server responce";
    }

    public void close() throws SVNException {
        this.myConnector.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] read(String template, Object[] items) throws SVNException {
        try {
            Object[] objectArray = SVNReader.parse(this.getInputStream(), template, items);
            return objectArray;
        }
        finally {
            this.getInputStream().log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String template, Object[] items) throws SVNException {
        block7: {
            try {
                SVNWriter.write(this.getOutputStream(), template, items);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.getOutputStream().flush();
                }
                catch (IOException e) {
                }
                catch (SVNException e) {
                    // empty catch block
                }
                this.getOutputStream().log();
                throw throwable;
            }
            try {
                this.getOutputStream().flush();
                break block7;
            }
            catch (IOException e) {
                break block7;
            }
            catch (SVNException e) {
                // empty catch block
            }
            {
            }
        }
        this.getOutputStream().log();
    }

    public LoggingOutputStream getOutputStream() throws SVNException {
        if (this.myOutputStream == null) {
            try {
                this.myOutputStream = DebugLog.getLoggingOutputStream("svn", this.myConnector.getOutputStream());
                return this.myOutputStream;
            }
            catch (IOException ex) {
                throw new SVNException(ex);
            }
        }
        return this.myOutputStream;
    }

    public LoggingInputStream getInputStream() throws SVNException {
        if (this.myInputStream == null) {
            try {
                this.myInputStream = DebugLog.getLoggingInputStream("svn", new RollbackInputStream(new BufferedInputStream(this.myConnector.getInputStream())));
            }
            catch (IOException ex) {
                throw new SVNException(ex);
            }
        }
        return this.myInputStream;
    }
}

