/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.io.ISVNCredentials;
import org.tmatesoft.svn.core.io.ISVNCredentialsProvider;
import org.tmatesoft.svn.core.io.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNAuthenticationException;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNNodeKind;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.SVNUtil;

public class SVNAuthRepository
extends SVNRepository {
    private SVNRepositoryImpl myDelegate;

    public SVNAuthRepository(SVNRepositoryLocation location, SVNRepositoryImpl delegate) {
        super(location);
        this.myDelegate = delegate;
    }

    private ISVNCredentialsProvider initProvider() {
        ISVNCredentialsProvider provider = this.getCredentialsProvider();
        if (provider != null) {
            provider.reset();
        }
        return provider;
    }

    private void accept(ISVNCredentialsProvider provider, ISVNCredentials credentials) {
        if (credentials != null && provider != null) {
            provider.accepted(credentials);
        }
        this.setRepositoryCredentials(this.myDelegate.getRepositoryUUID(), this.myDelegate.getRepositoryRoot());
    }

    private void notAccept(ISVNCredentialsProvider provider, ISVNCredentials credentials, String msg) {
        if (credentials != null && provider != null) {
            provider.notAccepted(credentials, msg);
        }
    }

    private ISVNCredentials nextCredentials(ISVNCredentialsProvider provider, String msg) throws SVNException {
        if (provider == null) {
            throw new SVNAuthenticationException(msg);
        }
        ISVNCredentials creds = SVNUtil.nextCredentials(provider, this.getLocation(), msg);
        if (creds == null) {
            throw new SVNAuthenticationException(msg);
        }
        return creds;
    }

    public void testConnection() throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                this.myDelegate.testConnection();
                this.accept(provider, credentials);
                return;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public long getLatestRevision() throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                long revision = this.myDelegate.getLatestRevision();
                this.accept(provider, credentials);
                return revision;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public long getDatedRevision(Date date) throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                long revision = this.myDelegate.getDatedRevision(date);
                this.accept(provider, credentials);
                return revision;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public Map getRevisionProperties(long revision, Map properties) throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                properties = this.myDelegate.getRevisionProperties(revision, properties);
                this.accept(provider, credentials);
                return properties;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public void setRevisionPropertyValue(long revision, String propertyName, String propertyValue) throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                this.myDelegate.setRevisionPropertyValue(revision, propertyName, propertyValue);
                this.accept(provider, credentials);
                return;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public String getRevisionPropertyValue(long revision, String propertyName) throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                String value = this.myDelegate.getRevisionPropertyValue(revision, propertyName);
                this.accept(provider, credentials);
                return value;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public SVNNodeKind checkPath(String path, long revision) throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                SVNNodeKind kind = this.myDelegate.checkPath(path, revision);
                this.accept(provider, credentials);
                return kind;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public long getFile(String path, long revision, Map properties, OutputStream contents) throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                long rev = this.myDelegate.getFile(path, revision, properties, contents);
                this.accept(provider, credentials);
                return rev;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public long getDir(String path, long revision, Map properties, ISVNDirEntryHandler handler) throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                long rev = this.myDelegate.getDir(path, revision, properties, handler);
                this.accept(provider, credentials);
                return rev;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public int getFileRevisions(String path, long startRevision, long endRevision, ISVNFileRevisionHandler handler) throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                int count = this.myDelegate.getFileRevisions(path, startRevision, endRevision, handler);
                this.accept(provider, credentials);
                return count;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public int log(String[] targetPaths, long startRevision, long endRevision, boolean changedPath, boolean strictNode, ISVNLogEntryHandler handler) throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                int count = this.myDelegate.log(targetPaths, startRevision, endRevision, changedPath, strictNode, handler);
                this.accept(provider, credentials);
                return count;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public int getLocations(String path, long pegRevision, long[] revisions, ISVNLocationEntryHandler handler) throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                int count = this.myDelegate.getLocations(path, pegRevision, revisions, handler);
                this.accept(provider, credentials);
                return count;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public void diff(String url, long revision, String target, boolean ignoreAncestry, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                this.myDelegate.diff(url, revision, target, ignoreAncestry, recursive, reporter, editor);
                this.accept(provider, credentials);
                return;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public void update(long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                this.myDelegate.update(revision, target, recursive, reporter, editor);
                this.accept(provider, credentials);
                return;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public void status(long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                this.myDelegate.status(revision, target, recursive, reporter, editor);
                this.accept(provider, credentials);
                return;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public void update(String url, long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                this.myDelegate.update(url, revision, target, recursive, reporter, editor);
                this.accept(provider, credentials);
                return;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            break;
        }
    }

    public ISVNEditor getCommitEditor(String logMessage, ISVNWorkspaceMediator mediator) throws SVNException {
        ISVNCredentials credentials = null;
        ISVNCredentialsProvider provider = this.initProvider();
        while (true) {
            try {
                this.myDelegate.setCredentials(credentials);
                ISVNEditor editor = this.myDelegate.getCommitEditor(logMessage, mediator);
                this.accept(provider, credentials);
                return editor;
            }
            catch (SVNAuthenticationException e) {
                this.notAccept(provider, credentials, e.getMessage());
                credentials = this.nextCredentials(provider, e.getMessage());
                continue;
            }
            catch (SVNException e) {
                DebugLog.error(e);
                throw e;
            }
            break;
        }
    }
}

