/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

class RollbackInputStream
extends InputStream {
    private PushbackInputStream mySource;
    private byte[] myBuffer;
    private int myLength;

    public RollbackInputStream(InputStream source) {
        this.mySource = new PushbackInputStream(source, 256);
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        int read = this.mySource.read();
        if (this.myBuffer != null && this.myLength < this.myBuffer.length && this.myLength >= 0) {
            this.myBuffer[this.myLength] = (byte)read;
            ++this.myLength;
        } else {
            this.myLength = -1;
            this.myBuffer = null;
        }
        return read;
    }

    public synchronized void mark(int readlimit) {
        this.myBuffer = new byte[readlimit];
        this.myLength = 0;
    }

    public synchronized void reset() throws IOException {
        if (this.myLength < 0) {
            throw new IOException("maximum read limit exceeded");
        }
        if (this.myBuffer == null) {
            throw new IOException("mark was not set, buffer is null");
        }
        this.mySource.unread(this.myBuffer, 0, this.myLength);
        this.myBuffer = null;
        this.myLength = 0;
    }
}

