/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.xml.sax.Attributes;

public class DAVLocationsHandler
extends BasicDAVHandler {
    private static final DAVElement LOCATION_REPORT = DAVElement.getElement("svn:", "get-locations-report");
    private static final DAVElement LOCATION = DAVElement.getElement("svn:", "location");
    private ISVNLocationEntryHandler myLocationEntryHandler;
    private int myCount;

    public static StringBuffer generateLocationsRequest(StringBuffer buffer, String path, long pegRevision, long[] revisions) {
        buffer = buffer == null ? new StringBuffer() : buffer;
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        buffer.append("<S:get-locations xmlns:S=\"svn:\" xmlns:D=\"DAV:\" >");
        buffer.append("<S:path>");
        buffer.append(path);
        buffer.append("</S:path>");
        buffer.append("<S:peg-revision>");
        buffer.append(pegRevision);
        buffer.append("</S:peg-revision>");
        for (int i = 0; i < revisions.length; ++i) {
            buffer.append("<S:location-revision>");
            buffer.append(revisions[i]);
            buffer.append("</S:location-revision>");
        }
        buffer.append("</S:get-locations>");
        return buffer;
    }

    public DAVLocationsHandler(ISVNLocationEntryHandler handler) {
        this.myLocationEntryHandler = handler;
        this.init();
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) {
        String path;
        String revStr;
        if (parent == LOCATION_REPORT && element == LOCATION && (revStr = attrs.getValue("rev")) != null && (path = attrs.getValue("path")) != null && this.myLocationEntryHandler != null) {
            this.myLocationEntryHandler.handleLocationEntry(new SVNLocationEntry(Long.parseLong(revStr), path));
            ++this.myCount;
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
    }

    public int getEntriesCount() {
        return this.myCount;
    }
}

