/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.OutputStream;
import org.tmatesoft.svn.core.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVDeltaHandler;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.Base64;
import org.tmatesoft.svn.util.PathUtil;
import org.xml.sax.Attributes;

public class DAVEditorHandler
extends BasicDAVDeltaHandler {
    private static final DAVElement TARGET_REVISION = DAVElement.getElement("svn:", "target-revision");
    private static final DAVElement UPDATE_REPORT = DAVElement.getElement("svn:", "update-report");
    private static final DAVElement RESOURCE = DAVElement.getElement("svn:", "resource");
    private static final DAVElement OPEN_DIRECTORY = DAVElement.getElement("svn:", "open-directory");
    private static final DAVElement ADD_DIRECTORY = DAVElement.getElement("svn:", "add-directory");
    private static final DAVElement ABSENT_DIRECTORY = DAVElement.getElement("svn:", "absent-directory");
    private static final DAVElement OPEN_FILE = DAVElement.getElement("svn:", "open-file");
    private static final DAVElement ADD_FILE = DAVElement.getElement("svn:", "add-file");
    private static final DAVElement ABSENT_FILE = DAVElement.getElement("svn:", "absent-file");
    private static final DAVElement DELETE_ENTRY = DAVElement.getElement("svn:", "delete-entry");
    private static final DAVElement FETCH_PROPS = DAVElement.getElement("svn:", "fetch-props");
    private static final DAVElement SET_PROP = DAVElement.getElement("svn:", "set-prop");
    private static final DAVElement REMOVE_PROP = DAVElement.getElement("svn:", "remove-prop");
    private static final DAVElement FETCH_FILE = DAVElement.getElement("svn:", "fetch-file");
    private static final String REVISION_ATTR = "rev";
    private static final String NAME_ATTR = "name";
    private static final String ENCODING_ATTR = "encoding";
    private static final String COPYFROM_REV_ATTR = "copyfrom-rev";
    private static final String COPYFROM_PATH_ATTR = "copyfrom-path";
    private static final String SEND_ALL_ATTR = "send-all";
    private ISVNEditor myEditor;
    private StringBuffer myPath;
    private String myPropertyName;
    private String myChecksum;
    private String myEncoding;
    private boolean myIsFetchContent;

    public static StringBuffer generateEditorRequest(StringBuffer buffer, final String url, long targetRevision, String target, String dstPath, boolean recurse, boolean ignoreAncestry, boolean resourceWalk, ISVNReporterBaton reporterBaton) {
        buffer = buffer == null ? new StringBuffer() : buffer;
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        buffer.append("<S:update-report send-all=\"true\" xmlns:S=\"svn:\">\n");
        buffer.append("<S:src-path>");
        buffer.append(url);
        buffer.append("</S:src-path>\n");
        if (targetRevision >= 0L) {
            buffer.append("<S:target-revision>");
            buffer.append(targetRevision);
            buffer.append("</S:target-revision>\n");
        }
        if (target != null) {
            buffer.append("<S:update-target>");
            buffer.append(target);
            buffer.append("</S:update-target>\n");
        }
        if (dstPath != null) {
            buffer.append("<S:dst-path>");
            buffer.append(dstPath);
            buffer.append("</S:dst-path>\n");
        }
        if (!recurse) {
            buffer.append("<S:recursive>no</S:recursive>\n");
        }
        if (ignoreAncestry) {
            buffer.append("<S:ignore-ancestry>yes</S:ignore-ancestry>\n");
        }
        if (resourceWalk) {
            buffer.append("<S:resource-walk>yes</S:resource-walk>\n");
        }
        final StringBuffer report = buffer;
        try {
            reporterBaton.report(new ISVNReporter(){

                public void setPath(String path, long revision, boolean startEmpty) throws SVNException {
                    path = path.replaceAll(">", "&gt;");
                    path = path.replaceAll("<", "&lt;");
                    report.append("<S:entry rev=\"");
                    report.append(revision);
                    report.append("\" ");
                    if (startEmpty) {
                        report.append("start-empty=\"true\" ");
                    }
                    report.append(">");
                    report.append(path);
                    report.append("</S:entry>\n");
                }

                public void deletePath(String path) throws SVNException {
                    path = path.replaceAll(">", "&gt;");
                    path = path.replaceAll("<", "&lt;");
                    report.append("<S:missing>");
                    report.append(path);
                    report.append("</S:missing>\n");
                }

                public void linkPath(SVNRepositoryLocation repository, String path, long revision, boolean startEmpty) throws SVNException {
                    path = path.replaceAll(">", "&gt;");
                    path = path.replaceAll("<", "&lt;");
                    report.append("<S:entry rev=\"");
                    report.append(revision);
                    report.append("\" ");
                    if (startEmpty) {
                        report.append("start-empty=\"true\" ");
                    }
                    String switchUrl = repository.toString();
                    switchUrl = switchUrl.substring(url.length());
                    report.append("linkpath=\"");
                    report.append(switchUrl);
                    report.append("\" ");
                    report.append(">");
                    report.append(path);
                    report.append("</S:entry>\n");
                }

                public void finishReport() throws SVNException {
                }

                public void abortReport() throws SVNException {
                    throw new SVNException();
                }
            });
        }
        catch (SVNException e) {
            return null;
        }
        buffer.append("</S:update-report>");
        return buffer;
    }

    public DAVEditorHandler(ISVNEditor editor, boolean fetchContent) {
        this.myIsFetchContent = fetchContent;
        this.myEditor = editor;
        this.init();
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (element == UPDATE_REPORT) {
            String receiveAll = attrs.getValue(SEND_ALL_ATTR);
            if (receiveAll == null || !Boolean.valueOf(receiveAll).booleanValue()) {
                throw new SVNException("update-report format used by server is not supported");
            }
        } else if (element == TARGET_REVISION) {
            long revision = Long.parseLong(attrs.getValue(REVISION_ATTR));
            this.myEditor.targetRevision(revision);
        } else if (element == ABSENT_DIRECTORY) {
            String name = attrs.getValue(NAME_ATTR);
            this.myEditor.absentDir(DAVEditorHandler.append(this.myPath, name, true).toString());
        } else if (element == ABSENT_FILE) {
            String name = attrs.getValue(NAME_ATTR);
            this.myEditor.absentFile(DAVEditorHandler.append(this.myPath, name, false).toString());
        } else if (element == OPEN_DIRECTORY) {
            long revision = Long.parseLong(attrs.getValue(REVISION_ATTR));
            if (this.myPath == null) {
                this.myPath = new StringBuffer("");
                this.myEditor.openRoot(revision);
            } else {
                String name = attrs.getValue(NAME_ATTR);
                this.myPath = DAVEditorHandler.append(this.myPath, name, true);
                this.myEditor.openDir(this.myPath.toString(), revision);
            }
        } else if (element == ADD_DIRECTORY) {
            String name = attrs.getValue(NAME_ATTR);
            String copyFromPath = attrs.getValue(COPYFROM_PATH_ATTR);
            long copyFromRev = -1L;
            if (copyFromPath != null) {
                copyFromRev = Long.parseLong(attrs.getValue(COPYFROM_REV_ATTR));
            }
            this.myPath = DAVEditorHandler.append(this.myPath, name, true);
            this.myEditor.addDir(this.myPath.toString(), copyFromPath, copyFromRev);
        } else if (element == OPEN_FILE) {
            long revision = Long.parseLong(attrs.getValue(REVISION_ATTR));
            String name = attrs.getValue(NAME_ATTR);
            this.myPath = DAVEditorHandler.append(this.myPath, name, false);
            this.myEditor.openFile(this.myPath.toString(), revision);
        } else if (element == ADD_FILE) {
            String name = attrs.getValue(NAME_ATTR);
            this.myPath = DAVEditorHandler.append(this.myPath, name, false);
            String copyFromPath = attrs.getValue(COPYFROM_PATH_ATTR);
            long copyFromRev = -1L;
            if (copyFromPath != null) {
                copyFromRev = Long.parseLong(attrs.getValue(COPYFROM_REV_ATTR));
            }
            this.myEditor.addFile(this.myPath.toString(), copyFromPath, copyFromRev);
        } else if (element == DELETE_ENTRY) {
            String name = attrs.getValue(NAME_ATTR);
            this.myEditor.deleteEntry(PathUtil.append(this.myPath.toString(), name), -1L);
        } else if (element == SET_PROP) {
            this.myPropertyName = attrs.getValue(NAME_ATTR);
            this.myEncoding = attrs.getValue(ENCODING_ATTR);
        } else if (element == REMOVE_PROP) {
            String name = attrs.getValue(NAME_ATTR);
            if (DAVEditorHandler.isDir(this.myPath)) {
                this.myEditor.changeDirProperty(name, null);
            } else {
                this.myEditor.changeFileProperty(name, null);
            }
        } else {
            if (element == RESOURCE || element == FETCH_FILE || element == FETCH_PROPS) {
                throw new SVNException(element + " element is not supported in update-report");
            }
            if (element == TX_DELTA) {
                if (this.myIsFetchContent) {
                    this.setDeltaProcessing(true);
                }
                this.myEditor.applyTextDelta(this.myChecksum);
            }
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == OPEN_DIRECTORY || element == OPEN_FILE || element == ADD_DIRECTORY || element == ADD_FILE) {
            if (DAVEditorHandler.isDir(this.myPath)) {
                this.myEditor.closeDir();
                if ("".equals(this.myPath.toString()) || "/".equals(this.myPath.toString())) {
                    this.myEditor.closeEdit();
                }
            } else {
                this.myEditor.closeFile(this.myChecksum);
            }
            this.myChecksum = null;
            this.myPath = DAVEditorHandler.removeTail(this.myPath);
        } else if (element == DAVElement.MD5_CHECKSUM) {
            this.myChecksum = cdata.toString();
        } else if (element == DAVElement.CREATOR_DISPLAY_NAME || element == DAVElement.VERSION_NAME || element == DAVElement.CREATION_DATE || element == SET_PROP || element == DAVElement.HREF) {
            if (this.myPropertyName == null) {
                this.myPropertyName = DAVEditorHandler.computeWCPropertyName(element);
            }
            String value = cdata.toString();
            if ("base64".equals(this.myEncoding)) {
                value = new String(Base64.base64ToByteArray(cdata, null));
            }
            if (DAVEditorHandler.isDir(this.myPath)) {
                this.myEditor.changeDirProperty(this.myPropertyName, value);
            } else {
                this.myEditor.changeFileProperty(this.myPropertyName, value);
            }
            this.myPropertyName = null;
            this.myEncoding = null;
        } else if (element == TX_DELTA && this.myIsFetchContent) {
            this.setDeltaProcessing(false);
        }
    }

    private static String computeWCPropertyName(DAVElement element) {
        if (element == DAVElement.HREF) {
            return "svn:wc:ra_dav:version-url";
        }
        return "svn:entry:" + element.getName();
    }

    private static boolean isDir(StringBuffer path) {
        if (path.length() == 0) {
            return true;
        }
        return path.length() >= 1 && path.charAt(path.length() - 1) == '/';
    }

    private static StringBuffer append(StringBuffer buffer, String segment, boolean dir) {
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != '/') {
            buffer = buffer.append('/');
        }
        buffer = segment.charAt(0) == '/' ? buffer.append(segment.substring(1)) : buffer.append(segment);
        if (dir && !DAVEditorHandler.isDir(buffer)) {
            buffer = buffer.append('/');
        }
        return buffer;
    }

    private static StringBuffer removeTail(StringBuffer buffer) {
        int i;
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == '/') {
            buffer = buffer.delete(buffer.length() - 1, buffer.length());
        }
        for (i = buffer.length() - 1; i >= 0 && buffer.charAt(i) != '/'; --i) {
        }
        return buffer.delete(i + 1, buffer.length());
    }

    protected OutputStream handleDiffWindow(SVNDiffWindow window) throws SVNException {
        return this.myEditor.textDeltaChunk(window);
    }

    protected void handleDiffWindowClosed() throws SVNException {
        this.myEditor.textDeltaEnd();
    }
}

