/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.core.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.diff.SVNDiffWindowBuilder;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.Base64;
import org.xml.sax.SAXException;

public abstract class BasicDAVDeltaHandler
extends BasicDAVHandler {
    protected static final DAVElement TX_DELTA = DAVElement.getElement("svn:", "txdelta");
    private boolean myIsDeltaProcessing;
    private SVNDiffWindowBuilder myDiffBuilder;
    private StringBuffer myDeltaOutputStream;
    private byte[] myByteBuffer;

    protected void setDeltaProcessing(boolean processing) {
        this.myIsDeltaProcessing = processing;
        if (!this.myIsDeltaProcessing) {
            SVNDiffWindow window = null;
            OutputStream os = null;
            this.myByteBuffer = Base64.base64ToByteArray(this.myDeltaOutputStream, this.myByteBuffer);
            if (Base64.lastLength() == 4) {
                try {
                    this.handleDiffWindowClosed();
                }
                catch (SVNException e) {
                    // empty catch block
                }
                return;
            }
            int newOffset = this.myDiffBuilder.accept(this.myByteBuffer, 0);
            window = this.myDiffBuilder.getDiffWindow();
            while (window != null) {
                try {
                    os = this.handleDiffWindow(window);
                    os.write(this.myByteBuffer, newOffset, (int)window.getNewDataLength());
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (SVNException e) {
                    e.printStackTrace();
                }
                if ((newOffset += (int)window.getNewDataLength()) < Base64.lastLength()) {
                    this.myDiffBuilder.reset(1);
                    newOffset = this.myDiffBuilder.accept(this.myByteBuffer, newOffset);
                    window = this.myDiffBuilder.getDiffWindow();
                    continue;
                }
                window = null;
            }
            try {
                this.handleDiffWindowClosed();
            }
            catch (SVNException e) {
                e.printStackTrace();
            }
        } else {
            this.myDiffBuilder.reset();
            this.myDeltaOutputStream.delete(0, this.myDeltaOutputStream.length());
        }
    }

    protected void init() {
        this.myDiffBuilder = SVNDiffWindowBuilder.newInstance();
        this.myDeltaOutputStream = new StringBuffer();
        super.init();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.myIsDeltaProcessing) {
            int offset = start;
            for (int i = start; i < start + length; ++i) {
                if (ch[i] != '\r' && ch[i] != '\n') continue;
                this.myDeltaOutputStream.append(ch, offset, i - offset);
                offset = i + 1;
                if (i + 1 >= start + length || ch[i + 1] != '\n') continue;
                ++offset;
                ++i;
            }
            if (offset < start + length) {
                this.myDeltaOutputStream.append(ch, offset, start + length - offset);
            }
        } else {
            super.characters(ch, start, length);
        }
    }

    protected abstract OutputStream handleDiffWindow(SVNDiffWindow var1) throws SVNException;

    protected abstract void handleDiffWindowClosed() throws SVNException;
}

