/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.tmatesoft.svn.core.internal.io.dav.ChunkedInputStream;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.dav.DAVStatus;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.FixedSizeInputStream;
import org.tmatesoft.svn.core.internal.io.dav.HttpDigestAuth;
import org.tmatesoft.svn.core.internal.io.dav.IDAVProxyManager;
import org.tmatesoft.svn.core.internal.io.dav.XMLInputStream;
import org.tmatesoft.svn.core.io.ISVNCredentials;
import org.tmatesoft.svn.core.io.ISVNCredentialsProvider;
import org.tmatesoft.svn.core.io.SVNAuthenticationException;
import org.tmatesoft.svn.core.io.SVNCancelException;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.Base64;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.LoggingInputStream;
import org.tmatesoft.svn.util.LoggingOutputStream;
import org.tmatesoft.svn.util.PathUtil;
import org.tmatesoft.svn.util.SVNUtil;
import org.tmatesoft.svn.util.SocketFactory;
import org.tmatesoft.svn.util.Version;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class HttpConnection {
    private LoggingOutputStream myOutputStream;
    private InputStream myInputStream;
    private Socket mySocket;
    private SVNRepositoryLocation mySVNRepositoryLocation;
    private SAXParser mySAXParser;
    private int myConnectCount;
    private static SAXParserFactory ourSAXParserFactory;
    private ISVNCredentials myLastUsedCredentials;
    private ISVNCredentialsProvider myUserCredentialsProvider;
    private Map myCredentialsChallenge;
    private static final char[] CRLF;
    private static final byte[] CRLF_BYTES;
    static /* synthetic */ Class class$java$net$SocketTimeoutException;

    public HttpConnection(SVNRepositoryLocation location, ISVNCredentialsProvider provider) {
        this.mySVNRepositoryLocation = location;
        this.myUserCredentialsProvider = provider;
    }

    public void connect() throws IOException {
        if (this.mySocket == null || this.isStale()) {
            if (this.mySocket != null) {
                DebugLog.log("connection is silently closed by server, forcing reconnect.");
            }
            this.close();
            String host = this.mySVNRepositoryLocation.getHost();
            int port = this.mySVNRepositoryLocation.getPort();
            IDAVProxyManager proxyManager = DAVRepositoryFactory.getProxyManager();
            String proxyHost = proxyManager.getProxyHost(this.mySVNRepositoryLocation);
            int proxyPort = proxyManager.getProxyPort(this.mySVNRepositoryLocation);
            if (proxyManager.isProxyEnabled(this.mySVNRepositoryLocation) && proxyPort > 0 && proxyHost != null) {
                this.mySocket = SocketFactory.createPlainSocket(proxyHost, proxyPort);
                if (this.isSecured()) {
                    HashMap<String, String> props = new HashMap<String, String>();
                    if (this.getProxyAuthString() != null) {
                        props.put("Proxy-Authorization", this.getProxyAuthString());
                    }
                    this.myOutputStream = DebugLog.getLoggingOutputStream("http", this.mySocket.getOutputStream());
                    this.sendHeader("CONNECT", this.mySVNRepositoryLocation.getHost() + ":" + this.mySVNRepositoryLocation.getPort(), props, null);
                    this.myOutputStream.flush();
                    DAVStatus status = this.readHeader(new HashMap());
                    if (status != null && status.getResponseCode() == 200) {
                        this.myInputStream = null;
                        this.myOutputStream = null;
                        this.mySocket = SocketFactory.createSSLSocket(DAVRepositoryFactory.getSSLManager(), host, port, this.mySocket);
                        return;
                    }
                    throw new IOException("couldn't establish http tunnel for proxied secure connection: " + (status != null ? status.getErrorText() + "" : " for unknow reason"));
                }
            } else {
                this.mySocket = this.isSecured() ? SocketFactory.createSSLSocket(DAVRepositoryFactory.getSSLManager(), host, port) : SocketFactory.createPlainSocket(host, port);
            }
            ++this.myConnectCount;
        }
    }

    private boolean isSecured() {
        return "https".equals(this.mySVNRepositoryLocation.getProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStale() throws IOException {
        boolean isStale;
        block10: {
            isStale = true;
            if (this.mySocket != null) {
                isStale = false;
                try {
                    if (this.mySocket.getInputStream().available() != 0) break block10;
                    int timeout = this.mySocket.getSoTimeout();
                    try {
                        this.mySocket.setSoTimeout(1);
                        this.mySocket.getInputStream().mark(1);
                        int byteRead = this.mySocket.getInputStream().read();
                        if (byteRead == -1) {
                            isStale = true;
                        } else {
                            this.mySocket.getInputStream().reset();
                        }
                    }
                    finally {
                        this.mySocket.setSoTimeout(timeout);
                    }
                }
                catch (InterruptedIOException e) {
                    if (!(class$java$net$SocketTimeoutException == null ? (class$java$net$SocketTimeoutException = HttpConnection.class$("java.net.SocketTimeoutException")) : class$java$net$SocketTimeoutException).isInstance(e)) {
                        throw e;
                    }
                }
                catch (IOException e) {
                    isStale = true;
                }
            }
        }
        return isStale;
    }

    public void close() {
        if (this.mySocket != null) {
            try {
                if (this.myOutputStream != null) {
                    this.myOutputStream.log();
                    this.myOutputStream.flush();
                }
                this.mySocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mySocket = null;
            this.myOutputStream = null;
            this.myInputStream = null;
        }
    }

    public DAVStatus request(String method, String path, Map header, InputStream body, DefaultHandler handler, int[] okCodes) throws SVNException {
        DAVStatus status = this.sendRequest(method, path, HttpConnection.initHeader(0, null, header), body);
        this.assertOk(status, okCodes);
        this.readResponse(handler, status.getResponseHeader());
        return status;
    }

    public DAVStatus request(String method, String path, Map header, StringBuffer reqBody, DefaultHandler handler, int[] okCodes) throws SVNException {
        DAVStatus status = this.sendRequest(method, path, HttpConnection.initHeader(0, null, header), reqBody, okCodes);
        this.readResponse(handler, status.getResponseHeader());
        return status;
    }

    public DAVStatus request(String method, String path, int depth, String label, StringBuffer requestBody, OutputStream result, int[] okCodes) throws SVNException {
        DAVStatus status = this.sendRequest(method, path, HttpConnection.initHeader(depth, label, null), requestBody, okCodes);
        this.readResponse(result, status.getResponseHeader());
        return status;
    }

    public DAVStatus request(String method, String path, int depth, String label, StringBuffer requestBody, DefaultHandler handler, int[] okCodes) throws SVNException {
        DAVStatus status = this.sendRequest(method, path, HttpConnection.initHeader(depth, label, null), requestBody, okCodes);
        this.readResponse(handler, status.getResponseHeader());
        return status;
    }

    private DAVStatus sendRequest(String method, String path, Map header, StringBuffer requestBody, int[] okCodes) throws SVNException {
        byte[] request = null;
        if (requestBody != null) {
            try {
                request = requestBody.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                request = requestBody.toString().getBytes();
            }
        }
        DAVStatus status = this.sendRequest(method, path, header, request != null ? new ByteArrayInputStream(request) : null);
        this.assertOk(status, okCodes);
        return status;
    }

    private DAVStatus sendRequest(String method, String path, Map header, InputStream requestBody) throws SVNException {
        HashMap readHeader = new HashMap();
        if (this.myUserCredentialsProvider != null) {
            this.myUserCredentialsProvider.reset();
        }
        path = PathUtil.removeTrailingSlash(path);
        if (this.myCredentialsChallenge != null) {
            this.myCredentialsChallenge.put("methodname", method);
            this.myCredentialsChallenge.put("uri", path);
        }
        ISVNCredentials credentials = this.myLastUsedCredentials;
        do {
            DAVStatus status = null;
            try {
                this.connect();
                if (credentials != null && this.myCredentialsChallenge != null) {
                    header.put("Authorization", HttpConnection.composeAuthResponce(credentials, this.myCredentialsChallenge));
                }
                this.sendHeader(method, path, header, requestBody);
                this.logOutputStream();
                readHeader.clear();
                status = this.readHeader(readHeader);
            }
            catch (IOException e) {
                this.logOutputStream();
                this.close();
                this.acknowledgeSSLContext(false);
                throw new SVNException(e);
            }
            this.acknowledgeSSLContext(true);
            if (status != null && (status.getResponseCode() == 401 || status.getResponseCode() == 403)) {
                this.myLastUsedCredentials = null;
                try {
                    this.skipRequestBody(readHeader);
                }
                catch (IOException e1) {
                    // empty catch block
                }
                this.close();
                this.myCredentialsChallenge = DAVUtil.parseAuthParameters((String)readHeader.get("WWW-Authenticate"));
                if (this.myCredentialsChallenge == null) {
                    throw new SVNAuthenticationException("Authentication challenge is not supported:\n" + (String)readHeader.get("WWW-Authenticate"));
                }
                this.myCredentialsChallenge.put("methodname", method);
                this.myCredentialsChallenge.put("uri", path);
                String realm = (String)this.myCredentialsChallenge.get("realm");
                if (this.myUserCredentialsProvider == null) {
                    throw new SVNAuthenticationException("No credentials defined");
                }
                if (credentials != null) {
                    this.myUserCredentialsProvider.notAccepted(credentials, "forbidden");
                }
                if ((credentials = SVNUtil.nextCredentials(this.myUserCredentialsProvider, this.mySVNRepositoryLocation, realm)) == null) {
                    throw new SVNAuthenticationException("Authentication failed");
                }
                if (requestBody instanceof ByteArrayInputStream) {
                    ((ByteArrayInputStream)requestBody).reset();
                    continue;
                }
                if (requestBody == null) continue;
                throw new SVNAuthenticationException("Authentication failed");
            }
            if (status != null) {
                if (credentials != null && this.myUserCredentialsProvider != null) {
                    this.myUserCredentialsProvider.accepted(credentials);
                }
                this.myLastUsedCredentials = credentials;
                status.setResponseHeader(readHeader);
                return status;
            }
            this.close();
            throw new SVNException("can't connect");
        } while (credentials != null);
        this.close();
        throw new SVNCancelException();
    }

    private void readError(DAVStatus status) throws SVNException {
        StringBuffer text = new StringBuffer();
        LoggingInputStream stream = null;
        try {
            try {
                int count;
                stream = HttpConnection.createInputStream(status.getResponseHeader(), this.getInputStream());
                byte[] buffer = new byte[1024];
                while ((count = stream.read(buffer)) > 0) {
                    text.append(new String(buffer, 0, count));
                }
                Object var7_7 = null;
                this.logInputStream(stream);
                this.close();
                status.setErrorText(text.toString());
            }
            catch (IOException e) {
                throw new SVNException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.logInputStream(stream);
            this.close();
            status.setErrorText(text.toString());
            throw throwable;
        }
    }

    private void readResponse(OutputStream result, Map responseHeader) throws SVNException {
        LoggingInputStream stream = null;
        try {
            int count;
            stream = HttpConnection.createInputStream(responseHeader, this.getInputStream());
            byte[] buffer = new byte[1024];
            while ((count = stream.read(buffer)) > 0) {
                if (result == null) continue;
                result.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new SVNException(e);
        }
        finally {
            this.logInputStream(stream);
            this.finishResponse(responseHeader);
        }
    }

    private void readResponse(DefaultHandler handler, Map responseHeader) throws SVNException {
        LoggingInputStream is = null;
        try {
            is = HttpConnection.createInputStream(responseHeader, this.getInputStream());
            XMLInputStream xmlIs = new XMLInputStream(is);
            if (handler == null) {
                int r;
                while ((r = is.read()) >= 0) {
                }
            } else {
                if (this.mySAXParser == null) {
                    this.mySAXParser = HttpConnection.getSAXParserFactory().newSAXParser();
                }
                while (!xmlIs.isClosed()) {
                    this.mySAXParser.parse((InputStream)xmlIs, handler);
                }
            }
        }
        catch (SAXException e) {
            if (e instanceof SAXParseException) {
                return;
            }
            if (e.getCause() instanceof SVNException) {
                throw (SVNException)e.getCause();
            }
            throw new SVNException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SVNException(e);
        }
        catch (EOFException e) {
        }
        catch (IOException e) {
            throw new SVNException(e);
        }
        finally {
            this.logInputStream(is);
            this.finishResponse(responseHeader);
        }
    }

    private void sendHeader(String method, String path, Map header, InputStream requestBody) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append(method);
        sb.append(' ');
        boolean isProxied = DAVRepositoryFactory.getProxyManager().isProxyEnabled(this.mySVNRepositoryLocation);
        if (isProxied && !this.isSecured()) {
            sb.append("http://");
            sb.append(this.mySVNRepositoryLocation.getHost());
            sb.append(":");
            sb.append(this.mySVNRepositoryLocation.getPort());
        }
        DAVUtil.getCanonicalPath(path, sb);
        sb.append(' ');
        sb.append("HTTP/1.1");
        sb.append(CRLF);
        sb.append("Host: ");
        sb.append(this.mySVNRepositoryLocation.getHost());
        sb.append(":");
        sb.append(this.mySVNRepositoryLocation.getPort());
        sb.append(CRLF);
        sb.append("User-Agent: ");
        sb.append(Version.getVersionString());
        sb.append(CRLF);
        sb.append("Keep-Alive:");
        sb.append(CRLF);
        sb.append("Connection: TE, Keep-Alive");
        sb.append(CRLF);
        sb.append("TE: trailers");
        sb.append(CRLF);
        if (isProxied && !this.isSecured() && this.getProxyAuthString() != null) {
            sb.append("Proxy-Authorization: " + this.getProxyAuthString());
            sb.append(CRLF);
        }
        boolean chunked = false;
        if (requestBody instanceof ByteArrayInputStream) {
            sb.append("Content-Length: ");
            sb.append(((ByteArrayInputStream)requestBody).available());
        } else if (requestBody != null) {
            sb.append("Transfer-Encoding: chunked");
            chunked = true;
        } else {
            sb.append("Content-Lenght: 0");
        }
        sb.append(CRLF);
        sb.append("Accept-Encoding: gzip");
        sb.append(CRLF);
        if (header != null) {
            if (!header.containsKey("Content-Type")) {
                sb.append("Content-Type: text/xml; charset=\"utf-8\"");
                sb.append(CRLF);
            }
            Iterator keys = header.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                sb.append(key.toString());
                sb.append(": ");
                sb.append(header.get(key).toString());
                sb.append(CRLF);
            }
        }
        this.getOutputStream().write(sb.toString().getBytes());
        this.getOutputStream().write(CRLF_BYTES);
        if (requestBody != null) {
            byte[] buffer = new byte[2048];
            while (true) {
                int read = requestBody.read(buffer);
                if (chunked) {
                    if (read > 0) {
                        this.getOutputStream().write(Integer.toHexString(read).getBytes());
                        this.getOutputStream().write(CRLF_BYTES);
                        this.getOutputStream().write(buffer, 0, read);
                        this.getOutputStream().write(CRLF_BYTES);
                        continue;
                    }
                    this.getOutputStream().write(48);
                    this.getOutputStream().write(CRLF_BYTES);
                    this.getOutputStream().write(CRLF_BYTES);
                    break;
                }
                if (read <= 0) break;
                this.getOutputStream().write(buffer, 0, read);
            }
        }
        this.getOutputStream().flush();
    }

    private DAVStatus readHeader(Map headerProperties) throws IOException {
        return this.readHeader(headerProperties, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DAVStatus readHeader(Map headerProperties, boolean firstLineOnly) throws IOException {
        DAVStatus responseCode = null;
        StringBuffer line = new StringBuffer();
        LoggingInputStream is = DebugLog.getLoggingInputStream("http", this.getInputStream());
        boolean firstLine = true;
        try {
            while (true) {
                String lineStr;
                DAVStatus dAVStatus;
                int read;
                if ((read = is.read()) < 0) {
                    dAVStatus = null;
                    return dAVStatus;
                }
                if (read != 10 && read != 13) {
                    line.append((char)read);
                    continue;
                }
                if (read == 13) {
                    is.mark(1);
                    read = is.read();
                    if (read < 0) {
                        dAVStatus = null;
                        return dAVStatus;
                    }
                    if (read != 10) {
                        is.reset();
                    }
                    if (firstLineOnly) {
                        dAVStatus = DAVStatus.parse(line.toString());
                        return dAVStatus;
                    }
                }
                if ((lineStr = line.toString()).trim().length() == 0) {
                    if (firstLine) {
                        line = new StringBuffer();
                        firstLine = false;
                        continue;
                    }
                    break;
                }
                firstLine = false;
                int index = line.indexOf(":");
                if (index >= 0 && headerProperties != null) {
                    String name = line.substring(0, index);
                    String value = line.substring(index + 1);
                    headerProperties.put(name.trim(), value.trim());
                } else if (responseCode == null) {
                    responseCode = DAVStatus.parse(lineStr);
                }
                line.delete(0, line.length());
            }
        }
        finally {
            is.log();
        }
        return responseCode;
    }

    private void skipRequestBody(Map header) throws IOException {
        LoggingInputStream is = HttpConnection.createInputStream(header, this.getInputStream());
        while (((InputStream)is).skip(2048L) > 0L) {
        }
    }

    private LoggingOutputStream getOutputStream() throws IOException {
        if (this.myOutputStream == null) {
            if (this.mySocket == null) {
                return null;
            }
            this.myOutputStream = DebugLog.getLoggingOutputStream("http", new BufferedOutputStream(this.mySocket.getOutputStream(), 2048));
        }
        return this.myOutputStream;
    }

    private InputStream getInputStream() throws IOException {
        if (this.myInputStream == null) {
            if (this.mySocket == null) {
                return null;
            }
            this.myInputStream = new BufferedInputStream(this.mySocket.getInputStream(), 2048);
        }
        return this.myInputStream;
    }

    private static LoggingInputStream createInputStream(Map readHeader, InputStream is) throws IOException {
        if (readHeader.get("Content-Length") != null) {
            is = new FixedSizeInputStream(is, Long.parseLong(readHeader.get("Content-Length").toString()));
        } else if ("chunked".equals(readHeader.get("Transfer-Encoding"))) {
            is = new ChunkedInputStream(is);
        }
        if ("gzip".equals(readHeader.get("Content-Encoding"))) {
            DebugLog.log("using GZIP to decode server responce");
            is = new GZIPInputStream(is);
        }
        return DebugLog.getLoggingInputStream("http", is);
    }

    private static String composeAuthResponce(ISVNCredentials credentials, Map credentialsChallenge) throws SVNAuthenticationException {
        String method = (String)credentialsChallenge.get("");
        StringBuffer result = new StringBuffer();
        if ("basic".equalsIgnoreCase(method)) {
            String auth = credentials.getName() + ":" + credentials.getPassword();
            auth = Base64.byteArrayToBase64(auth.getBytes());
            result.append("Basic ");
            result.append(auth);
        } else if ("digest".equalsIgnoreCase(method)) {
            result.append("Digest ");
            HttpDigestAuth digestAuth = new HttpDigestAuth(credentials, credentialsChallenge);
            String response = digestAuth.authenticate();
            result.append(response);
        } else {
            throw new SVNAuthenticationException("Authentication method '" + method + "' is not supported");
        }
        return result.toString();
    }

    private static synchronized SAXParserFactory getSAXParserFactory() throws FactoryConfigurationError, ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (ourSAXParserFactory == null) {
            ourSAXParserFactory = SAXParserFactory.newInstance();
            ourSAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            ourSAXParserFactory.setNamespaceAware(true);
            ourSAXParserFactory.setValidating(false);
        }
        return ourSAXParserFactory;
    }

    private void assertOk(DAVStatus status, int[] codes) throws SVNException {
        int code = status.getResponseCode();
        if (codes == null) {
            if (code >= 200 && code < 300) {
                return;
            }
            this.readError(status);
            throw new SVNException("server reports an error: " + status);
        }
        for (int i = 0; i < codes.length; ++i) {
            if (code != codes[i]) continue;
            return;
        }
        this.readError(status);
        throw new SVNException("server reports an error: " + status);
    }

    private static Map initHeader(int depth, String label, Map map) {
        Map map2 = map = map == null ? new HashMap() : map;
        if (label != null && !map.containsKey("Label")) {
            map.put("Label", label);
        }
        if (!map.containsKey("Depth")) {
            if (depth == 1 || depth == 0) {
                map.put("Depth", Integer.toString(depth));
            } else {
                map.put("Depth", "infinity");
            }
        }
        return map;
    }

    private void acknowledgeSSLContext(boolean accepted) {
        if (this.mySVNRepositoryLocation == null || !"https".equalsIgnoreCase(this.mySVNRepositoryLocation.getProtocol())) {
            return;
        }
        String host = this.mySVNRepositoryLocation.getHost();
        int port = this.mySVNRepositoryLocation.getPort();
        DAVRepositoryFactory.getSSLManager().acknowledgeSSLContext(host, port, accepted);
    }

    private void finishResponse(Map readHeader) {
        if (this.myOutputStream != null) {
            try {
                this.myOutputStream.flush();
            }
            catch (IOException ex) {
                new SVNException(ex);
            }
        }
        if ("close".equals(readHeader.get("Connection")) || "close".equals(readHeader.get("Proxy-Connection"))) {
            DebugLog.log("closing connection due to server request");
            this.close();
        }
    }

    private void logInputStream(LoggingInputStream is) {
        if (is != null) {
            is.log();
        }
    }

    private void logOutputStream() {
        try {
            if (this.getOutputStream() != null) {
                this.getOutputStream().log();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getProxyAuthString() {
        String username = DAVRepositoryFactory.getProxyManager().getProxyUserName(this.mySVNRepositoryLocation);
        String password = DAVRepositoryFactory.getProxyManager().getProxyPassword(this.mySVNRepositoryLocation);
        if (username != null && password != null) {
            String auth = username + ":" + password;
            return "Basic " + Base64.byteArrayToBase64(auth.getBytes());
        }
        return null;
    }

    private static boolean readConnectResponce(InputStream is) {
        int index1;
        StringBuffer responce = new StringBuffer();
        try {
            while (true) {
                int r;
                if ((r = is.read()) < 0) {
                    is.reset();
                    return false;
                }
                responce.append((char)r);
                if (r != 13 && r != 10) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                is.reset();
            }
            catch (IOException e1) {
                // empty catch block
            }
            return false;
        }
        String responceStr = responce.toString();
        int index0 = responceStr.indexOf(32);
        if (index0 >= 0 && (index1 = responceStr.indexOf(32, index0 + 1)) >= 0) {
            String code = responceStr.substring(index0 + 1, index1);
            try {
                int codeValue = Integer.parseInt(code);
                if (codeValue >= 200 && codeValue < 300) {
                    int r;
                    while (!responce.toString().endsWith("\r\n\r\n") && (r = is.read()) >= 0) {
                        responce.append((char)r);
                    }
                    return true;
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        try {
            is.reset();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CRLF = new char[]{'\r', '\n'};
        CRLF_BYTES = new byte[]{13, 10};
    }
}

