/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.util.Map;

public class DAVStatus {
    private int myResponseCode;
    private String myMessage;
    private Map myResponseHeader;
    private String myText;
    private String myHTTP;

    public static DAVStatus parse(String str) {
        int code = -1;
        String message = null;
        String http = null;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (sb.length() == 0) continue;
                if (http == null) {
                    http = sb.toString();
                } else if (code < 0) {
                    code = Integer.parseInt(sb.toString());
                } else {
                    sb.append(ch);
                    continue;
                }
                sb = sb.delete(0, sb.length());
                continue;
            }
            sb.append(ch);
        }
        if (message == null) {
            message = sb.toString();
        }
        return new DAVStatus(code, message, http);
    }

    public DAVStatus(int responseCode, String message, String http) {
        this.myResponseCode = responseCode;
        this.myMessage = message;
        this.myHTTP = http;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public int getResponseCode() {
        return this.myResponseCode;
    }

    public Map getResponseHeader() {
        return this.myResponseHeader;
    }

    public void setResponseHeader(Map header) {
        this.myResponseHeader = header;
    }

    public boolean isHTTP10() {
        return this.myHTTP != null && this.myHTTP.endsWith("/1.0");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getResponseCode());
        sb.append(':');
        sb.append(this.getMessage());
        if (this.myText != null) {
            sb.append("\n");
            sb.append(this.myText);
        }
        return sb.toString();
    }

    public void setErrorText(String text) {
        this.myText = text;
    }

    public String getErrorText() {
        return this.myText;
    }
}

