/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;

class DAVResource {
    private String myWURL;
    private String myVURL;
    private String myURL;
    private String myPath;
    private ISVNWorkspaceMediator myMediator;
    private long myRevision;
    private boolean myIsCopy;
    private DAVConnection myConnection;
    private List myDeltaFiles;
    private Map myProperties;

    public DAVResource(ISVNWorkspaceMediator mediator, DAVConnection connection, String path, long revision) {
        this(mediator, connection, path, revision, false);
    }

    public DAVResource(ISVNWorkspaceMediator mediator, DAVConnection connection, String path, long revision, boolean isCopy) {
        this.myPath = path;
        this.myMediator = mediator;
        this.myURL = PathUtil.append(connection.getLocation().getPath(), path);
        this.myRevision = revision;
        this.myConnection = connection;
        this.myIsCopy = isCopy;
    }

    public boolean isCopy() {
        return this.myIsCopy;
    }

    public String getURL() {
        return this.myURL;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getVersionURL() throws SVNException {
        if (this.myVURL == null) {
            if (this.myMediator != null) {
                this.myVURL = this.myMediator.getWorkspaceProperty(this.myPath, "svn:wc:ra_dav:version-url");
                DebugLog.log("cached vURL for " + this.myPath + " : " + this.myVURL);
                if (this.myVURL != null) {
                    return this.myVURL;
                }
            }
            String path = this.myURL;
            if (this.myRevision >= 0L) {
                DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, path, this.myRevision, false, false, null);
                DebugLog.log("base line path: " + info.baselineBase + " + " + info.baselinePath);
                path = PathUtil.append(info.baselineBase, info.baselinePath);
            }
            this.myVURL = (String)DAVUtil.getPropertyValue(this.myConnection, path, null, DAVElement.CHECKED_IN);
        }
        return this.myVURL;
    }

    public String getWorkingURL() {
        return this.myWURL;
    }

    public OutputStream addTextDelta() throws IOException {
        if (this.myDeltaFiles == null) {
            this.myDeltaFiles = new LinkedList();
        }
        if (this.myMediator != null) {
            Integer id = new Integer(this.myDeltaFiles.size());
            this.myDeltaFiles.add(id);
            return this.myMediator.createTemporaryLocation(PathUtil.decode(this.myPath), id);
        }
        File tempFile = File.createTempFile("svn", "temp");
        tempFile.deleteOnExit();
        this.myDeltaFiles.add(tempFile);
        return new BufferedOutputStream(new FileOutputStream(tempFile));
    }

    public int getDeltaCount() {
        return this.myDeltaFiles == null ? 0 : this.myDeltaFiles.size();
    }

    public InputStream getTextDelta(int i) throws IOException {
        if (this.myMediator != null) {
            return this.myMediator.getTemporaryLocation(new Integer(i));
        }
        File file = (File)this.myDeltaFiles.get(i);
        return new BufferedInputStream(new FileInputStream(file));
    }

    public void dispose() {
        if (this.myDeltaFiles != null) {
            Iterator values = this.myDeltaFiles.iterator();
            while (values.hasNext()) {
                if (this.myMediator != null) {
                    this.myMediator.deleteTemporaryLocation(values.next());
                    continue;
                }
                File file = (File)values.next();
                file.delete();
            }
        }
        this.myDeltaFiles = null;
        this.myProperties = null;
    }

    public void setWorkingURL(String location) {
        this.myWURL = location;
    }

    public void putProperty(String name, String value) {
        if (this.myProperties == null) {
            this.myProperties = new HashMap();
        }
        this.myProperties.put(name, value);
    }

    public Map getProperties() {
        return this.myProperties;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.myURL);
        sb.append("][");
        sb.append(this.myVURL);
        sb.append("][");
        sb.append(this.myWURL);
        sb.append("]");
        return sb.toString();
    }
}

