/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceLine;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceLineReader;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceMedia;
import org.tmatesoft.svn.core.internal.ws.fs.FSUtil;
import org.tmatesoft.svn.core.internal.ws.fs.SVNRAFileData;
import org.tmatesoft.svn.core.io.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.TimeUtil;

public class SVNAnnotate
implements ISVNFileRevisionHandler {
    private Map myDiffWindowsMap;
    private List myDiffWindowsList;
    private long myRevision;
    private String myAuthor;
    private Date myDate;
    private SVNRAFileData myTempFile;
    private SVNRAFileData myBaseFile;
    private String myTempFilePath;
    private String myBaseFilePath;
    private List myLines;
    private ISVNAnnotateHandler myHandler;

    public void setAnnotateHandler(ISVNAnnotateHandler handler) {
        this.myHandler = handler;
    }

    private void createBaseFile() {
        if (this.myBaseFilePath == null) {
            try {
                File baseFile = File.createTempFile("javasvn.", ".temp");
                this.myBaseFilePath = baseFile.getAbsolutePath();
                baseFile.deleteOnExit();
                this.myBaseFile = new SVNRAFileData(baseFile, false);
            }
            catch (IOException e) {
                DebugLog.error(e);
            }
        }
    }

    public void hanldeFileRevision(SVNFileRevision fileRevision) {
        this.createBaseFile();
        if (this.myLines == null) {
            this.myLines = new ArrayList();
        }
        this.myDiffWindowsMap = null;
        this.myDiffWindowsList = null;
        this.myRevision = fileRevision.getRevision();
        this.myAuthor = fileRevision.getProperties().get("svn:author").toString();
        this.myDate = TimeUtil.parseDate(fileRevision.getProperties().get("svn:date").toString());
        try {
            File tempFile = File.createTempFile("javasvn.", ".temp");
            this.myTempFilePath = tempFile.getAbsolutePath();
            tempFile.deleteOnExit();
            this.myTempFile = new SVNRAFileData(tempFile, false);
        }
        catch (IOException e) {
            DebugLog.error(e);
        }
    }

    public void dispose() {
        if (this.myBaseFilePath != null) {
            new File(this.myBaseFilePath).delete();
        }
        this.myBaseFilePath = null;
        this.myTempFilePath = null;
        if (this.myLines != null && this.myHandler != null) {
            for (int i = 0; i < this.myLines.size(); ++i) {
                LineInfo info = (LineInfo)this.myLines.get(i);
                this.myHandler.handleLine(info.date, info.revision, info.author, info.line);
            }
        }
        this.myLines = null;
    }

    public OutputStream handleDiffWindow(String token, SVNDiffWindow diffWindow) {
        if (diffWindow == null) {
            return null;
        }
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("javasvn.", ".diff");
            tmpFile.deleteOnExit();
        }
        catch (IOException e) {
            DebugLog.error(e);
            return null;
        }
        if (this.myDiffWindowsMap == null) {
            this.myDiffWindowsMap = new HashMap();
            this.myDiffWindowsList = new LinkedList();
        }
        this.myDiffWindowsMap.put(diffWindow, tmpFile);
        this.myDiffWindowsList.add(diffWindow);
        try {
            return new FileOutputStream(tmpFile);
        }
        catch (FileNotFoundException e) {
            DebugLog.error(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void hanldeDiffWindowClosed(String token) {
        block36: {
            IOException e522;
            InputStream right;
            FileInputStream left;
            block34: {
                for (int i = 0; i < this.myDiffWindowsList.size(); ++i) {
                    SVNDiffWindow diffWindow = (SVNDiffWindow)this.myDiffWindowsList.get(i);
                    File dataFile = (File)this.myDiffWindowsMap.get(diffWindow);
                    FileInputStream is = null;
                    is = new FileInputStream(dataFile);
                    diffWindow.apply(this.myBaseFile, this.myTempFile, is, this.myTempFile.length());
                    Object var8_11 = null;
                    if (is == null) continue;
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e2) {
                        DebugLog.error(e2);
                    }
                    continue;
                    {
                        catch (SVNException e3) {
                            DebugLog.error(e3);
                            var8_11 = null;
                            if (is == null) continue;
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException e2) {
                                DebugLog.error(e2);
                            }
                            continue;
                        }
                        catch (IOException e4) {
                            DebugLog.error(e4);
                            var8_11 = null;
                            if (is == null) continue;
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException e2) {
                                DebugLog.error(e2);
                            }
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var8_11 = null;
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException e2) {
                                DebugLog.error(e2);
                            }
                        }
                        throw throwable;
                    }
                }
                left = null;
                right = null;
                left = new FileInputStream(this.myBaseFilePath);
                right = new FileInputStream(this.myTempFilePath);
                SVNSequenceLineReader reader = new SVNSequenceLineReader(null);
                SVNSequenceLine[] leftLines = reader.read(left);
                SVNSequenceLine[] rightLines = reader.read(right);
                ArrayList newLines = new ArrayList();
                int lastStart = 0;
                List blocksList = SVNSequenceMedia.createBlocks(leftLines, rightLines);
                for (int i = 0; i < blocksList.size(); ++i) {
                    int j;
                    QSequenceDifferenceBlock block = (QSequenceDifferenceBlock)blocksList.get(i);
                    int start = block.getLeftFrom();
                    int end = block.getLeftTo();
                    for (j = lastStart; j < Math.min(this.myLines.size(), start); ++j) {
                        newLines.add(this.myLines.get(j));
                        lastStart = j + 1;
                    }
                    if (block.getLeftSize() > 0) {
                        lastStart += block.getLeftSize();
                    }
                    for (j = block.getRightFrom(); j <= block.getRightTo(); ++j) {
                        LineInfo line = new LineInfo();
                        line.revision = this.myRevision;
                        line.author = this.myAuthor;
                        line.line = new String(rightLines[j].getBytes());
                        line.date = this.myDate;
                        newLines.add(line);
                    }
                }
                for (int j = lastStart; j < this.myLines.size(); ++j) {
                    newLines.add(this.myLines.get(j));
                }
                this.myLines = newLines;
                Object var17_22 = null;
                if (left == null) break block34;
                try {
                    ((InputStream)left).close();
                }
                catch (IOException e522) {
                    // empty catch block
                }
            }
            if (right != null) {
                try {
                    right.close();
                }
                catch (IOException e522) {}
            }
            break block36;
            {
                catch (Throwable e6) {
                    IOException e522;
                    DebugLog.error(e6);
                    Object var17_23 = null;
                    if (left != null) {
                        try {
                            ((InputStream)left).close();
                        }
                        catch (IOException e522) {
                            // empty catch block
                        }
                    }
                    if (right != null) {
                        try {
                            right.close();
                        }
                        catch (IOException e522) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e522;
                Object var17_24 = null;
                if (left != null) {
                    try {
                        ((InputStream)left).close();
                    }
                    catch (IOException e522) {
                        // empty catch block
                    }
                }
                if (right != null) {
                    try {
                        right.close();
                    }
                    catch (IOException e522) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        FSUtil.copy(new File(this.myTempFilePath), new File(this.myBaseFilePath), null, null, null);
        new File(this.myTempFilePath).delete();
    }

    private static class LineInfo {
        public String line;
        public long revision;
        public String author;
        public Date date;

        private LineInfo() {
        }
    }
}

