/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.tmatesoft.svn.core.ISVNCommitHandler;
import org.tmatesoft.svn.core.ISVNDirectoryEntry;
import org.tmatesoft.svn.core.ISVNEntry;
import org.tmatesoft.svn.core.ISVNEntryContent;
import org.tmatesoft.svn.core.ISVNExternalsHandler;
import org.tmatesoft.svn.core.ISVNFileContent;
import org.tmatesoft.svn.core.ISVNRootEntry;
import org.tmatesoft.svn.core.ISVNRunnable;
import org.tmatesoft.svn.core.ISVNStatusHandler;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.ISVNWorkspaceListener;
import org.tmatesoft.svn.core.SVNCommitPacket;
import org.tmatesoft.svn.core.SVNStatus;
import org.tmatesoft.svn.core.SVNWorkspaceManager;
import org.tmatesoft.svn.core.internal.DefaultSVNExternalsHandler;
import org.tmatesoft.svn.core.internal.SVNCheckoutEditor;
import org.tmatesoft.svn.core.internal.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.SVNExternal;
import org.tmatesoft.svn.core.internal.SVNReporterBaton;
import org.tmatesoft.svn.core.internal.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.SVNStatusUtil;
import org.tmatesoft.svn.core.internal.SVNWorkspaceMediatorAdapter;
import org.tmatesoft.svn.core.internal.ws.fs.FSDirEntry;
import org.tmatesoft.svn.core.internal.ws.fs.FSUtil;
import org.tmatesoft.svn.core.io.ISVNCredentialsProvider;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.io.SVNCommitInfo;
import org.tmatesoft.svn.core.io.SVNError;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNNodeKind;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.core.io.SVNSimpleCredentialsProvider;
import org.tmatesoft.svn.core.progress.ISVNProgressCanceller;
import org.tmatesoft.svn.core.progress.ISVNProgressViewer;
import org.tmatesoft.svn.core.progress.SVNProgressDummyCanceller;
import org.tmatesoft.svn.core.progress.SVNProgressDummyViewer;
import org.tmatesoft.svn.core.progress.SVNProgressProcessor;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;
import org.tmatesoft.svn.util.SVNUtil;

public class SVNWorkspace
implements ISVNWorkspace {
    private ISVNRootEntry myRoot;
    private SVNRepositoryLocation myLocation;
    private Map myAutoProperties;
    private Map myCompiledAutoProperties;
    private Collection myListeners;
    private ISVNCredentialsProvider myCredentialsProvider;
    private ISVNExternalsHandler myExternalsHandler;
    private boolean myIsCommandRunning;
    private boolean myIsNeedToSleepForTimestamp;
    private boolean myIsCopyCommit;

    public SVNWorkspace(ISVNRootEntry root) {
        this.setAutoProperties(null);
        this.setExternalsHandler(new DefaultSVNExternalsHandler());
        this.myRoot = root;
    }

    public String getID() {
        if (this.myRoot == null) {
            return null;
        }
        return this.myRoot.getID();
    }

    public void setGlobalIgnore(String ignore) {
        this.myRoot.setGlobalIgnore(ignore == null ? "" : ignore);
    }

    public String getGlobalIgnore() {
        return this.myRoot.getGlobalIgnore();
    }

    public void setUseCommitTimes(boolean useCommitTimes) {
        this.myRoot.setUseCommitTimes(useCommitTimes);
    }

    public boolean isUseCommitTimes() {
        return this.myRoot.isUseCommitTimes();
    }

    public void setAutoProperties(Map properties) {
        this.myAutoProperties = properties == null ? new HashMap() : new HashMap(properties);
        this.myCompiledAutoProperties = null;
    }

    public Map getAutoProperties() {
        return Collections.unmodifiableMap(this.myAutoProperties);
    }

    public void setExternalsHandler(ISVNExternalsHandler handler) {
        this.myExternalsHandler = handler;
    }

    public void addWorkspaceListener(ISVNWorkspaceListener listener) {
        if (listener != null) {
            if (this.myListeners == null) {
                this.myListeners = new HashSet();
            }
            this.myListeners.add(listener);
        }
    }

    public void removeWorkspaceListener(ISVNWorkspaceListener listener) {
        if (listener != null && this.myListeners != null) {
            this.myListeners.remove(listener);
            if (this.myListeners.isEmpty()) {
                this.myListeners = null;
            }
        }
    }

    public SVNRepositoryLocation getLocation() throws SVNException {
        if (this.myLocation == null) {
            String url = this.getRoot().getPropertyValue("svn:entry:url");
            if ((url = PathUtil.decode(url)) != null) {
                try {
                    this.myLocation = SVNRepositoryLocation.parseURL(url);
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
            }
        }
        return this.myLocation;
    }

    public void setCredentials(String userName, String password) {
        this.myCredentialsProvider = userName != null && password != null ? new SVNSimpleCredentialsProvider(userName, password) : null;
    }

    public ISVNCredentialsProvider getCredentialsProvider() {
        return this.myCredentialsProvider;
    }

    public void setCredentials(ISVNCredentialsProvider provider) {
        this.myCredentialsProvider = provider;
    }

    public void refresh() throws SVNException {
        if (this.getRoot() != null) {
            this.getRoot().dispose();
        }
    }

    public ISVNWorkspace getRootWorkspace(boolean stopOnExternals, boolean stopOnSwitch) {
        ISVNWorkspace workspace = this;
        String name;
        while ((name = PathUtil.tail(workspace.getID())).trim().length() != 0 && !PathUtil.isEmpty(name)) {
            String parentID = PathUtil.removeTail(workspace.getID().replace(File.separatorChar, '/'));
            ISVNWorkspace parentWorkspace = null;
            SVNRepositoryLocation location = null;
            DebugLog.log("creating parent workspace for " + workspace.getID());
            DebugLog.log("parent id " + parentID);
            try {
                parentWorkspace = SVNWorkspaceManager.createWorkspace(this.getRoot().getType(), parentID);
                if (parentWorkspace == null) {
                    return workspace;
                }
                parentWorkspace.setCredentials(this.myCredentialsProvider);
                if (workspace.getLocation() == null && parentWorkspace.getLocation() != null) {
                    return parentWorkspace;
                }
                if (workspace.getLocation() == null) {
                    return workspace;
                }
                location = parentWorkspace.getLocation();
                if (location == null) {
                    return workspace;
                }
                String expectedUrl = PathUtil.append(location.toString(), PathUtil.encode(name));
                if (!expectedUrl.equals(workspace.getLocation().toString())) {
                    DebugLog.log("existing url: " + workspace.getLocation());
                    DebugLog.log("expected url: " + expectedUrl);
                    SVNStatus wsStatus = parentWorkspace.status(name, false);
                    if (wsStatus == null) {
                        return workspace;
                    }
                    int status = wsStatus.getContentsStatus();
                    if (status == 8 || status == 5 || status == 18 ? stopOnExternals : (status != 8 && status != 5 || wsStatus.isSwitched()) && stopOnSwitch) {
                        return workspace;
                    }
                }
            }
            catch (SVNException e1) {
                return workspace;
            }
            workspace = parentWorkspace;
        }
        return workspace;
    }

    public SVNRepositoryLocation getLocation(String path) throws SVNException {
        if (path == null || "".equals(path)) {
            return this.getLocation();
        }
        ISVNEntry entry = this.locateEntry(path);
        if (entry == null) {
            return null;
        }
        String url = entry.getPropertyValue("svn:entry:url");
        if (url == null) {
            return null;
        }
        url = PathUtil.decode(url);
        return SVNRepositoryLocation.parseURL(url);
    }

    public void setLocation(SVNRepositoryLocation location) throws SVNException {
        if (this.getLocation() == null && location != null) {
            this.getRoot().setPropertyValue("svn:entry:url", location.toString());
            this.myLocation = location;
        }
    }

    public long checkout(SVNRepositoryLocation location, long revision, boolean export) throws SVNException {
        return this.checkout(location, revision, export, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long checkout(SVNRepositoryLocation location, long revision, boolean export, boolean recurse) throws SVNException {
        if (this.getLocation() != null) {
            throw new SVNException(this.getRoot().getID() + " already contains working copy files");
        }
        try {
            SVNRepository repository = null;
            if (!export) {
                this.setLocation(location);
                repository = SVNUtil.createRepository(this, "");
            } else {
                repository = SVNRepositoryFactory.create(location);
                repository.setCredentialsProvider(this.myCredentialsProvider);
            }
            SVNCheckoutEditor editor = new SVNCheckoutEditor(this.getRoot(), this, this.getRoot(), export, null);
            repository.checkout(revision, null, recurse, editor);
            if (this.myExternalsHandler != null) {
                HashSet<String> paths = new HashSet<String>();
                Iterator externals = editor.getExternals().iterator();
                while (externals.hasNext()) {
                    SVNExternal external = (SVNExternal)externals.next();
                    if (paths.contains(external.getPath())) continue;
                    paths.add(external.getPath());
                    try {
                        String path = PathUtil.append(this.getID(), external.getPath());
                        new File(path).mkdirs();
                        ISVNWorkspace extWorkspace = this.createWorkspace(external);
                        this.myExternalsHandler.handleCheckout(this, external.getPath(), extWorkspace, external.getLocation(), external.getRevision(), export, true);
                    }
                    catch (Throwable th) {
                        DebugLog.error(th);
                    }
                }
            }
            if (!export && editor.isTimestampsChanged()) {
                this.sleepForTimestamp();
            }
            long l = editor.getTargetRevision();
            return l;
        }
        finally {
            this.getRoot().dispose();
        }
    }

    public long update(long revision) throws SVNException {
        return this.update("", revision, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long update(String path, long revision, boolean recursive) throws SVNException {
        if (this.getLocation() == null) {
            throw new SVNException(this.getRoot().getID() + " does not contain working copy files");
        }
        try {
            ISVNEntry targetEntry = this.locateEntry(path);
            Collection externalsSet = this.createExternals(path);
            String target = null;
            if (targetEntry == null || !targetEntry.isDirectory()) {
                target = targetEntry != null ? targetEntry.getName() : PathUtil.tail(path);
                targetEntry = this.locateParentEntry(path);
            }
            if (targetEntry.isMissing()) {
                target = targetEntry.getName();
                targetEntry = this.locateParentEntry(path);
            }
            SVNRepository repository = SVNUtil.createRepository(this, targetEntry.getPath());
            SVNCheckoutEditor editor = new SVNCheckoutEditor(this.getRoot(), this, targetEntry, false, target, recursive);
            SVNReporterBaton reporterBaton = new SVNReporterBaton(this, targetEntry, target, recursive);
            repository.update(revision, target, recursive, reporterBaton, editor);
            Iterator missingPaths = reporterBaton.missingEntries();
            while (missingPaths.hasNext()) {
                ISVNEntry missingEntry = (ISVNEntry)missingPaths.next();
                if (this.locateEntry(missingEntry.getPath()) != null) continue;
                this.fireEntryUpdated(missingEntry, 3, 0, -1L);
            }
            if (this.myExternalsHandler != null) {
                Collection existingExternals = reporterBaton.getExternals();
                Collection updatedExternals = editor.getExternals();
                HashSet allExternals = new HashSet(existingExternals);
                allExternals.addAll(externalsSet);
                existingExternals.addAll(updatedExternals);
                HashSet<String> paths = new HashSet<String>();
                Iterator externals = allExternals.iterator();
                while (externals.hasNext()) {
                    SVNExternal external = (SVNExternal)externals.next();
                    if (paths.contains(external.getPath())) continue;
                    paths.add(external.getPath());
                    if (!external.getPath().startsWith(path)) continue;
                    try {
                        ISVNWorkspace extWorkspace = this.createWorkspace(external);
                        this.myExternalsHandler.handleUpdate(this, external.getPath(), extWorkspace, external.getRevision());
                    }
                    catch (Throwable th) {
                        DebugLog.error(th);
                    }
                }
            }
            if (editor.isTimestampsChanged()) {
                this.sleepForTimestamp();
            }
            long l = editor.getTargetRevision();
            return l;
        }
        finally {
            this.getRoot().dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long update(SVNRepositoryLocation url, String path, long revision, boolean recursive) throws SVNException {
        if (this.getLocation() == null) {
            throw new SVNException(this.getRoot().getID() + " does not contain working copy files");
        }
        try {
            ISVNEntry targetEntry = this.locateEntry(path);
            if (targetEntry == null) {
                throw new SVNException("could not find directory '" + path + "'");
            }
            String target = null;
            if (!targetEntry.isDirectory()) {
                target = targetEntry.getName();
                targetEntry = this.locateParentEntry(targetEntry.getPath());
            }
            SVNRepository repository = SVNUtil.createRepository(this, targetEntry.getPath());
            SVNCheckoutEditor editor = new SVNCheckoutEditor(this.getRoot(), this, targetEntry, false, target);
            SVNReporterBaton reporterBaton = new SVNReporterBaton(this, targetEntry, null, recursive);
            repository.update(url.toString(), revision, target, recursive, reporterBaton, editor);
            if (this.myExternalsHandler != null) {
                HashSet<String> paths = new HashSet<String>();
                Iterator externals = editor.getExternals().iterator();
                while (externals.hasNext()) {
                    SVNExternal external = (SVNExternal)externals.next();
                    if (paths.contains(external.getPath())) continue;
                    paths.add(external.getPath());
                    try {
                        ISVNWorkspace extWorkspace = this.createWorkspace(external);
                        this.myExternalsHandler.handleCheckout(this, external.getPath(), extWorkspace, external.getLocation(), external.getRevision(), false, true);
                    }
                    catch (Throwable th) {
                        DebugLog.error(th);
                    }
                }
            }
            String newURL = url.toString();
            if (target != null) {
                targetEntry = this.locateEntry(path);
            }
            targetEntry.setPropertyValue("svn:entry:url", newURL);
            DebugLog.log("setting new url for " + targetEntry.getPath() + " : " + newURL);
            if (targetEntry.isDirectory()) {
                Iterator children = targetEntry.asDirectory().childEntries();
                while (children.hasNext()) {
                    ISVNEntry child = (ISVNEntry)children.next();
                    SVNWorkspace.updateURL(child, newURL, recursive);
                }
                targetEntry.save();
            } else {
                this.locateParentEntry(path).save();
            }
            if (targetEntry.equals(this.getRoot())) {
                this.setLocation(url);
            }
            if (editor.isTimestampsChanged()) {
                this.sleepForTimestamp();
            }
            long l = editor.getTargetRevision();
            return l;
        }
        finally {
            this.getRoot().dispose();
        }
    }

    private ISVNWorkspace createWorkspace(SVNExternal external) throws SVNException {
        ISVNWorkspace extWorkspace = SVNWorkspaceManager.createWorkspace(this.getRoot().getType(), PathUtil.append(this.getID(), external.getPath()));
        extWorkspace.setCredentials(this.myCredentialsProvider);
        return extWorkspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relocate(SVNRepositoryLocation newLocation, String path, boolean recursive) throws SVNException {
        try {
            ISVNEntry targetEntry = this.locateEntry(path);
            if (targetEntry == null) {
                throw new SVNException("could not find directory '" + path + "'");
            }
            if (!targetEntry.isDirectory()) {
                throw new SVNException("could not relocate file '" + path + "' only directories could be switched");
            }
            String newURL = newLocation.toString();
            targetEntry.setPropertyValue("svn:entry:url", newURL);
            Iterator children = targetEntry.asDirectory().childEntries();
            while (children.hasNext()) {
                ISVNEntry child = (ISVNEntry)children.next();
                SVNWorkspace.updateURL(child, newURL, recursive);
            }
            targetEntry.save();
            if (targetEntry.equals(this.getRoot())) {
                this.setLocation(newLocation);
            }
        }
        finally {
            this.getRoot().dispose();
        }
    }

    public long status(String path, boolean remote, ISVNStatusHandler handler, boolean descend, boolean includeUnmodified, boolean includeIgnored) throws SVNException {
        return this.status(path, remote, handler, descend, includeUnmodified, includeIgnored, false, false);
    }

    public long status(String path, boolean remote, ISVNStatusHandler handler, boolean descend, boolean includeUnmodified, boolean includeIgnored, boolean descendInUnversioned, boolean descendFurtherInIgnored) throws SVNException {
        return this.status(path, remote, handler, descend, includeUnmodified, includeIgnored, descendInUnversioned, descendFurtherInIgnored, SVNProgressDummyViewer.getInstance(), SVNProgressDummyCanceller.getInstance());
    }

    public long status(String path, boolean remote, ISVNStatusHandler handler, boolean descend, boolean includeUnmodified, boolean includeIgnored, boolean descendInUnversioned, boolean descendFurtherInIgnored, ISVNProgressViewer progressViewer, ISVNProgressCanceller canceller) throws SVNException {
        long start = System.currentTimeMillis();
        if (this.getLocation() == null) {
            return -1L;
        }
        if (path == null) {
            path = "";
        }
        long revision = -1L;
        SVNStatusEditor editor = null;
        ISVNEntry targetEntry = this.locateEntry(path, true);
        if (targetEntry == null) {
            return -1L;
        }
        if (remote && targetEntry != null) {
            ISVNEntry entry = targetEntry;
            if (!entry.isDirectory()) {
                entry = this.locateParentEntry(path);
            }
            SVNRepository repository = SVNUtil.createRepository(this, entry.getPath());
            editor = new SVNStatusEditor(entry.getPath());
            String target = null;
            if (!targetEntry.isDirectory()) {
                target = targetEntry.getName();
            }
            SVNReporterBaton reporterBaton = new SVNReporterBaton(null, entry, target, descend);
            repository.status(-2L, target, descend, reporterBaton, editor);
            revision = editor.getTargetRevision();
        }
        if (handler == null) {
            return revision;
        }
        Collection externals = this.createExternals(path);
        ISVNEntry parent = null;
        if (!"".equals(path)) {
            parent = this.locateParentEntry(path);
        }
        if (targetEntry != null && parent != null && parent.asDirectory().isIgnored(targetEntry.getName())) {
            includeIgnored = true;
        }
        SVNStatusUtil.doStatus(this, parent != null ? parent.asDirectory() : null, editor, handler, path, externals, descend, includeUnmodified, includeIgnored, descendInUnversioned, descendFurtherInIgnored, new SVNProgressProcessor(progressViewer, canceller));
        if (this.myExternalsHandler != null && externals != null) {
            HashSet<String> paths = new HashSet<String>();
            Iterator exts = externals.iterator();
            while (exts.hasNext()) {
                SVNExternal external = (SVNExternal)exts.next();
                if (paths.contains(external.getPath())) continue;
                paths.add(external.getPath());
                if (!descend && !external.getPath().equals(path)) {
                    DebugLog.log("SKIPPING EXTERNAL STATUS FOR " + external.getPath());
                    continue;
                }
                if (!external.getPath().startsWith(path)) {
                    DebugLog.log("SKIPPING EXTERNAL STATUS FOR " + external.getPath());
                    continue;
                }
                DebugLog.log("EXTERNAL STATUS FOR " + external.getPath());
                try {
                    ISVNWorkspace extWorkspace = this.createWorkspace(external);
                    this.myExternalsHandler.handleStatus(this, external.getPath(), extWorkspace, handler, remote, descend, includeUnmodified, includeIgnored, descendInUnversioned);
                }
                catch (Throwable th) {
                    DebugLog.error(th);
                }
            }
        }
        DebugLog.benchmark("STATUS COMPLETED IN " + (System.currentTimeMillis() - start));
        return revision;
    }

    public SVNStatus status(final String filePath, boolean remote) throws SVNException {
        final SVNStatus[] result = new SVNStatus[1];
        this.status(filePath, remote, new ISVNStatusHandler(){

            public void handleStatus(String path, SVNStatus status) {
                if (status.getPath().equals(filePath)) {
                    result[0] = status;
                }
            }
        }, false, true, true);
        return result[0];
    }

    public void log(String path, long startRevision, long endRevison, boolean stopOnCopy, boolean discoverPath, ISVNLogEntryHandler handler) throws SVNException {
        SVNRepository repository;
        if (this.getLocation() == null) {
            throw new SVNException(this.getRoot().getID() + " does not contain working copy files");
        }
        ISVNEntry entry = this.locateEntry(path);
        String targetPath = "";
        if (!entry.isDirectory()) {
            targetPath = entry.getName();
            repository = SVNUtil.createRepository(this, PathUtil.removeTail(path));
        } else {
            repository = SVNUtil.createRepository(this, path);
        }
        repository.log(new String[]{targetPath}, startRevision, endRevison, discoverPath, stopOnCopy, handler);
    }

    public long commit(SVNRepositoryLocation destination, String message) throws SVNException {
        return this.commit(destination, null, message);
    }

    public long commit(SVNRepositoryLocation destination, String fileName, String message) throws SVNException {
        SVNNodeKind nodeKind;
        if (fileName == null && this.getLocation() != null) {
            throw new SVNException(this.getRoot().getID() + " already contains working copy files");
        }
        if (fileName != null && this.locateEntry(fileName) != null) {
            throw new SVNException("'" + fileName + "' already under version control");
        }
        SVNRepository repository = SVNRepositoryFactory.create(destination);
        repository.setCredentialsProvider(this.getCredentialsProvider());
        repository.testConnection();
        String rootPath = PathUtil.decode(destination.getPath());
        rootPath = rootPath.substring(repository.getRepositoryRoot().length());
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        rootPath = PathUtil.removeTrailingSlash(rootPath);
        LinkedList<String> dirsList = new LinkedList<String>();
        DebugLog.log("IMPORT: ROOT PATH: " + rootPath);
        while (rootPath.lastIndexOf(47) >= 0 && (nodeKind = repository.checkPath(rootPath, -1L)) != SVNNodeKind.DIR) {
            if (nodeKind == SVNNodeKind.FILE) {
                throw new SVNException("'" + rootPath + "' is file, could not import into it");
            }
            String dir = rootPath.substring(rootPath.lastIndexOf(47) + 1);
            dirsList.add(0, dir);
            rootPath = rootPath.substring(0, rootPath.lastIndexOf(47));
        }
        destination = new SVNRepositoryLocation(destination.getProtocol(), destination.getHost(), destination.getPort(), PathUtil.append(repository.getRepositoryRoot(), rootPath));
        repository = SVNRepositoryFactory.create(destination);
        repository.setCredentialsProvider(this.getCredentialsProvider());
        DebugLog.log("IMPORT: REPOSITORY CREATED FOR: " + destination.toString());
        ISVNEditor editor = repository.getCommitEditor(message, this.getRoot());
        SVNCommitInfo info = null;
        try {
            String dir = "";
            DebugLog.log("IMPORT: OPEN ROOT");
            editor.openRoot(-1L);
            Iterator dirs = dirsList.iterator();
            while (dirs.hasNext()) {
                String nextDir = (String)dirs.next();
                DebugLog.log("IMPORT: NEXT DIR: " + nextDir);
                dir = dir + '/' + nextDir;
                DebugLog.log("IMPORT: ADDING MISSING DIR: " + dir);
                editor.addDir(dir, null, -1L);
            }
            if (fileName == null) {
                Iterator children = this.getRoot().asDirectory().unmanagedChildEntries(false);
                while (children.hasNext()) {
                    ISVNEntry child = (ISVNEntry)children.next();
                    this.doImport(dir, editor, this.getRoot(), child);
                }
            } else {
                ISVNEntry child = this.locateEntry(fileName, true);
                this.doImport(dir, editor, this.getRoot(), child);
            }
            dirs = dirsList.iterator();
            while (dirs.hasNext()) {
                dirs.next();
                editor.closeDir();
            }
            editor.closeDir();
            this.fireEntryCommitted(null, 1);
            info = editor.closeEdit();
        }
        catch (SVNException e) {
            try {
                editor.abortEdit();
            }
            catch (SVNException inner) {
                // empty catch block
            }
            DebugLog.error(e);
            throw e;
        }
        finally {
            this.getRoot().dispose();
        }
        return info != null ? info.getNewRevision() : -1L;
    }

    public long commit(String message) throws SVNException {
        return this.commit("", message, true);
    }

    public long commit(String path, String message, boolean recursive) throws SVNException {
        return this.commit(new String[]{path}, message, recursive, true);
    }

    public long commit(String[] paths, String message, boolean recursive) throws SVNException {
        return this.commit(paths, message, recursive, true);
    }

    public long commit(String[] paths, final String message, boolean recursive, boolean includeParents) throws SVNException {
        return this.commit(paths, new ISVNCommitHandler(){

            public String handleCommit(SVNStatus[] tobeCommited) {
                return message == null ? "" : message;
            }
        }, recursive, includeParents);
    }

    public long commit(String[] paths, ISVNCommitHandler handler, boolean recursive) throws SVNException {
        return this.commit(paths, handler, recursive, true);
    }

    public long commit(String[] paths, ISVNCommitHandler handler, boolean recursive, boolean includeParents) throws SVNException {
        SVNCommitPacket packet;
        if (handler == null) {
            handler = new ISVNCommitHandler(){

                public String handleCommit(SVNStatus[] tobeCommited) {
                    return "";
                }
            };
        }
        if ((packet = this.createCommitPacket(paths, recursive, includeParents)) == null) {
            DebugLog.log("NOTHING TO COMMIT");
            return -1L;
        }
        return this.commit(packet, handler.handleCommit(packet.getStatuses()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatus[] getCommittables(String[] paths, boolean recursive, boolean includeParents) throws SVNException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < paths.length; ++i) {
            ISVNEntry entry = this.locateEntry(paths[i]);
            if (entry == null || !entry.isManaged()) {
                throw new SVNException("'" + paths[i] + "' is not under version control");
            }
            if (entry == null || entry.getPropertyValue("svn:entry:copied") == null || entry.isScheduledForAddition()) continue;
            throw new SVNException("'" + entry.getPath() + "' is marked as 'copied' but is not itself scheduled for addition. " + "Perhaps you're committing a target that is inside unversioned (or not-yet-versioned) directory?");
        }
        try {
            ISVNEntry entry;
            String root = this.getCommitRoot(paths);
            ISVNEntry rootEntry = this.locateEntry(root);
            if (rootEntry == null || rootEntry.getPropertyValue("svn:entry:url") == null) {
                throw new SVNException(root + " does not contain working copy files");
            }
            DebugLog.log("");
            DebugLog.log("COMMIT ROOT: " + root);
            for (int i = 0; i < paths.length; ++i) {
                DebugLog.log("COMMIT PATH " + i + " :" + paths[i]);
            }
            HashSet modified = new HashSet();
            if (recursive) {
                SVNCommitUtil.harvestCommitables(rootEntry, paths, recursive, modified);
            } else {
                for (int i = 0; i < paths.length; ++i) {
                    String path = paths[i];
                    entry = this.locateEntry(path);
                    SVNCommitUtil.harvestCommitables(entry, paths, recursive, modified);
                }
            }
            HashSet<ISVNEntry> modifiedParents = new HashSet<ISVNEntry>();
            Iterator modifiedEntries = modified.iterator();
            block7: while (modifiedEntries.hasNext()) {
                entry = (ISVNEntry)modifiedEntries.next();
                if (!entry.isDirectory() && entry.asFile().isCorrupted()) {
                    throw new SVNException("svn: Checksum of base file '" + entry.getPath() + "' is not valid");
                }
                String p = entry.getPath();
                if (!entry.isScheduledForAddition()) continue;
                ISVNEntry parent = this.locateParentEntry(entry.getPath());
                while (parent != null && parent.isScheduledForAddition() && !parent.isScheduledForDeletion()) {
                    if (!includeParents) {
                        if (modified.contains(parent)) continue block7;
                        throw new SVNException("'" + p + "' is not under version control");
                    }
                    modifiedParents.add(parent);
                    DebugLog.log("HV: 'added' parent added to transaction: " + parent.getPath());
                    parent = this.locateParentEntry(parent.getPath());
                }
            }
            modified.addAll(modifiedParents);
            if (modified.isEmpty()) {
                modifiedEntries = null;
                return modifiedEntries;
            }
            SVNStatus[] statuses = new SVNStatus[modified.size()];
            HashMap<String, String> urls = new HashMap<String, String>();
            int index = 0;
            String uuid = null;
            Iterator entries = modified.iterator();
            while (entries.hasNext()) {
                ISVNEntry entry2 = (ISVNEntry)entries.next();
                String url = entry2.getPropertyValue("svn:entry:url");
                String entryUUID = entry2.getPropertyValue("svn:entry:uuid");
                if (entryUUID != null) {
                    if (uuid != null && !uuid.equals(entryUUID)) {
                        throw new SVNException("commit contains entries from the different repositories '" + entry2.getPath() + "' and '" + urls.get(url) + "'");
                    }
                    uuid = entryUUID;
                }
                if (urls.containsKey(url)) {
                    throw new SVNException("commit contains entries with the same url '" + entry2.getPath() + "' and '" + urls.get(url) + "'");
                }
                urls.put(url, entry2.getPath());
                if (entry2.isConflict()) {
                    throw new SVNException("resolve conflict in '" + entry2.getPath() + "' before commit");
                }
                statuses[index++] = SVNStatusUtil.createStatus(entry2, -1L, 0, 0, null);
            }
            DebugLog.log("Calculating committables took " + (System.currentTimeMillis() - start) + " ms.");
            SVNStatus[] sVNStatusArray = statuses;
            return sVNStatusArray;
        }
        finally {
            if (!this.myIsCopyCommit) {
                this.getRoot().dispose();
            }
        }
    }

    public SVNCommitPacket createCommitPacket(String[] paths, boolean recursive, boolean includeParents) throws SVNException {
        SVNStatus[] committables = this.getCommittables(paths, recursive, includeParents);
        return committables != null ? new SVNCommitPacket(this.getCommitRoot(paths), committables) : null;
    }

    public long commit(SVNCommitPacket packet, String message) throws SVNException {
        ArrayList<String> paths = new ArrayList<String>();
        SVNStatus[] statuses = packet.getStatuses();
        for (int index = 0; index < statuses.length; ++index) {
            if (statuses[index] == null) continue;
            String path = statuses[index].getPath();
            paths.add(path);
        }
        return this.commitPaths(paths, message, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long commitPaths(List paths, String message, ISVNProgressViewer progressViewer, ISVNProgressCanceller progressCanceller) throws SVNException {
        long start = System.currentTimeMillis();
        try {
            SVNCommitInfo info;
            HashSet<ISVNEntry> modified = new HashSet<ISVNEntry>();
            Iterator it2 = paths.iterator();
            while (it2.hasNext()) {
                String path = (String)it2.next();
                modified.add(this.locateEntry(path));
            }
            if (message == null || modified.isEmpty()) {
                DebugLog.log("NOTHING TO COMMIT");
                long it2 = -1L;
                return it2;
            }
            String root = this.getCommitRoot(paths.toArray(new String[paths.size()]));
            ISVNEntry rootEntry = this.locateEntry(root);
            if (rootEntry == null || rootEntry.getPropertyValue("svn:entry:url") == null) {
                throw new SVNException(root + " does not contain working copy files");
            }
            DebugLog.log("COMMIT MESSAGE: " + message);
            HashMap tree = new HashMap();
            String url = SVNCommitUtil.buildCommitTree(modified, tree);
            Iterator treePaths = tree.keySet().iterator();
            while (treePaths.hasNext()) {
                String treePath = (String)treePaths.next();
                if (tree.get(treePath) != null) {
                    DebugLog.log("TREE ENTRY : " + treePath + " : " + ((ISVNEntry)tree.get(treePath)).getPath());
                    continue;
                }
                DebugLog.log("TREE ENTRY : " + treePath + " : null");
            }
            DebugLog.log("COMMIT ROOT RECALCULATED: " + url);
            DebugLog.log("COMMIT PREPARATIONS TOOK: " + (System.currentTimeMillis() - start) + " ms.");
            SVNRepositoryLocation location = SVNRepositoryLocation.parseURL(url);
            SVNRepository repository = SVNRepositoryFactory.create(location);
            repository.setCredentialsProvider(this.getCredentialsProvider());
            ISVNEditor editor = repository.getCommitEditor(message, new SVNWorkspaceMediatorAdapter(this.getRoot(), tree));
            String host = location.getProtocol() + "://" + location.getHost() + ":" + location.getPort();
            String rootURL = PathUtil.append(host, repository.getRepositoryRoot());
            try {
                SVNCommitUtil.doCommit("", rootURL, tree, editor, this, new SVNProgressProcessor(progressViewer, progressCanceller));
                info = editor.closeEdit();
            }
            catch (SVNException e) {
                DebugLog.error("error: " + e.getMessage());
                if (e.getErrors() != null) {
                    for (int i = 0; i < e.getErrors().length; ++i) {
                        SVNError error = e.getErrors()[i];
                        if (error == null) continue;
                        DebugLog.error(error.toString());
                    }
                }
                try {
                    editor.abortEdit();
                }
                catch (SVNException inner) {
                    // empty catch block
                }
                throw e;
            }
            catch (Throwable th) {
                throw new SVNException(th);
            }
            DebugLog.log("COMMIT TOOK: " + (System.currentTimeMillis() - start) + " ms.");
            if (!this.myIsCopyCommit) {
                start = System.currentTimeMillis();
                SVNCommitUtil.updateWorkingCopy(info, rootEntry.getPropertyValue("svn:entry:uuid"), tree, this);
                this.sleepForTimestamp();
                DebugLog.log("POST COMMIT ACTIONS TOOK: " + (System.currentTimeMillis() - start) + " ms.");
            }
            long l = info != null ? info.getNewRevision() : -1L;
            return l;
        }
        finally {
            this.myIsCopyCommit = false;
            this.getRoot().dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String path, boolean mkdir, boolean recurse) throws SVNException {
        block6: {
            try {
                ISVNEntry entry = this.locateParentEntry(path);
                String name = PathUtil.tail(path);
                if (entry == null || entry.isMissing() || !entry.isDirectory()) {
                    throw new SVNException("can't locate versioned parent entry for '" + path + "'");
                }
                if (mkdir && entry != null && !entry.isManaged() && entry.isDirectory() && entry != this.getRoot()) {
                    this.add(entry.getPath(), mkdir, recurse);
                    this.getRoot().dispose();
                    entry = this.locateParentEntry(path);
                }
                if (entry != null && name != null && entry.isManaged() && !entry.isMissing() && entry.isDirectory()) {
                    ISVNEntry child = entry.asDirectory().scheduleForAddition(name, mkdir, recurse);
                    this.doApplyAutoProperties(child, recurse);
                    this.fireEntryModified(child, 1, true);
                    entry.save();
                    entry.dispose();
                    break block6;
                }
                throw new SVNException("can't locate versioned parent entry for '" + path + "'");
            }
            finally {
                this.getRoot().dispose();
            }
        }
    }

    private void doApplyAutoProperties(ISVNEntry addedEntry, boolean recurse) throws SVNException {
        this.applyAutoProperties(addedEntry, null);
        if (recurse && addedEntry.isDirectory()) {
            Iterator children = addedEntry.asDirectory().childEntries();
            while (children.hasNext()) {
                ISVNEntry childEntry = (ISVNEntry)children.next();
                if (!childEntry.isScheduledForAddition()) continue;
                this.doApplyAutoProperties(childEntry, recurse);
            }
        }
    }

    public void delete(String path) throws SVNException {
        this.delete(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String path, boolean force) throws SVNException {
        try {
            ISVNEntry entry = this.locateParentEntry(path);
            String name = PathUtil.tail(path);
            if (entry != null && name != null) {
                if (!force) {
                    SVNWorkspace.assertNotModified(entry.asDirectory().getChild(name));
                    SVNWorkspace.assertNotModified(entry.asDirectory().getUnmanagedChild(name));
                }
                ISVNEntry child = entry.asDirectory().scheduleForDeletion(name, force);
                this.fireEntryModified(child, 3, true);
                entry.save();
                entry.dispose();
            } else if (entry == null) {
                // empty if block
            }
        }
        finally {
            this.getRoot().dispose();
        }
    }

    private static void assertNotModified(ISVNEntry entry) throws SVNException {
        if (entry == null) {
            return;
        }
        if (!entry.isManaged()) {
            throw new SVNException("'" + entry.getPath() + "' is unmanaged, use 'force' parameter to force deletion.");
        }
        if (entry.isScheduledForAddition() && !entry.isMissing()) {
            throw new SVNException("'" + entry.getPath() + "' is modified locally, use 'force' parameter to force deletion.");
        }
        if (entry.isPropertiesModified()) {
            throw new SVNException("'" + entry.getPath() + "' is modified locally, use 'force' parameter to force deletion.");
        }
        if (!entry.isDirectory()) {
            if (entry.asFile().isContentsModified()) {
                throw new SVNException("'" + entry.getPath() + "' is modified locally, use 'force' parameter to force deletion.");
            }
        } else {
            Iterator children = entry.asDirectory().unmanagedChildEntries(true);
            while (children.hasNext()) {
                SVNWorkspace.assertNotModified((ISVNEntry)children.next());
            }
            children = entry.asDirectory().childEntries();
            while (children.hasNext()) {
                SVNWorkspace.assertNotModified((ISVNEntry)children.next());
            }
        }
    }

    public void copy(String source, String destination, boolean move) throws SVNException {
        this.copy(source, destination, move, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(String source, String destination, boolean move, boolean virtual) throws SVNException {
        try {
            if (virtual) {
                ISVNEntry dstEntry = this.locateEntry(destination, true);
                if (dstEntry != null && dstEntry.isManaged()) {
                    throw new SVNException("'" + destination + "' already exists in working copy and it is versioned");
                }
                ISVNEntry srcEntry = this.locateEntry(source, false);
                if (move) {
                    if (srcEntry == null || !srcEntry.isMissing()) {
                        throw new SVNException("'" + source + "' already exists in working copy and it is not missing");
                    }
                } else if (srcEntry == null || !srcEntry.isManaged()) {
                    throw new SVNException("'" + source + "' does not exist in working copy.");
                }
            } else if (this.locateEntry(destination, true) != null) {
                throw new SVNException("'" + destination + "' already exists in working copy");
            }
            ISVNEntry entry = this.locateParentEntry(destination);
            String name = PathUtil.tail(destination);
            ISVNEntry toCopyParent = this.locateParentEntry(source);
            ISVNEntry sourceEntry = this.locateEntry(source);
            if (entry == null || !entry.isDirectory()) {
                throw new SVNException("'" + destination + "' is not under version control");
            }
            if (toCopyParent == null || !toCopyParent.isDirectory()) {
                throw new SVNException("'" + source + "' is not under version control");
            }
            if (sourceEntry == null) {
                throw new SVNException("'" + source + "' is not under version control");
            }
            String toCopyName = PathUtil.tail(source);
            ISVNEntry toCopy = toCopyParent.asDirectory().getChild(toCopyName);
            ISVNEntry copied = entry.asDirectory().copy(name, toCopy);
            this.fireEntryModified(copied, 1, true);
            if (move && toCopyParent != null) {
                toCopyParent.asDirectory().scheduleForDeletion(toCopy.getName(), true);
                this.fireEntryModified(toCopy, 3, false);
                toCopyParent.save();
                toCopyParent.dispose();
            }
            entry.save();
            entry.dispose();
            this.sleepForTimestamp();
        }
        finally {
            this.getRoot().dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copy(SVNRepositoryLocation source, String destination, long revision) throws SVNException {
        File tmpFile = null;
        try {
            try {
                SVNRepository repository = SVNRepositoryFactory.create(source);
                repository.setCredentialsProvider(this.myCredentialsProvider);
                ISVNEntry entry = this.locateEntry(destination);
                if (entry != null) {
                    if (!entry.isDirectory()) {
                        throw new SVNException("can't copy over versioned file '" + entry.getPath() + "'");
                    }
                    destination = PathUtil.append(destination, PathUtil.tail(source.getPath()));
                }
                SVNNodeKind srcKind = repository.checkPath("", revision);
                DebugLog.log("copy destination is : " + destination);
                if (srcKind == SVNNodeKind.DIR) {
                    DebugLog.log("local uuid: " + this.getRoot().getPropertyValue("svn:entry:uuid"));
                    DebugLog.log("remote uuid: " + repository.getRepositoryUUID());
                    if (!repository.getRepositoryUUID().equals(this.getRoot().getPropertyValue("svn:entry:uuid"))) {
                        throw new SVNException("couldn't copy directory from another repository");
                    }
                    String root = PathUtil.append(this.getID(), destination);
                    DebugLog.log("checkout ws root : " + root);
                    ISVNWorkspace ws = SVNWorkspaceManager.createWorkspace(this.getRoot().getType(), root);
                    ws.setCredentials(this.myCredentialsProvider);
                    ws.setAutoProperties(this.getAutoProperties());
                    ws.setExternalsHandler(this.myExternalsHandler);
                    if (this.myListeners != null) {
                        Iterator listeners = this.myListeners.iterator();
                        while (listeners.hasNext()) {
                            ISVNWorkspaceListener listener = (ISVNWorkspaceListener)listeners.next();
                            ws.addWorkspaceListener(listener);
                        }
                    }
                    DebugLog.log("checking out revision: " + revision);
                    revision = ws.checkout(source, revision, false);
                    ISVNEntry dirEntry = this.locateEntry(PathUtil.removeTail(destination));
                    dirEntry.asDirectory().markAsCopied(PathUtil.tail(destination), source, revision);
                } else {
                    if (srcKind != SVNNodeKind.FILE) throw new SVNException("can't copy from '" + source.toCanonicalForm() + "', location doesn't exist at revision " + revision);
                    HashMap properties = new HashMap();
                    tmpFile = File.createTempFile("svn.", ".tmp");
                    tmpFile.deleteOnExit();
                    FileOutputStream tmpStream = new FileOutputStream(tmpFile);
                    repository.getFile("", revision, properties, tmpStream);
                    ((OutputStream)tmpStream).close();
                    FileInputStream in = new FileInputStream(tmpFile);
                    String name = PathUtil.tail(destination);
                    ISVNEntry dirEntry = this.locateEntry(PathUtil.removeTail(destination));
                    if (repository.getRepositoryUUID().equals(this.getRoot().getPropertyValue("svn:entry:uuid"))) {
                        dirEntry.asDirectory().markAsCopied(in, tmpFile.length(), properties, name, source);
                    } else {
                        dirEntry.asDirectory().markAsCopied(in, tmpFile.length(), properties, name, null);
                    }
                    ((InputStream)in).close();
                }
                Object var15_18 = null;
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
            catch (IOException e) {
                DebugLog.error(e);
                Object var15_19 = null;
                if (tmpFile != null) {
                    tmpFile.delete();
                }
                this.getRoot().dispose();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            if (tmpFile != null) {
                tmpFile.delete();
            }
            this.getRoot().dispose();
            throw throwable;
        }
        this.getRoot().dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copy(String src, SVNRepositoryLocation destination, String message) throws SVNException {
        ISVNEntry entry = this.locateEntry(src);
        ISVNEntry parent = this.locateParentEntry(src);
        if (entry == null) {
            throw new SVNException("no versioned entry found at '" + src + "'");
        }
        try {
            String url = destination.toCanonicalForm();
            String name = PathUtil.tail(src);
            SVNRepository repository = SVNRepositoryFactory.create(destination);
            repository.setCredentialsProvider(this.myCredentialsProvider);
            if (repository.checkPath("", -1L) == SVNNodeKind.NONE) {
                name = PathUtil.tail(url);
                name = PathUtil.decode(name);
                url = PathUtil.removeTail(url);
            }
            entry.setAlias(name);
            DebugLog.log("entry path: " + entry.getPath());
            DebugLog.log("entry aliased path: " + entry.getAlias());
            entry.setPropertyValue("svn:entry:copyfrom-url", entry.getPropertyValue("svn:entry:url"));
            entry.setPropertyValue("svn:entry:copyfrom-rev", entry.getPropertyValue("svn:entry:revision"));
            entry.setPropertyValue("svn:entry:schedule", "add");
            entry.setPropertyValue("svn:wc:ra_dav:version-url", null);
            if (entry.isDirectory() && parent != null) {
                Map entryProps = ((FSDirEntry)parent).getChildEntryMap(entry.getName());
                entryProps.put("svn:entry:copyfrom-url", entry.getPropertyValue("svn:entry:url"));
                entryProps.put("svn:entry:copyfrom-rev", entry.getPropertyValue("svn:entry:revision"));
                entryProps.put("svn:entry:schedule", "add");
                entryProps.put("svn:entry:copied", "true");
            }
            FSDirEntry.updateURL(entry, url);
            FSDirEntry.setPropertyValueRecursively(entry, "svn:entry:copied", "true");
            repository = SVNRepositoryFactory.create(SVNRepositoryLocation.parseURL(url));
            repository.setCredentialsProvider(this.myCredentialsProvider);
            ISVNEditor editor = repository.getCommitEditor(message, this.getRoot());
            this.myIsCopyCommit = true;
            SVNCommitPacket commitPacket = this.createCommitPacket(new String[]{src}, true, false);
            long l = this.commit(commitPacket, message);
            return l;
        }
        finally {
            this.getRoot().dispose();
            this.myIsCopyCommit = false;
        }
    }

    public Iterator propertyNames(String path) throws SVNException {
        ISVNEntry entry = this.locateEntry(path);
        if (entry == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        LinkedList names = new LinkedList();
        Iterator propNames = entry.propertyNames();
        while (propNames.hasNext()) {
            names.add(propNames.next());
        }
        return names.iterator();
    }

    public String getPropertyValue(String path, String name) throws SVNException {
        ISVNEntry entry = this.locateEntry(path);
        if (entry == null) {
            return null;
        }
        return entry.getPropertyValue(name);
    }

    public Map getProperties(String path, boolean reposProps, boolean entryProps) throws SVNException {
        HashMap<String, String> props = new HashMap<String, String>();
        ISVNEntry entry = this.locateEntry(path, true);
        if (entry == null) {
            return null;
        }
        boolean add = false;
        Iterator names = entry.propertyNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            add = name.startsWith("svn:entry:") ? entryProps : reposProps;
            if (!add) continue;
            props.put(name, entry.getPropertyValue(name));
            add = false;
        }
        return props;
    }

    public void setPropertyValue(String path, String name, String value) throws SVNException {
        this.setPropertyValue(path, name, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyValue(String path, String name, String value, boolean recurse) throws SVNException {
        try {
            ISVNEntry entry = this.locateEntry(path);
            if (entry == null) {
                return;
            }
            this.doSetProperty(entry, name, value, recurse);
            entry.save();
            entry.dispose();
        }
        finally {
            this.getRoot().dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markResolved(String path, boolean recursive) throws SVNException {
        try {
            ISVNEntry entry = this.locateEntry(path);
            ISVNEntry parent = null;
            if (!entry.isDirectory()) {
                parent = this.locateParentEntry(path);
            }
            this.doMarkResolved(entry, recursive);
            this.fireEntryModified(entry, 12, recursive);
            if (parent != null) {
                entry = parent;
            }
            entry.save();
            entry.dispose();
            this.sleepForTimestamp();
        }
        finally {
            this.getRoot().dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revert(String path, boolean recursive) throws SVNException {
        try {
            ISVNEntry entry = this.locateEntry(path);
            if (entry == null || entry.isDirectory() && entry.isMissing()) {
                ISVNEntry parent;
                if (entry != null && (parent = this.locateParentEntry(path)) != null && parent.isDirectory()) {
                    boolean reverted = parent.asDirectory().revert(entry.getName());
                    this.fireEntryModified(entry, reverted ? 11 : 20, false);
                    return;
                }
                return;
            }
            ISVNDirectoryEntry parent = null;
            parent = (ISVNDirectoryEntry)this.locateParentEntry(path);
            this.doMarkResolved(entry, recursive);
            this.doRevert(parent, entry, recursive);
            if (parent == null && entry == this.getRoot()) {
                entry.asDirectory().revert(null);
            }
            if (parent != null) {
                entry = parent;
            }
            entry.save();
            entry.dispose();
            this.sleepForTimestamp();
        }
        finally {
            this.getRoot().dispose();
        }
    }

    public ISVNEntryContent getContent(String path) throws SVNException {
        ISVNEntry entry = this.locateEntry(path, true);
        if (entry == null) {
            throw new SVNException("Can't find entry for path " + path);
        }
        return entry.getContent();
    }

    public ISVNFileContent getFileContent(String path) throws SVNException {
        ISVNEntry entry = this.locateEntry(path, true);
        if (entry == null) {
            throw new SVNException("Can't find entry for path " + path);
        }
        if (entry.isDirectory()) {
            return null;
        }
        return (ISVNFileContent)entry.getContent();
    }

    protected void fireEntryCommitted(ISVNEntry entry, int kind) {
        if (this.myListeners == null || entry == null) {
            return;
        }
        Iterator listeners = this.myListeners.iterator();
        while (listeners.hasNext()) {
            ISVNWorkspaceListener listener = (ISVNWorkspaceListener)listeners.next();
            listener.committed(entry.getPath(), kind);
        }
    }

    protected void fireEntryUpdated(ISVNEntry entry, int contentsStatus, int propsStatus, long revision) {
        if (this.myListeners == null || entry == null) {
            return;
        }
        Iterator listeners = this.myListeners.iterator();
        while (listeners.hasNext()) {
            ISVNWorkspaceListener listener = (ISVNWorkspaceListener)listeners.next();
            listener.updated(entry.getPath(), contentsStatus, propsStatus, revision);
        }
    }

    protected void fireEntryModified(ISVNEntry entry, int kind, boolean recursive) {
        if (this.myListeners == null || entry == null) {
            return;
        }
        Iterator listeners = this.myListeners.iterator();
        while (listeners.hasNext()) {
            ISVNWorkspaceListener listener = (ISVNWorkspaceListener)listeners.next();
            listener.modified(entry.getPath(), kind);
        }
        if (entry.isDirectory() && recursive) {
            Iterator children = null;
            try {
                children = entry.asDirectory().childEntries();
            }
            catch (SVNException e) {
                // empty catch block
            }
            while (children != null && children.hasNext()) {
                this.fireEntryModified((ISVNEntry)children.next(), kind, recursive);
            }
        }
    }

    private ISVNRootEntry getRoot() {
        return this.myRoot;
    }

    private void doRevert(ISVNDirectoryEntry parent, ISVNEntry entry, boolean recursive) throws SVNException {
        boolean restored;
        boolean bl = restored = !entry.isDirectory() && entry.isMissing();
        if (entry.isDirectory() && recursive) {
            ISVNEntry child;
            LinkedList<ISVNEntry> namesList = new LinkedList<ISVNEntry>();
            Iterator children = entry.asDirectory().childEntries();
            while (children.hasNext()) {
                child = (ISVNEntry)children.next();
                namesList.add(child);
            }
            Iterator names = namesList.iterator();
            while (names.hasNext()) {
                child = (ISVNEntry)names.next();
                this.doRevert(entry.asDirectory(), child, recursive);
            }
        }
        if (parent != null) {
            boolean reverted = parent.revert(entry.getName());
            if (!restored) {
                this.fireEntryModified(entry, reverted ? 11 : 20, false);
            } else {
                this.fireEntryModified(entry, 15, false);
            }
        }
        if (!entry.isDirectory()) {
            entry.dispose();
        }
    }

    private void doMarkResolved(ISVNEntry entry, boolean recursive) throws SVNException {
        if (entry.isDirectory() && recursive) {
            Iterator children = entry.asDirectory().childEntries();
            while (children.hasNext()) {
                this.doMarkResolved((ISVNEntry)children.next(), recursive);
            }
        }
        entry.markResolved();
    }

    private void doSetProperty(ISVNEntry entry, String name, String value, boolean recurse) throws SVNException {
        entry.setPropertyValue(name, value);
        this.fireEntryModified(entry, 6, false);
        if (recurse && entry.isDirectory()) {
            Iterator entries = entry.asDirectory().childEntries();
            while (entries.hasNext()) {
                ISVNEntry child = (ISVNEntry)entries.next();
                this.doSetProperty(child, name, value, recurse);
            }
        }
    }

    private void doImport(String rootPath, ISVNEditor editor, ISVNDirectoryEntry parent, ISVNEntry entry) throws SVNException {
        if (rootPath.trim().length() > 0) {
            rootPath = rootPath + "/";
        }
        if (entry.isDirectory()) {
            DebugLog.log("IMPORT: ADDING DIR: " + rootPath + entry.getPath());
            editor.addDir(rootPath + entry.getPath(), null, -1L);
            this.applyAutoProperties(entry, editor);
            Iterator children = entry.asDirectory().unmanagedChildEntries(false);
            while (children.hasNext()) {
                ISVNEntry child = (ISVNEntry)children.next();
                this.doImport(rootPath, editor, parent, child);
            }
            editor.closeDir();
        } else {
            DebugLog.log("IMPORT: ADDING FILE: " + rootPath + entry.getPath());
            editor.addFile(rootPath + entry.getPath(), null, -1L);
            this.applyAutoProperties(entry, editor);
            entry.setPropertyValue("svn:entry:schedule", "add");
            entry.asFile().generateDelta(editor);
            editor.closeFile(null);
        }
        this.fireEntryCommitted(entry, 1);
    }

    private void applyAutoProperties(ISVNEntry entry, ISVNEditor editor) throws SVNException {
        if (this.myCompiledAutoProperties == null) {
            this.myCompiledAutoProperties = SVNWorkspace.compileAutoProperties(this.myAutoProperties);
        }
        Iterator keys = this.myCompiledAutoProperties.keySet().iterator();
        while (keys.hasNext()) {
            Pattern pattern = (Pattern)keys.next();
            if (!pattern.matcher(entry.getName().toLowerCase()).matches()) continue;
            Map properties = (Map)this.myCompiledAutoProperties.get(pattern);
            Iterator entries = properties.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry propEntry = entries.next();
                String name = (String)propEntry.getKey();
                String value = (String)propEntry.getValue();
                entry.setPropertyValue(name, value);
                if (editor == null) continue;
                if (entry.isDirectory()) {
                    editor.changeDirProperty(name, value);
                    continue;
                }
                editor.changeFileProperty(name, value);
            }
        }
    }

    private static Map compileAutoProperties(Map source) {
        HashMap result = new HashMap();
        Iterator entries = source.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (entry.getValue() == null) continue;
            String key = (String)entry.getKey();
            StringBuffer regex = new StringBuffer();
            regex.append('^');
            for (int i = 0; i < key.length(); ++i) {
                char ch = key.charAt(i);
                if (ch == '.') {
                    regex.append("\\.");
                    continue;
                }
                if (ch == '?') {
                    regex.append('.');
                    continue;
                }
                if (ch == '*') {
                    regex.append(".*");
                    continue;
                }
                regex.append(ch);
            }
            regex.append('$');
            String properties = (String)entry.getValue();
            HashMap<String, String> parsedProperties = new HashMap<String, String>();
            StringTokenizer props = new StringTokenizer(properties, ";");
            while (props.hasMoreTokens()) {
                String propset = props.nextToken();
                int index = propset.indexOf(61);
                String value = "";
                String name = null;
                if (index < 0) {
                    name = propset;
                } else {
                    name = propset.substring(0, index);
                    value = propset.substring(index + 1);
                }
                parsedProperties.put(name, value);
            }
            if (parsedProperties.isEmpty()) continue;
            result.put(Pattern.compile(regex.toString().toLowerCase()), parsedProperties);
        }
        return result;
    }

    ISVNEntry locateEntry(String path) throws SVNException {
        return this.locateEntry(path, false);
    }

    ISVNEntry locateEntry(String path, boolean unmanaged) throws SVNException {
        ISVNEntry entry = this.getRoot();
        StringTokenizer tokens = new StringTokenizer(path, "/");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (entry == null) {
                return null;
            }
            entry = entry.asDirectory().getUnmanagedChild(token);
        }
        if (entry != null && !unmanaged && !entry.isManaged()) {
            return null;
        }
        return entry;
    }

    ISVNEntry locateParentEntry(String path) throws SVNException {
        ISVNEntry entry = this.getRoot();
        if ("".equals(path)) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(path, "/");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (!tokens.hasMoreTokens()) {
                return entry;
            }
            entry = entry.asDirectory().getUnmanagedChild(token);
        }
        return null;
    }

    private static void updateURL(ISVNEntry target, String parentURL, boolean recursive) throws SVNException {
        parentURL = PathUtil.append(parentURL, PathUtil.encode(target.getName()));
        target.setPropertyValue("svn:entry:url", parentURL);
        if (target.isDirectory() && recursive) {
            Iterator children = target.asDirectory().childEntries();
            while (children.hasNext()) {
                ISVNEntry child = (ISVNEntry)children.next();
                SVNWorkspace.updateURL(child, parentURL, recursive);
            }
        }
    }

    private Collection createExternals(String path) throws SVNException {
        Collection externals = new HashSet();
        ISVNEntry parent = null;
        if (!"".equals(path)) {
            parent = this.locateParentEntry(path);
        }
        if (parent == null || !parent.isDirectory()) {
            return externals;
        }
        ISVNDirectoryEntry current = parent.asDirectory();
        while (current != null) {
            externals = SVNExternal.create(current, externals);
            current = (ISVNDirectoryEntry)this.locateParentEntry(current.getPath());
        }
        return externals;
    }

    public void runCommand(ISVNRunnable runnable) throws SVNException {
        this.myIsCommandRunning = true;
        this.myIsNeedToSleepForTimestamp = false;
        try {
            try {
                runnable.run(this);
            }
            catch (Throwable th) {
                if (th instanceof SVNException) {
                    throw (SVNException)th;
                }
                throw new SVNException(th);
            }
            Object var4_2 = null;
            this.myIsCommandRunning = false;
            if (this.myIsNeedToSleepForTimestamp) {
                this.sleepForTimestamp();
                this.myIsNeedToSleepForTimestamp = false;
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.myIsCommandRunning = false;
            if (this.myIsNeedToSleepForTimestamp) {
                this.sleepForTimestamp();
                this.myIsNeedToSleepForTimestamp = false;
            }
            throw throwable;
        }
    }

    private void sleepForTimestamp() {
        if (this.myIsCommandRunning) {
            this.myIsNeedToSleepForTimestamp = true;
            return;
        }
        FSUtil.sleepForTimestamp();
    }

    private String getCommitRoot(String[] paths) throws SVNException {
        ISVNEntry entry;
        String root = "";
        if (paths.length == 1 && (entry = this.locateEntry(paths[0])) != null && entry.isDirectory() && entry.isManaged()) {
            root = entry.getPath();
        }
        if (root == null && (root = PathUtil.getCommonRoot(paths)) == null) {
            root = "";
        }
        return root;
    }
}

