/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.ISVNDirectoryEntry;
import org.tmatesoft.svn.core.ISVNEntry;
import org.tmatesoft.svn.core.ISVNStatusHandler;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNStatus;
import org.tmatesoft.svn.core.internal.SVNExternal;
import org.tmatesoft.svn.core.internal.SVNReporterBaton;
import org.tmatesoft.svn.core.internal.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.SVNWorkspace;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.progress.SVNProgressProcessor;
import org.tmatesoft.svn.core.progress.SVNProgressViewerIterator;
import org.tmatesoft.svn.util.PathUtil;

class SVNStatusUtil {
    SVNStatusUtil() {
    }

    static void doStatus(SVNWorkspace ws, ISVNDirectoryEntry parent, SVNStatusEditor editor, ISVNStatusHandler handler, String path, Collection externals, boolean descend, boolean includeUnmodified, boolean includeIgnored, boolean descendInUnversioned, boolean descendFurtherInIgnored, SVNProgressProcessor progressProcessor) throws SVNException {
        SVNStatus status;
        String name;
        boolean isManagedInParent;
        externals = externals == null ? new HashSet() : externals;
        ISVNEntry entry = ws.locateEntry(path, true);
        if (entry != null && entry.isDirectory()) {
            externals = SVNExternal.create(entry.asDirectory(), externals);
        }
        Map statuses = SVNStatusUtil.localStatus(ws, parent, path, null, externals, !descend);
        if (editor != null) {
            statuses = editor.completeStatus(statuses, path, descend);
        }
        if (!entry.isDirectory()) {
            SVNStatusUtil.handleStatus(handler, (SVNStatus)statuses.get(entry.getName()), includeUnmodified, includeIgnored);
            progressProcessor.setProgress(1.0);
            return;
        }
        SVNStatus dirStatus = (SVNStatus)statuses.remove("");
        boolean bl = isManagedInParent = parent != null && parent.isManaged(entry.getName()) || parent == null && entry.isManaged();
        if (dirStatus.getContentsStatus() == 18 || !descendInUnversioned && !isManagedInParent || !descendFurtherInIgnored && dirStatus.getContentsStatus() == 5) {
            SVNStatusUtil.handleStatus(handler, dirStatus, includeUnmodified, includeIgnored);
            progressProcessor.setProgress(1.0);
            return;
        }
        if (descend && dirStatus.getContentsStatus() != 10) {
            SVNProgressViewerIterator it = new SVNProgressViewerIterator(statuses.keySet(), progressProcessor);
            while (it.hasNext()) {
                name = (String)it.next();
                status = (SVNStatus)statuses.get(name);
                if (status == null && (includeIgnored || entry.asDirectory().getChild(name) != null || !entry.asDirectory().isIgnored(name))) {
                    SVNStatusUtil.doStatus(ws, entry.asDirectory(), editor, handler, PathUtil.append(path, name), externals, true, includeUnmodified, includeIgnored, descendInUnversioned, descendFurtherInIgnored, new SVNProgressProcessor(it, progressProcessor));
                }
                progressProcessor.checkCancelled();
            }
        }
        Iterator names = statuses.keySet().iterator();
        while (names.hasNext()) {
            name = (String)names.next();
            status = (SVNStatus)statuses.get(name);
            if (status == null) continue;
            SVNStatusUtil.handleStatus(handler, status, includeUnmodified, includeIgnored);
        }
        SVNStatusUtil.handleStatus(handler, dirStatus, includeUnmodified, includeIgnored);
        progressProcessor.setProgress(1.0);
    }

    private static void handleStatus(ISVNStatusHandler handler, SVNStatus status, boolean includeUnmodified, boolean includeIgnored) {
        if (!includeIgnored && status.getContentsStatus() == 5) {
            return;
        }
        if (!includeUnmodified && status.getContentsStatus() == 0 && status.getPropertiesStatus() == 0 && status.getRepositoryRevision() < 0L && !status.isSwitched()) {
            return;
        }
        handler.handleStatus(status.getPath(), status);
    }

    private static Map localStatus(SVNWorkspace ws, ISVNDirectoryEntry parent, String path, Map result, Collection externals, boolean includeDirs) throws SVNException {
        SVNStatus status;
        ISVNEntry child;
        result = result == null ? new TreeMap() : result;
        ISVNEntry entry = ws.locateEntry(path, true);
        if (entry == null) {
            return result;
        }
        if (entry != null && (parent == null && entry.isManaged() || parent != null && parent.isManaged(entry.getName()))) {
            String parentURL = null;
            if (parent != null) {
                parentURL = parent.getPropertyValue("svn:entry:url");
            }
            result.put(entry.isDirectory() ? "" : entry.getName(), SVNStatusUtil.createManagedStatus(parentURL, entry));
        } else {
            result.put(entry.isDirectory() ? "" : entry.getName(), SVNStatusUtil.createUnmanagedStatus(externals, parent, entry));
        }
        if (!entry.isDirectory()) {
            return result;
        }
        String url = entry.getPropertyValue("svn:entry:url");
        Iterator children = entry.asDirectory().childEntries();
        while (children.hasNext()) {
            child = (ISVNEntry)children.next();
            if (!includeDirs && child.isDirectory()) {
                result.put(child.getName(), null);
                continue;
            }
            status = SVNStatusUtil.createManagedStatus(url, child);
            result.put(child.getName(), status);
        }
        children = entry.asDirectory().unmanagedChildEntries(true);
        while (children.hasNext()) {
            child = (ISVNEntry)children.next();
            if (!includeDirs && child.isDirectory()) {
                result.put(child.getName(), null);
                continue;
            }
            status = SVNStatusUtil.createUnmanagedStatus(externals, entry, child);
            result.put(child.getName(), status);
        }
        return result;
    }

    private static SVNStatus createUnmanagedStatus(Collection externals, ISVNEntry entry, ISVNEntry child) throws SVNException {
        int propStatus = 0;
        int contentsStatus = 8;
        boolean isDirectory = child.isDirectory();
        String childPath = child.getPath();
        if (entry != null && entry.asDirectory().isIgnored(child.getName())) {
            contentsStatus = 5;
        } else if (externals != null) {
            Iterator paths = externals.iterator();
            while (paths.hasNext()) {
                SVNExternal externalPath = (SVNExternal)paths.next();
                if (!externalPath.getPath().startsWith(childPath)) continue;
                contentsStatus = 18;
                break;
            }
        }
        SVNStatus status = new SVNStatus(childPath, propStatus, contentsStatus, -1L, -1L, false, false, isDirectory, null);
        return status;
    }

    private static SVNStatus createManagedStatus(String parentURL, ISVNEntry child) throws SVNException {
        boolean isDirectory = child.isDirectory();
        int propStatus = 0;
        int contentsStatus = 0;
        if (child.isPropertiesModified()) {
            propStatus = 6;
        }
        if (child.getPropertyValue("svn:entry:prop-reject-file") != null) {
            propStatus = 2;
        }
        boolean switched = false;
        if (child.isMissing()) {
            contentsStatus = 9;
        } else if (child.isObstructed()) {
            contentsStatus = 10;
        } else if (child.isScheduledForAddition()) {
            contentsStatus = 1;
            if (child.isScheduledForDeletion()) {
                contentsStatus = 7;
            }
        } else if (child.isScheduledForDeletion()) {
            contentsStatus = 3;
        } else if (!isDirectory) {
            if (child.getPropertyValue("svn:entry:conflict-old") != null || child.getPropertyValue("svn:entry:conflict-new") != null || child.getPropertyValue("svn:entry:conflict-wrk") != null) {
                contentsStatus = 2;
            } else if (child.asFile().isContentsModified()) {
                contentsStatus = 6;
            }
        }
        if (contentsStatus == 1 || contentsStatus == 3) {
            propStatus = 0;
        }
        if (SVNReporterBaton.isSwitched(parentURL, child)) {
            switched = true;
        }
        boolean history = SVNProperty.booleanValue(child.getPropertyValue("svn:entry:copied"));
        long revision = SVNProperty.longValue(child.getPropertyValue("svn:entry:committed-rev"));
        long wcRevision = SVNProperty.longValue(child.getPropertyValue("svn:entry:revision"));
        String author = child.getPropertyValue("svn:entry:last-author");
        SVNStatus status = new SVNStatus(child.getPath(), propStatus, contentsStatus, revision, wcRevision, history, switched, isDirectory, author);
        return status;
    }

    static SVNStatus createStatus(ISVNEntry entry, long remoteRevision, int remoteContents, int remoteProps, String parentURL) throws SVNException {
        int propStatus = 0;
        if (entry.getPropertyValue("svn:entry:prop-reject-file") != null) {
            propStatus = 2;
        } else if (entry.isPropertiesModified()) {
            propStatus = 6;
        }
        int contentsStatus = 0;
        boolean addedWithHistory = false;
        if (entry.getPropertyValue("svn:entry:conflict-old") != null || entry.getPropertyValue("svn:entry:conflict-new") != null || entry.getPropertyValue("svn:entry:conflict-wrk") != null) {
            contentsStatus = 2;
        } else if (entry.isMissing()) {
            contentsStatus = 9;
        } else if (entry.isScheduledForAddition() && entry.isScheduledForDeletion()) {
            contentsStatus = 7;
        } else if (entry.isScheduledForAddition()) {
            contentsStatus = 1;
            addedWithHistory = SVNProperty.booleanValue(entry.getPropertyValue("svn:entry:copied"));
        } else if (entry.isScheduledForDeletion()) {
            contentsStatus = 3;
        } else if (!entry.isDirectory() && entry.asFile().isContentsModified()) {
            contentsStatus = 6;
        }
        boolean isSwitched = SVNReporterBaton.isSwitched(parentURL, entry);
        long revision = SVNProperty.longValue(entry.getPropertyValue("svn:entry:revision"));
        long wcRevision = SVNProperty.longValue(entry.getPropertyValue("svn:entry:committed-rev"));
        if (remoteRevision < 0L) {
            remoteRevision = wcRevision;
        }
        boolean isDir = "dir".equals(entry.getPropertyValue("svn:entry:kind"));
        return new SVNStatus(entry.getPath(), propStatus, contentsStatus, revision, wcRevision, remoteRevision, remoteContents, remoteProps, addedWithHistory, isSwitched, isDir, null);
    }
}

