/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import org.tmatesoft.svn.core.ISVNDirectoryEntry;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.PathUtil;

class SVNExternal {
    private String myPath;
    private long myRevision;
    private SVNRepositoryLocation myLocation;
    static /* synthetic */ Class class$org$tmatesoft$svn$core$internal$SVNExternal;

    public SVNExternal(String path, long revision, SVNRepositoryLocation location) {
        this.myPath = path;
        this.myRevision = revision;
        this.myLocation = location;
    }

    public SVNRepositoryLocation getLocation() {
        return this.myLocation;
    }

    public String getPath() {
        return this.myPath;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public int hashCode() {
        return this.myLocation.toString().hashCode() + 7 * this.myPath.hashCode() + 21 * (this.myRevision + "").hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != (class$org$tmatesoft$svn$core$internal$SVNExternal == null ? (class$org$tmatesoft$svn$core$internal$SVNExternal = SVNExternal.class$("org.tmatesoft.svn.core.internal.SVNExternal")) : class$org$tmatesoft$svn$core$internal$SVNExternal)) {
            return false;
        }
        SVNExternal e = (SVNExternal)o;
        return e.myLocation.toString().equals(this.myLocation.toString()) && e.myPath.equals(this.myPath) && e.myRevision == this.myRevision;
    }

    public static Collection create(ISVNDirectoryEntry entry, Collection externals) {
        String propertyValue = null;
        try {
            propertyValue = entry.getPropertyValue("svn:externals");
        }
        catch (SVNException e2) {
            return externals;
        }
        return SVNExternal.create(entry, propertyValue, externals);
    }

    public static Collection create(ISVNDirectoryEntry entry, String propertyValue, Collection externals) {
        if (entry == null || propertyValue == null) {
            return externals;
        }
        if (propertyValue == null) {
            return externals;
        }
        String basePath = entry.getPath();
        BufferedReader reader = new BufferedReader(new StringReader(propertyValue));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                int index = line.lastIndexOf("://");
                if (index < 0 || (index = Math.max(line.lastIndexOf(" ", index), line.lastIndexOf("\t", index))) < 0) continue;
                String url = line.substring(index + 1);
                SVNRepositoryLocation location = null;
                try {
                    location = SVNRepositoryLocation.parseURL(url);
                }
                catch (SVNException e1) {
                    // empty catch block
                }
                if (location == null) continue;
                line = line.substring(0, index);
                long revision = -1L;
                index = line.lastIndexOf("-r");
                if (index > 0) {
                    String rev = line.substring(index + "-r".length()).trim();
                    revision = Long.parseLong(rev);
                    line = line.substring(0, index);
                }
                String path = PathUtil.append(basePath, line.trim());
                path = PathUtil.removeLeadingSlash(path);
                if (externals == null) {
                    externals = new HashSet<SVNExternal>();
                }
                externals.add(new SVNExternal(path, revision, location));
            }
            reader.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return externals;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

