/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.diff.delta;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceLine;

public class SVNSequenceLineReader {
    private final byte[] myCustomEolBytes;
    private byte[] buffer;

    public SVNSequenceLineReader(byte[] customEolBytes) {
        this(8192, customEolBytes);
    }

    public SVNSequenceLineReader(int initialBufferSize, byte[] customEolBytes) {
        this.myCustomEolBytes = customEolBytes;
        this.buffer = new byte[initialBufferSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNSequenceLine[] read(InputStream rawStream) throws IOException {
        ArrayList<SVNSequenceLine> lines = new ArrayList<SVNSequenceLine>();
        BufferedInputStream stream = new BufferedInputStream(rawStream);
        try {
            int ch;
            int pushBack = -1;
            int from = 0;
            int length = 0;
            int eolLength = 0;
            int lastLength = 0;
            do {
                if ((ch = pushBack) != -1) {
                    pushBack = -1;
                } else {
                    ch = stream.read();
                }
                if (ch != -1) {
                    this.append(length, (byte)(ch & 0xFF));
                    ++length;
                }
                switch (ch) {
                    case 13: {
                        pushBack = stream.read();
                        if (pushBack == 10) {
                            this.append(length, (byte)(pushBack & 0xFF));
                            ++length;
                            ++eolLength;
                            pushBack = -1;
                        }
                    }
                    case 10: {
                        ++eolLength;
                    }
                    case -1: {
                        if (length > 0) {
                            byte[] bytes;
                            if (this.myCustomEolBytes != null && eolLength > 0) {
                                bytes = new byte[length - eolLength + this.myCustomEolBytes.length];
                                System.arraycopy(this.buffer, 0, bytes, 0, length - eolLength);
                                System.arraycopy(this.myCustomEolBytes, 0, bytes, length - eolLength, this.myCustomEolBytes.length);
                            } else {
                                bytes = new byte[length];
                                System.arraycopy(this.buffer, 0, bytes, 0, length);
                            }
                            lines.add(new SVNSequenceLine(from, from + bytes.length - 1, bytes));
                            lastLength = length;
                        }
                        from += length;
                        length = 0;
                        eolLength = 0;
                    }
                }
            } while (ch != -1);
            if (this.myCustomEolBytes != null && --lastLength < this.buffer.length && lastLength >= 0 && (this.buffer[lastLength] == 13 || this.buffer[lastLength] == 10)) {
                lines.add(new SVNSequenceLine(from, from - 1, new byte[0]));
            }
            SVNSequenceLine[] sVNSequenceLineArray = lines.toArray(new SVNSequenceLine[lines.size()]);
            return sVNSequenceLineArray;
        }
        finally {
            stream.close();
        }
    }

    private void append(int position, byte ch) {
        if (position >= this.buffer.length) {
            byte[] newArray = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newArray, 0, this.buffer.length);
            this.buffer = newArray;
        }
        this.buffer[position] = ch;
    }
}

