/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.diff;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.diff.ISVNDiffGenerator;
import org.tmatesoft.svn.core.diff.ISVNDiffGeneratorFactory;
import org.tmatesoft.svn.core.diff.SVNDiffManager;
import org.tmatesoft.svn.core.diff.SVNSequenceDiffGenerator;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceLine;

public class SVNUniDiffGenerator
extends SVNSequenceDiffGenerator
implements ISVNDiffGeneratorFactory {
    public static final String TYPE = "unified";
    private Map myGeneratorsCache;

    private SVNUniDiffGenerator(Map properties) {
        super(properties);
    }

    private SVNUniDiffGenerator() {
        super(null);
    }

    public void generateDiffHeader(String item, String leftInfo, String rightInfo, Writer output) throws IOException {
        leftInfo = leftInfo == null ? "" : "\t" + leftInfo;
        rightInfo = rightInfo == null ? "" : "\t" + rightInfo;
        this.println("--- " + item + leftInfo, output);
        this.println("+++ " + item + rightInfo, output);
    }

    protected void processBlock(QSequenceDifferenceBlock[] segment, SVNSequenceLine[] sourceLines, SVNSequenceLine[] targetLines, String encoding, Writer output) throws IOException {
        int i;
        int gutter = this.getGutter();
        StringBuffer header = new StringBuffer();
        header.append("@@");
        int sourceStartLine = segment[0].getLeftFrom();
        int sourceEndLine = segment[segment.length - 1].getLeftTo();
        int targetStartLine = segment[0].getRightFrom();
        int targetEndLine = segment[segment.length - 1].getRightTo();
        int leftStart = Math.max(sourceStartLine - gutter, 0);
        int rightStart = Math.max(targetStartLine - gutter, 0);
        int leftEnd = Math.min(sourceEndLine + gutter, sourceLines.length - 1);
        int rightEnd = Math.min(targetEndLine + gutter, targetLines.length - 1);
        if (leftStart + 1 >= 0 && leftEnd - leftStart + 1 >= 0) {
            header.append(" -");
            header.append(leftStart + 1);
            header.append(",");
            header.append(leftEnd - leftStart + 1);
        }
        if (rightStart + 1 > 0 && rightEnd - rightStart + 1 > 0) {
            header.append(" +");
            header.append(rightStart + 1);
            header.append(",");
            header.append(rightEnd - rightStart + 1);
        }
        header.append(" @@");
        this.println(header.toString(), output);
        for (i = leftStart; i < sourceStartLine; ++i) {
            this.print(" " + this.printLine(sourceLines[i], encoding), output);
        }
        for (i = 0; i < segment.length; ++i) {
            String line;
            int j;
            QSequenceDifferenceBlock block = segment[i];
            for (j = block.getLeftFrom(); j <= block.getLeftTo(); ++j) {
                line = this.printLine(sourceLines[j], encoding);
                this.print("-" + line, output);
                if (j != sourceLines.length - 1 || !this.isCompareEOLs()) continue;
                this.printNoNewLine(output, line);
            }
            for (j = block.getRightFrom(); j <= block.getRightTo(); ++j) {
                line = this.printLine(targetLines[j], encoding);
                this.print("+" + line, output);
                if (j != targetLines.length - 1 || !this.isCompareEOLs()) continue;
                this.printNoNewLine(output, line);
            }
            int end = Math.min(block.getLeftTo() + gutter, sourceLines.length - 1);
            if (i + 1 < segment.length) {
                end = Math.min(end, segment[i + 1].getLeftFrom() - 1);
            }
            for (int j2 = block.getLeftTo() + 1; j2 <= end; ++j2) {
                String line2 = this.printLine(sourceLines[j2], encoding);
                this.print(" " + this.printLine(sourceLines[j2], encoding), output);
                if (j2 != sourceLines.length - 1 || !this.isCompareEOLs()) continue;
                this.printNoNewLine(output, line2);
            }
        }
    }

    private void printNoNewLine(Writer output, String line) throws IOException {
        if (!line.endsWith("\n") && !line.endsWith("\r")) {
            this.println(output);
            this.println("\\ No newline at end of file", output);
        }
    }

    public ISVNDiffGenerator createGenerator(Map properties) {
        ISVNDiffGenerator generator;
        if (this.myGeneratorsCache == null) {
            this.myGeneratorsCache = new HashMap();
        }
        if (properties == null || !properties.containsKey("gutter")) {
            properties = new HashMap<String, String>(properties == null ? Collections.EMPTY_MAP : properties);
            properties.put("gutter", "3");
        }
        if ((generator = (ISVNDiffGenerator)this.myGeneratorsCache.get(properties)) != null) {
            return generator;
        }
        generator = new SVNUniDiffGenerator(properties);
        this.myGeneratorsCache.put(properties, generator);
        return generator;
    }

    public static void setup() {
        SVNDiffManager.registerDiffGeneratorFactory(new SVNUniDiffGenerator(), TYPE);
    }
}

