/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.diff;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.diff.ISVNDiffGenerator;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceLine;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceLineReader;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceMedia;

public abstract class SVNSequenceDiffGenerator
implements ISVNDiffGenerator {
    private Map myProperties;

    protected SVNSequenceDiffGenerator(Map properties) {
        this.myProperties = properties == null ? Collections.EMPTY_MAP : properties;
        this.myProperties = Collections.unmodifiableMap(this.myProperties);
    }

    protected Map getProperties() {
        return this.myProperties;
    }

    protected String getEOL() {
        if (this.getProperties().get("eol") instanceof String) {
            return (String)this.getProperties().get("eol");
        }
        return System.getProperty("line.separator", "\n");
    }

    protected boolean isCompareEOLs() {
        return Boolean.TRUE.toString().equals(this.getProperties().get("compareEOL"));
    }

    protected int getGutter() {
        Object gutterStr = this.getProperties().get("gutter");
        if (gutterStr == null) {
            return 0;
        }
        try {
            return Integer.parseInt(gutterStr.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected String printLine(SVNSequenceLine line, String encoding) throws IOException {
        String str = new String(line.getBytes(), encoding);
        return this.isCompareEOLs() ? str : str + this.getEOL();
    }

    public void generateBinaryDiff(InputStream left, InputStream right, String encoding, Writer output) throws IOException {
        this.println("Binary files are different", output);
    }

    public void generateTextDiff(InputStream left, InputStream right, String encoding, Writer output) throws IOException {
        SVNSequenceLineReader reader = new SVNSequenceLineReader(this.isCompareEOLs() ? null : new byte[]{});
        SVNSequenceLine[] leftLines = reader.read(left);
        SVNSequenceLine[] rightLines = reader.read(right);
        List blocksList = SVNSequenceMedia.createBlocks(leftLines, rightLines);
        List combinedBlocks = SVNSequenceDiffGenerator.combineBlocks(blocksList, this.getGutter());
        Iterator blocks = combinedBlocks.iterator();
        while (blocks.hasNext()) {
            List segment = (List)blocks.next();
            if (segment.isEmpty()) continue;
            QSequenceDifferenceBlock[] segmentBlocks = segment.toArray(new QSequenceDifferenceBlock[segment.size()]);
            this.processBlock(segmentBlocks, leftLines, rightLines, encoding, output);
        }
    }

    protected abstract void processBlock(QSequenceDifferenceBlock[] var1, SVNSequenceLine[] var2, SVNSequenceLine[] var3, String var4, Writer var5) throws IOException;

    protected void println(Writer output) throws IOException {
        output.write(this.getEOL());
    }

    protected void println(String str, Writer output) throws IOException {
        if (str != null) {
            output.write(str);
        }
        output.write(this.getEOL());
    }

    protected void print(String str, Writer output) throws IOException {
        if (str != null) {
            output.write(str);
        }
    }

    private static List combineBlocks(List blocksList, int gutter) {
        LinkedList combinedBlocks = new LinkedList();
        LinkedList<QSequenceDifferenceBlock> currentList = new LinkedList<QSequenceDifferenceBlock>();
        QSequenceDifferenceBlock lastBlock = null;
        Iterator blocks = blocksList.iterator();
        while (blocks.hasNext()) {
            QSequenceDifferenceBlock currentBlock = (QSequenceDifferenceBlock)blocks.next();
            if (lastBlock != null && currentBlock.getLeftFrom() - 1 - lastBlock.getLeftTo() > gutter && currentBlock.getRightFrom() - 1 - lastBlock.getRightTo() > gutter) {
                combinedBlocks.add(currentList);
                currentList = new LinkedList();
            }
            currentList.add(currentBlock);
            lastBlock = currentBlock;
        }
        if (currentList != null && !combinedBlocks.contains(currentList)) {
            combinedBlocks.add(currentList);
        }
        return combinedBlocks;
    }
}

