/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.diff;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.diff.ISVNDiffGenerator;
import org.tmatesoft.svn.core.diff.ISVNDiffGeneratorFactory;
import org.tmatesoft.svn.core.diff.SVNDiffManager;
import org.tmatesoft.svn.core.diff.SVNSequenceDiffGenerator;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceLine;

public class SVNNormalDiffGenerator
extends SVNSequenceDiffGenerator
implements ISVNDiffGeneratorFactory {
    public static final String TYPE = "normal";
    private Map myGeneratorsCache;

    private SVNNormalDiffGenerator(Map properties) {
        super(properties);
    }

    private SVNNormalDiffGenerator() {
        super(null);
    }

    public void generateDiffHeader(String item, String leftInfo, String rightInfo, Writer output) throws IOException {
        output.write("*** ");
        output.write(item);
        output.write(this.getEOL());
    }

    protected void processBlock(QSequenceDifferenceBlock[] segment, SVNSequenceLine[] sourceLines, SVNSequenceLine[] targetLines, String encoding, Writer output) throws IOException {
        for (int i = 0; i < segment.length; ++i) {
            QSequenceDifferenceBlock block = segment[i];
            this.processBlock(block.getLeftFrom(), block.getLeftTo(), sourceLines, block.getRightFrom(), block.getRightTo(), targetLines, encoding, output);
        }
    }

    protected void processBlock(int sourceStartLine, int sourceEndLine, SVNSequenceLine[] sourceLines, int targetStartLine, int targetEndLine, SVNSequenceLine[] targetLines, String encoding, Writer output) throws IOException {
        if (sourceStartLine > sourceEndLine) {
            this.add(sourceStartLine, targetStartLine, targetEndLine, targetLines, encoding, output);
        } else if (targetStartLine > targetEndLine) {
            this.delete(targetStartLine, sourceStartLine, sourceEndLine, sourceLines, encoding, output);
        } else {
            this.change(targetStartLine, targetEndLine, targetLines, sourceStartLine, sourceEndLine, sourceLines, encoding, output);
        }
    }

    protected String displayWhiteSpace(String s) {
        if (Boolean.TRUE.toString().equals(this.getProperties().get("whitespace"))) {
            s = s.replaceAll("\t", "<tb>");
            s = s.replaceAll(" ", ".");
        }
        return s;
    }

    protected void delete(int deleteAt, int deleteStart, int deleteEnd, SVNSequenceLine[] deleteLines, String encoding, Writer output) throws IOException {
        int displayStart = deleteStart + 1;
        int displayEnd = deleteEnd + 1;
        int displayAt = deleteAt + 1;
        this.println(displayStart + (displayEnd != displayStart ? "," + displayEnd : "") + "d" + displayAt, output);
        int delLine = deleteStart;
        while (delLine <= deleteEnd) {
            this.print("<" + this.displayWhiteSpace(this.printLine(deleteLines[delLine++], encoding)), output);
        }
    }

    protected void add(int addAt, int addStart, int addEnd, SVNSequenceLine[] addLines, String encoding, Writer output) throws IOException {
        int displayStart = addStart + 1;
        int displayEnd = addEnd + 1;
        int displayAt = addAt + 1;
        this.println(displayAt + "a" + displayStart + (displayEnd != displayStart ? "," + displayEnd : ""), output);
        int addLine = addStart;
        while (addLine <= addEnd) {
            this.print(">" + this.displayWhiteSpace(this.printLine(addLines[addLine++], encoding)), output);
        }
    }

    protected void change(int replaceStart, int replaceEnd, SVNSequenceLine[] replaceLines, int replaceWithStart, int replaceWithEnd, SVNSequenceLine[] replaceWithLines, String encoding, Writer output) throws IOException {
        int displayStart = replaceStart + 1;
        int displayEnd = replaceEnd + 1;
        int displayWithStart = replaceWithStart + 1;
        int displayWithEnd = replaceWithEnd + 1;
        this.println(displayStart + (displayEnd != displayStart ? "," + displayEnd : "") + "c" + displayWithStart + (displayWithEnd != displayWithStart ? "," + displayWithEnd : ""), output);
        int replaceLine = replaceStart;
        while (replaceLine <= replaceEnd) {
            this.print("<" + this.displayWhiteSpace(this.printLine(replaceLines[replaceLine++], encoding)), output);
        }
        this.println("---", output);
        int replaceWithLine = replaceWithStart;
        while (replaceWithLine <= replaceWithEnd) {
            this.print(">" + this.displayWhiteSpace(this.printLine(replaceWithLines[replaceWithLine++], encoding)), output);
        }
    }

    public ISVNDiffGenerator createGenerator(Map properties) {
        ISVNDiffGenerator generator;
        if (this.myGeneratorsCache == null) {
            this.myGeneratorsCache = new HashMap();
        }
        if ((generator = (ISVNDiffGenerator)this.myGeneratorsCache.get(properties)) != null) {
            return generator;
        }
        generator = new SVNNormalDiffGenerator(properties);
        this.myGeneratorsCache.put(properties, generator);
        return generator;
    }

    public static void setup() {
        SVNDiffManager.registerDiffGeneratorFactory(new SVNNormalDiffGenerator(), TYPE);
    }
}

