/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.diff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.tmatesoft.svn.core.diff.SVNDiffInstruction;
import org.tmatesoft.svn.core.diff.SVNDiffWindow;

public class SVNDiffWindowBuilder {
    private static final int HEADER = 0;
    private static final int OFFSET = 1;
    private static final int INSTRUCTIONS = 2;
    private static final int DONE = 3;
    private static final byte[] HEADER_BYTES = new byte[]{83, 86, 78, 0};
    private int myState;
    private int[] myOffsets;
    private byte[] myInstructions;
    private byte[] myHeader;
    private SVNDiffWindow myDiffWindow;

    public static SVNDiffWindowBuilder newInstance() {
        return new SVNDiffWindowBuilder();
    }

    private SVNDiffWindowBuilder() {
        this.reset();
    }

    public void reset() {
        this.reset(0);
    }

    public void reset(int state) {
        int i;
        this.myOffsets = new int[5];
        this.myHeader = new byte[4];
        this.myInstructions = null;
        this.myState = state;
        for (i = 0; i < this.myOffsets.length; ++i) {
            this.myOffsets[i] = -1;
        }
        for (i = 0; i < this.myHeader.length; ++i) {
            this.myHeader[i] = -1;
        }
        this.myDiffWindow = null;
    }

    public boolean isBuilt() {
        return this.myState == 3;
    }

    public SVNDiffWindow getDiffWindow() {
        return this.myDiffWindow;
    }

    public int accept(byte[] bytes, int offset) {
        switch (this.myState) {
            case 0: {
                for (int i = 0; i < this.myHeader.length && offset < bytes.length; ++i) {
                    if (this.myHeader[i] >= 0) continue;
                    this.myHeader[i] = bytes[offset++];
                }
                if (this.myHeader[this.myHeader.length - 1] < 0) break;
                this.myState = 1;
                if (offset >= bytes.length) break;
                return this.accept(bytes, offset);
            }
            case 1: {
                for (int i = 0; i < this.myOffsets.length && offset < bytes.length; ++i) {
                    if (this.myOffsets[i] >= 0) continue;
                    offset = SVNDiffWindowBuilder.readInt(bytes, offset, this.myOffsets, i);
                    if (this.myOffsets[i] >= 0) continue;
                    return offset;
                }
                if (this.myOffsets[this.myOffsets.length - 1] < 0) break;
                this.myState = 2;
                if (offset >= bytes.length) break;
                return this.accept(bytes, offset);
            }
            case 2: {
                if (this.myOffsets[3] > 0) {
                    if (this.myInstructions == null) {
                        this.myInstructions = new byte[this.myOffsets[3]];
                    }
                    int length = Math.min(bytes.length - offset, this.myOffsets[3]);
                    System.arraycopy(bytes, offset, this.myInstructions, this.myInstructions.length - this.myOffsets[3], length);
                    this.myOffsets[3] = this.myOffsets[3] - length;
                    if (this.myOffsets[3] == 0) {
                        this.myState = 3;
                        if (this.myDiffWindow == null) {
                            this.myDiffWindow = SVNDiffWindowBuilder.createDiffWindow(this.myOffsets, this.myInstructions);
                        }
                    }
                    return offset + length;
                }
                if (this.myDiffWindow == null) {
                    this.myDiffWindow = SVNDiffWindowBuilder.createDiffWindow(this.myOffsets, this.myInstructions);
                }
                this.myState = 3;
            }
        }
        return offset;
    }

    public static void save(SVNDiffWindow window, OutputStream os) throws IOException {
        os.write(HEADER_BYTES);
        if (window.getInstructionsCount() == 0) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < window.getInstructionsCount(); ++i) {
            SVNDiffInstruction instruction = window.getInstructionAt(i);
            byte first = (byte)(instruction.type << 6);
            if (instruction.length <= 63L && instruction.length > 0L) {
                first = (byte)((long)first | instruction.length & 0x3FL);
                bos.write(first & 0xFF);
            } else {
                bos.write(first & 0xFF);
                SVNDiffWindowBuilder.writeInt(bos, instruction.length);
            }
            if (instruction.type != 0 && instruction.type != 1) continue;
            SVNDiffWindowBuilder.writeInt(bos, instruction.offset);
        }
        long[] offsets = new long[]{window.getSourceViewOffset(), window.getSourceViewLength(), window.getTargetViewLength(), bos.size(), window.getNewDataLength()};
        for (int i = 0; i < offsets.length; ++i) {
            SVNDiffWindowBuilder.writeInt(os, offsets[i]);
        }
        os.write(bos.toByteArray());
    }

    public static SVNDiffWindow createReplacementDiffWindow(long dataLength) {
        if (dataLength == 0L) {
            return new SVNDiffWindow(0L, 0L, dataLength, new SVNDiffInstruction[0], dataLength);
        }
        SVNDiffInstruction[] instructions = new SVNDiffInstruction[]{new SVNDiffInstruction(2, dataLength, 0L)};
        return new SVNDiffWindow(0L, 0L, dataLength, instructions, dataLength);
    }

    private static void writeInt(OutputStream os, long i) throws IOException {
        if (i == 0L) {
            os.write(0);
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (i > 0L) {
            byte b = (byte)(i & 0x7FL);
            i >>= 7;
            if (bos.size() > 0) {
                b = (byte)(b | 0x80);
            }
            bos.write(b);
        }
        byte[] bytes = bos.toByteArray();
        for (int j = bytes.length - 1; j >= 0; --j) {
            os.write(bytes[j]);
        }
    }

    private static int readInt(byte[] bytes, int offset, int[] target, int index) {
        int newOffset;
        block1: {
            newOffset = offset;
            target[index] = 0;
            do {
                byte b = bytes[newOffset];
                target[index] = target[index] << 7;
                target[index] = target[index] | b & 0x7F;
                if ((b & 0x80) == 0) break block1;
            } while (++newOffset < bytes.length);
            target[index] = -1;
            return offset;
        }
        return newOffset + 1;
    }

    private static SVNDiffWindow createDiffWindow(int[] offsets, byte[] instructions) {
        SVNDiffWindow window = new SVNDiffWindow(offsets[0], offsets[1], offsets[2], SVNDiffWindowBuilder.createInstructions(instructions), offsets[4]);
        return window;
    }

    private static SVNDiffInstruction[] createInstructions(byte[] bytes) {
        ArrayList<SVNDiffInstruction> instructions = new ArrayList<SVNDiffInstruction>();
        int[] instr = new int[2];
        int i = 0;
        while (i < bytes.length) {
            SVNDiffInstruction instruction = new SVNDiffInstruction();
            instruction.type = (bytes[i] & 0xC0) >> 6;
            instruction.length = bytes[i] & 0x3F;
            ++i;
            if (instruction.length == 0L) {
                i = SVNDiffWindowBuilder.readInt(bytes, i, instr, 0);
                instruction.length = instr[0];
            }
            if (instruction.type == 0 || instruction.type == 1) {
                i = SVNDiffWindowBuilder.readInt(bytes, i, instr, 1);
                instruction.offset = instr[1];
            }
            instructions.add(instruction);
            instr[0] = 0;
            instr[1] = 0;
        }
        return instructions.toArray(new SVNDiffInstruction[instructions.size()]);
    }
}

