/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNEntryFactory;
import org.tmatesoft.svn.core.ISVNRootEntry;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.internal.SVNWorkspace;
import org.tmatesoft.svn.core.io.SVNException;

public class SVNWorkspaceManager {
    private static Map ourFactories;

    public static ISVNWorkspace createWorkspace(String type, String rootID) throws SVNException {
        if (ourFactories != null && type != null) {
            ISVNEntryFactory factory = (ISVNEntryFactory)ourFactories.get(type);
            if (factory != null) {
                ISVNRootEntry root = factory.createEntry(rootID);
                if (root != null) {
                    return new SVNWorkspace(root);
                }
            } else {
                throw new SVNException("can't locate root factory for type " + type);
            }
        }
        return null;
    }

    protected static void registerRootFactory(String type, ISVNEntryFactory factory) {
        if (type == null || factory == null) {
            return;
        }
        if (ourFactories == null) {
            ourFactories = new HashMap();
        }
        ourFactories.put(type, factory);
    }
}

