/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import org.tigris.subversion.javahl.Notify;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.SVNWorkspaceAdapter;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.SVNUtil;

class LocalWorkspaceListener
extends SVNWorkspaceAdapter {
    private ISVNWorkspace myWorkspace;
    private Notify myNotify;

    public LocalWorkspaceListener(Notify notify, ISVNWorkspace ws) {
        this.myWorkspace = ws;
        this.myNotify = notify;
    }

    public void modified(String p, int kind) {
        if (this.myNotify == null) {
            return;
        }
        int updateKind = 0;
        switch (kind) {
            case 11: {
                updateKind = 4;
                break;
            }
            case 20: {
                updateKind = 5;
                break;
            }
            case 1: {
                updateKind = 0;
                break;
            }
            case 3: {
                updateKind = 2;
                break;
            }
            case 12: {
                updateKind = 6;
                break;
            }
            case 15: {
                updateKind = 3;
            }
        }
        try {
            String mimeType = this.myWorkspace.getPropertyValue(p, "svn:mime-type");
            String nodeKindStr = this.myWorkspace.getPropertyValue(p, "svn:entry:kind");
            int nodeKind = 3;
            if ("dir".equals(nodeKindStr)) {
                nodeKind = 2;
            } else if ("file".equals(nodeKindStr)) {
                nodeKind = 1;
            }
            p = SVNUtil.getAbsolutePath(this.myWorkspace, p);
            this.myNotify.onNotify(p, updateKind, nodeKind, mimeType, 0, 0, 0L);
        }
        catch (SVNException e) {
            // empty catch block
        }
    }
}

