/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import org.tigris.subversion.javahl.Notify;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.SVNWorkspaceAdapter;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.SVNUtil;

class CommitWorkspaceListener
extends SVNWorkspaceAdapter {
    private ISVNWorkspace myWorkspace;
    private Notify myNotify;

    public CommitWorkspaceListener(Notify notify, ISVNWorkspace ws) {
        this.myWorkspace = ws;
        this.myNotify = notify;
    }

    public void committed(String path, int kind) {
        if (this.myNotify == null) {
            return;
        }
        int updateKind = 0;
        switch (kind) {
            case 6: {
                updateKind = 15;
                break;
            }
            case 1: {
                updateKind = 16;
                break;
            }
            case 3: {
                updateKind = 17;
                break;
            }
            case 7: {
                updateKind = 18;
            }
        }
        try {
            String mimeType = this.myWorkspace.getPropertyValue(path, "svn:mime-type");
            String nodeKindStr = this.myWorkspace.getPropertyValue(path, "svn:entry:kind");
            int nodeKind = 3;
            if ("dir".equals(nodeKindStr)) {
                nodeKind = 2;
            } else if ("file".equals(nodeKindStr)) {
                nodeKind = 1;
            }
            path = SVNUtil.getAbsolutePath(this.myWorkspace, path);
            this.myNotify.onNotify(path, updateKind, nodeKind, mimeType, 0, 0, 0L);
        }
        catch (SVNException e) {
            // empty catch block
        }
    }
}

