/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.IOException;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.ISVNWorkspaceListener;
import org.tmatesoft.svn.core.SVNWorkspaceAdapter;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.SVNUtil;

public class UpdateCommand
extends SVNCommand {
    public void run(final PrintStream out, final PrintStream err) throws SVNException {
        for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            String absolutPath = this.getCommandLine().getPathAt(i);
            final ISVNWorkspace workspace = this.createWorkspace(absolutPath, true);
            final String homePath = absolutPath;
            final boolean[] changesReceived = new boolean[]{false};
            workspace.addWorkspaceListener((ISVNWorkspaceListener)new SVNWorkspaceAdapter(){

                public void updated(String updatedPath, int contentsStatus, int propertiesStatus, long rev) {
                    DebugLog.log((String)("updated path: " + updatedPath));
                    try {
                        updatedPath = UpdateCommand.this.convertPath(homePath, workspace, updatedPath);
                    }
                    catch (IOException e) {
                        DebugLog.error((Throwable)e);
                    }
                    char contents = 'U';
                    char properties = ' ';
                    if (propertiesStatus == 16) {
                        properties = 'U';
                    } else if (propertiesStatus == 2) {
                        properties = 'C';
                    }
                    if (contentsStatus == 1) {
                        contents = 'A';
                        properties = ' ';
                    } else if (contentsStatus == 3) {
                        contents = 'D';
                    } else if (contentsStatus == 4) {
                        contents = 'G';
                    } else if (contentsStatus == 2) {
                        contents = 'C';
                    } else if (contentsStatus == 0) {
                        contents = ' ';
                    } else if (contentsStatus == 19) {
                        contents = 'U';
                    }
                    if (contents == ' ' && properties == ' ') {
                        return;
                    }
                    changesReceived[0] = true;
                    DebugLog.log((String)(contents + "" + properties + ' ' + updatedPath));
                    out.println(contents + "" + properties + ' ' + updatedPath);
                    if (contentsStatus == 19) {
                        err.println("svn: Checksum error: base version of file '" + updatedPath + "' is corrupted and was not updated.");
                        DebugLog.log((String)("svn: Checksum error: base version of file '" + updatedPath + "' is corrupted and was not updated."));
                    }
                }

                public void modified(String path, int kind) {
                    try {
                        path = UpdateCommand.this.convertPath(homePath, workspace, path);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    DebugLog.log((String)("Restored '" + path + "'"));
                    out.println("Restored '" + path + "'");
                }
            });
            String path = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)absolutPath);
            long revision = UpdateCommand.parseRevision(this.getCommandLine(), workspace, path);
            revision = workspace.update(path, revision, !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE));
            if (!changesReceived[0]) {
                UpdateCommand.println(out, "At revision " + revision + ".");
                continue;
            }
            UpdateCommand.println(out, "Updated to revision " + revision + ".");
        }
    }
}

