/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import org.tmatesoft.svn.cli.CollectingExternalsHandler;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.SVNCommandLine;
import org.tmatesoft.svn.core.ISVNExternalsHandler;
import org.tmatesoft.svn.core.ISVNStatusHandler;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.SVNStatus;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.SVNUtil;

public class StatusCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        String path;
        int i;
        SVNCommandLine line = this.getCommandLine();
        for (i = 0; i < line.getPathCount(); ++i) {
            path = line.getPathAt(i);
            if (!path.trim().endsWith("..")) continue;
            err.println("Path '" + path + "' ends with '..', which is unsupported for this operation");
            return;
        }
        for (i = 0; i < line.getPathCount(); ++i) {
            String homePath = path = line.getPathAt(i);
            ISVNWorkspace workspace = this.createWorkspace(path);
            DebugLog.log((String)("workspace created at: " + workspace.getID()));
            try {
                path = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)new File(path).getCanonicalPath());
            }
            catch (IOException e) {
                throw new SVNException((Throwable)e);
            }
            DebugLog.log((String)("path in workspace: " + path));
            this.doStatus(homePath, workspace, path, !line.hasArgument(SVNArgument.NON_RECURSIVE), line.hasArgument(SVNArgument.SHOW_UPDATES), line.hasArgument(SVNArgument.VERBOSE), line.hasArgument(SVNArgument.NO_IGNORE), out);
        }
    }

    private void doStatus(final String wcPath, final ISVNWorkspace ws, String path, boolean descend, boolean remote, boolean all, boolean noIgnore, final PrintStream out) throws SVNException {
        CollectingExternalsHandler externalsHandler = new CollectingExternalsHandler();
        ISVNStatusHandler statusHandler = new ISVNStatusHandler(){

            public void handleStatus(String entryPath, SVNStatus status) {
                try {
                    String fullPath = StatusCommand.this.convertPath(wcPath, ws, entryPath);
                    StatusCommand.this.printStatus(fullPath, status, out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        ws.setExternalsHandler((ISVNExternalsHandler)externalsHandler);
        long revision = ws.status(path, remote, statusHandler, descend, all, noIgnore, false, false);
        if (remote) {
            out.println("Status against revision: " + StatusCommand.formatString(revision + "", 6, false));
        }
        Iterator paths = externalsHandler.externalPaths();
        while (paths.hasNext()) {
            String externalPath = (String)paths.next();
            try {
                externalPath = this.convertPath(this.getCommandLine().getPathAt(0), ws, externalPath);
            }
            catch (IOException e) {
                // empty catch block
            }
            out.println();
            out.println("Performing status on external item at '" + externalPath + "'");
            ISVNWorkspace externalWorkspace = externalsHandler.getExternalWorkspace(externalPath);
            try {
                this.doStatus(wcPath, externalWorkspace, "", descend, remote, all, noIgnore, out);
            }
            catch (Throwable th) {
                out.println("error: " + th.getMessage());
            }
        }
    }

    protected boolean isValidArgument(String name) {
        return "-N".equals(name) || "-v".equals(name) || "-u".equals(name) || "--no-ignore".equals(name) || "-q".equals(name);
    }

    public String usage() {
        return "status [-N] [-v] [-u] PATH";
    }

    private void printStatus(String path, SVNStatus status, PrintStream out) {
        if (this.getCommandLine().hasArgument(SVNArgument.QUIET) && (!status.isManaged() || status.getContentsStatus() == 18)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        this.appendStatus(status.getContentsStatus(), sb);
        this.appendStatus(status.getPropertiesStatus(), sb);
        sb.append(" ");
        if (status.isAddedWithHistory()) {
            sb.append("+");
        } else {
            sb.append(" ");
        }
        if (status.isSwitched()) {
            sb.append("S");
        }
        sb.append(" ");
        boolean detailed = this.getCommandLine().hasArgument(SVNArgument.SHOW_UPDATES) || this.getCommandLine().hasArgument(SVNArgument.VERBOSE);
        boolean displayLastCommited = this.getCommandLine().hasArgument(SVNArgument.VERBOSE);
        if (!detailed) {
            sb.append("  ");
        } else {
            char remote = ' ';
            if (status.getRepositoryContentsStatus() != 0 || status.getRepositoryPropertiesStatus() != 0) {
                remote = '*';
            }
            sb.append("  ");
            sb.append(remote);
            String wcRevision = "";
            if (!status.isManaged()) {
                wcRevision = "";
            } else if (status.getWorkingCopyRevision() < 0L && remote != '*') {
                wcRevision = " ? ";
            } else if (status.isAddedWithHistory()) {
                wcRevision = "-";
            } else if (status.getWorkingCopyRevision() >= 0L) {
                wcRevision = status.getWorkingCopyRevision() + "";
            }
            if (status.isManaged() && status.getContentsStatus() == 18) {
                wcRevision = "";
            }
            wcRevision = StatusCommand.formatString(wcRevision, 6, false);
            sb.append("   ");
            sb.append(wcRevision);
            if (displayLastCommited) {
                String commitedRevsion = status.isManaged() && status.getRevision() >= 0L ? status.getRevision() + "" : (status.isManaged() && remote != '*' ? " ? " : "");
                if (status.isManaged() && status.getContentsStatus() == 18) {
                    commitedRevsion = "";
                }
                commitedRevsion = StatusCommand.formatString(commitedRevsion, 6, false);
                sb.append("   ");
                sb.append(commitedRevsion);
                String author = status.isManaged() && status.getAuthor() != null ? status.getAuthor() : (status.isManaged() && remote != '*' || status.getAuthor() == null ? " ? " : "");
                author = StatusCommand.formatString(author.trim(), 12, true);
                sb.append(" ");
                sb.append(author);
                sb.append(" ");
            } else {
                sb.append("   ");
            }
        }
        sb.append(path);
        if (out != null) {
            out.println(sb.toString());
        }
        DebugLog.log((String)sb.toString());
    }

    private void appendStatus(int statusKind, StringBuffer sb) {
        switch (statusKind) {
            case 1: {
                sb.append("A");
                break;
            }
            case 2: {
                sb.append("C");
                break;
            }
            case 3: {
                sb.append("D");
                break;
            }
            case 7: {
                sb.append("R");
                break;
            }
            case 18: {
                sb.append("X");
                break;
            }
            case 5: {
                sb.append("I");
                break;
            }
            case 4: {
                sb.append("G");
                break;
            }
            case 9: {
                sb.append("!");
                break;
            }
            case 6: {
                sb.append("M");
                break;
            }
            case 0: {
                sb.append(" ");
                break;
            }
            case 10: {
                sb.append("~");
                break;
            }
            case 8: {
                sb.append("?");
                break;
            }
            default: {
                sb.append("@");
            }
        }
    }

    private static String formatString(String str, int chars, boolean left) {
        if (str.length() > chars) {
            return str.substring(0, chars);
        }
        StringBuffer formatted = new StringBuffer();
        if (left) {
            formatted.append(str);
        }
        for (int i = 0; i < chars - str.length(); ++i) {
            formatted.append(' ');
        }
        if (!left) {
            formatted.append(str);
        }
        return formatted.toString();
    }
}

