/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.SVNUtil;

public class PropgetCommand
extends SVNCommand {
    public final void run(PrintStream out, PrintStream err) throws SVNException {
        String propertyName = this.getCommandLine().getPathAt(0);
        DebugLog.error((String)("property name: " + propertyName));
        String absolutePath = this.getCommandLine().getPathAt(1);
        DebugLog.error((String)("path: " + absolutePath));
        ISVNWorkspace workspace = this.createWorkspace(absolutePath, false);
        String relativePath = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)new File(absolutePath).getAbsolutePath());
        try {
            String value = workspace.getPropertyValue(relativePath, propertyName);
            out.println(value);
            DebugLog.log((String)("property get: " + value));
        }
        catch (SVNException e) {
            DebugLog.error((Throwable)e);
        }
    }
}

