/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.ISVNWorkspaceListener;
import org.tmatesoft.svn.core.SVNWorkspaceAdapter;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNCommitInfo;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;
import org.tmatesoft.svn.util.SVNUtil;

public class MkDirCommand
extends SVNCommand {
    public final void run(PrintStream out, PrintStream err) throws SVNException {
        if (!this.getCommandLine().hasURLs()) {
            this.createLocalDirectories(out);
        } else {
            this.createRemoteDirectories(out);
        }
    }

    private void createLocalDirectories(final PrintStream out) throws SVNException {
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            paths.add(this.getCommandLine().getPathAt(i));
        }
        String[] pathsArray = paths.toArray(new String[paths.size()]);
        final String root = PathUtil.getFSCommonRoot((String[])pathsArray);
        DebugLog.log((String)("MKDIR root: " + root));
        final ISVNWorkspace ws = this.createWorkspace(root);
        ws.addWorkspaceListener((ISVNWorkspaceListener)new SVNWorkspaceAdapter(){

            public void modified(String path, int kind) {
                try {
                    path = MkDirCommand.this.convertPath(root, ws, path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                MkDirCommand.println(out, "A  " + path);
            }
        });
        for (int i = 0; i < pathsArray.length; ++i) {
            ws.add(SVNUtil.getWorkspacePath((ISVNWorkspace)ws, (String)pathsArray[i]), true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRemoteDirectories(PrintStream out) throws SVNException {
        SVNCommitInfo info;
        ArrayList<String> urls = new ArrayList<String>();
        for (int i = 0; i < this.getCommandLine().getURLCount(); ++i) {
            urls.add(this.getCommandLine().getURL(i));
        }
        String[] urlsArray = urls.toArray(new String[urls.size()]);
        String root = PathUtil.getCommonRoot((String[])urlsArray);
        DebugLog.log((String)("MKDIR root: " + root));
        String message = (String)this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE);
        for (int i = 0; i < urlsArray.length; ++i) {
            String dir = urlsArray[i].substring(root.length());
            urlsArray[i] = dir = PathUtil.removeLeadingSlash((String)dir);
        }
        ISVNEditor editor = null;
        SVNRepository repository = this.createRepository(root);
        editor = repository.getCommitEditor(message, null);
        try {
            editor.openRoot(-1L);
            for (int i = 0; i < urlsArray.length; ++i) {
                String path = PathUtil.decode((String)urlsArray[i]);
                DebugLog.log((String)("MKDIR adding dir: " + path));
                editor.addDir(path, null, -1L);
            }
            editor.closeDir();
        }
        finally {
            info = editor.closeEdit();
        }
        MkDirCommand.println(out);
        MkDirCommand.println(out, "Committed revision " + info.getNewRevision() + ".");
    }
}

