/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.SVNStatus;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.SVNUtil;

public class InfoCommand
extends SVNCommand {
    private static final DateFormat IN_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DateFormat OUT_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z (EEE, d MMM yyyy)");

    public final void run(PrintStream out, PrintStream err) throws SVNException {
        boolean recursive = this.getCommandLine().hasArgument(SVNArgument.RECURSIVE);
        if (recursive) {
            throw new SVNException("Recursive currently not supported!");
        }
        String absolutePath = this.getCommandLine().getPathAt(0);
        ISVNWorkspace workspace = this.createWorkspace(absolutePath, false);
        String relativePath = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)new File(absolutePath).getAbsolutePath());
        SVNStatus status = workspace.status(relativePath, false);
        InfoCommand.print("Path: " + InfoCommand.getOutputPath(absolutePath), out);
        if (!status.isDirectory()) {
            InfoCommand.print("Name: " + InfoCommand.getName(status), out);
        }
        InfoCommand.print("URL: " + InfoCommand.getLocation(workspace, status), out);
        if (InfoCommand.isNormal(status)) {
            InfoCommand.print("Repository UUID: " + InfoCommand.getUUID(workspace, status), out);
        }
        InfoCommand.print("Revision: " + status.getWorkingCopyRevision(), out);
        InfoCommand.print("Node Kind: " + InfoCommand.getNodeKind(status), out);
        InfoCommand.print("Schedule: " + InfoCommand.getSchedule(status), out);
        if (InfoCommand.isNormal(status)) {
            InfoCommand.print("Last Changed Author: " + status.getAuthor(), out);
            InfoCommand.print("Last Changed Rev: " + status.getRevision(), out);
            InfoCommand.print("Last Changed Date: " + InfoCommand.getCommittedDate(workspace, relativePath), out);
            if (InfoCommand.getTextLastUpdate(workspace, relativePath) != null) {
                InfoCommand.print("Text Last Updated: " + InfoCommand.getTextLastUpdate(workspace, relativePath), out);
            }
            if (InfoCommand.getPropertiesDate(workspace, relativePath) != null) {
                InfoCommand.print("Properties Last Updated: " + InfoCommand.getPropertiesDate(workspace, relativePath), out);
            }
            if (InfoCommand.getChecksum(workspace, relativePath) != null) {
                InfoCommand.print("Checksum: " + InfoCommand.getChecksum(workspace, relativePath), out);
            }
        }
        if (status.isAddedWithHistory()) {
            InfoCommand.print("Copied From URL: " + workspace.getPropertyValue(relativePath, "svn:entry:copyfrom-url"), out);
            InfoCommand.print("Copied From Rev: " + workspace.getPropertyValue(relativePath, "svn:entry:copyfrom-rev"), out);
        }
    }

    private static boolean isNormal(SVNStatus status) {
        return status.isManaged() && status.getContentsStatus() != 1;
    }

    private static String getOutputPath(String absolutePath) {
        String path;
        String cwdPath = new File(".").getAbsolutePath();
        if (absolutePath.startsWith(cwdPath)) {
            path = absolutePath.substring(cwdPath.length());
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        } else {
            path = absolutePath;
        }
        if (path.equals("")) {
            path = ".";
        }
        return path;
    }

    private static String getName(SVNStatus status) {
        String path = status.getPath();
        if (path.equals(".")) {
            return null;
        }
        int slashIndex = path.lastIndexOf("/");
        return slashIndex >= 0 ? path.substring(slashIndex + 1) : path;
    }

    private static String getNodeKind(SVNStatus status) {
        return status.isDirectory() ? "directory" : "file";
    }

    private static String getLocation(ISVNWorkspace workspace, SVNStatus status) throws SVNException {
        String location = workspace.getLocation().toString();
        return status.isDirectory() ? location : location + "/" + InfoCommand.getName(status);
    }

    private static String getUUID(ISVNWorkspace workspace, SVNStatus status) throws SVNException {
        String path = status.isDirectory() ? status.getPath() : InfoCommand.getInternalDirectory(status.getPath());
        return workspace.getPropertyValue(path, "svn:entry:uuid");
    }

    private static String getCommittedDate(ISVNWorkspace workspace, String path) throws SVNException {
        String date = workspace.getPropertyValue(path, "svn:entry:committed-date");
        return date != null ? InfoCommand.formatDate(date) : null;
    }

    private static String getTextLastUpdate(ISVNWorkspace workspace, String path) throws SVNException {
        String date = workspace.getPropertyValue(path, "svn:entry:text-time");
        return date != null ? InfoCommand.formatDate(date) : null;
    }

    private static String getPropertiesDate(ISVNWorkspace workspace, String path) throws SVNException {
        String date = workspace.getPropertyValue(path, "svn:entry:prop-time");
        return date != null ? InfoCommand.formatDate(date) : null;
    }

    private static String getChecksum(ISVNWorkspace workspace, String path) throws SVNException {
        return workspace.getPropertyValue(path, "svn:entry:checksum");
    }

    private static String formatDate(String rawDate) throws SVNException {
        rawDate = rawDate.replace('T', ' ');
        rawDate = rawDate.substring(0, rawDate.indexOf(46));
        try {
            return OUT_FORMAT.format(IN_FORMAT.parse(rawDate));
        }
        catch (ParseException ex) {
            throw new SVNException((Throwable)ex);
        }
    }

    private static String getSchedule(SVNStatus status) {
        int contentStatus = status.getContentsStatus();
        if (contentStatus == 3) {
            return "delete";
        }
        if (contentStatus == 1) {
            return "add";
        }
        return "normal";
    }

    private static String getInternalDirectory(String path) {
        int slashIndex = path.lastIndexOf("/");
        return slashIndex >= 0 ? path.substring(0, slashIndex) : "";
    }

    private static void print(String str, PrintStream out) {
        out.println(str);
        DebugLog.log((String)str);
    }

    static {
        IN_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

