/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.IOException;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.ISVNWorkspaceListener;
import org.tmatesoft.svn.core.SVNWorkspaceAdapter;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;
import org.tmatesoft.svn.util.SVNUtil;

public class ImportCommand
extends SVNCommand {
    public void run(final PrintStream out, PrintStream err) throws SVNException {
        String path = this.getCommandLine().getPathAt(0);
        String url = this.getCommandLine().getURL(0);
        DebugLog.log((String)("import url: " + url));
        DebugLog.log((String)("import path: " + path));
        final ISVNWorkspace workspace = this.createWorkspace(path, false);
        final String homePath = path;
        DebugLog.log((String)("import root: " + workspace.getID()));
        String wsPath = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)path);
        if (wsPath.trim().length() == 0) {
            wsPath = null;
        } else {
            url = PathUtil.removeTail((String)url);
        }
        workspace.addWorkspaceListener((ISVNWorkspaceListener)new SVNWorkspaceAdapter(){

            public void committed(String committedPath, int kind) {
                try {
                    committedPath = ImportCommand.this.convertPath(homePath, workspace, committedPath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ImportCommand.println(out, "Adding " + committedPath);
            }
        });
        SVNRepositoryLocation location = SVNRepositoryLocation.parseURL((String)url);
        String message = (String)this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE);
        if (message == null) {
            DebugLog.log((String)"NO MESSAGE!");
            message = "";
        }
        long revision = workspace.commit(location, wsPath, message);
        out.println("Imported revision " + revision + ".");
    }
}

