/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.IOException;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.ISVNWorkspaceListener;
import org.tmatesoft.svn.core.SVNWorkspaceAdapter;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNCommitInfo;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.PathUtil;
import org.tmatesoft.svn.util.SVNUtil;

public class DeleteCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (this.getCommandLine().hasURLs()) {
            this.runRemote(out);
        } else {
            this.runLocally(out);
        }
    }

    private void runRemote(PrintStream out) throws SVNException {
        String entryUrl = this.getCommandLine().getURL(0);
        String commitMessage = (String)this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE);
        String entry = PathUtil.tail((String)entryUrl);
        String url = entryUrl.substring(0, entryUrl.length() - entry.length());
        SVNRepository repository = this.createRepository(url);
        ISVNEditor editor = repository.getCommitEditor(commitMessage != null ? commitMessage : "", null);
        try {
            editor.openRoot(-1L);
            editor.deleteEntry(entry, -1L);
            editor.closeDir();
            SVNCommitInfo info = editor.closeEdit();
            out.println();
            out.println("Committed revision " + info.getNewRevision() + ".");
        }
        catch (SVNException ex) {
            editor.abortEdit();
            throw ex;
        }
    }

    private void runLocally(final PrintStream out) throws SVNException {
        for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            String absolutePath;
            final String workspacePath = absolutePath = this.getCommandLine().getPathAt(i);
            final ISVNWorkspace workspace = this.createWorkspace(absolutePath);
            boolean force = this.getCommandLine().hasArgument(SVNArgument.FORCE);
            workspace.addWorkspaceListener((ISVNWorkspaceListener)new SVNWorkspaceAdapter(){

                public void modified(String path, int kind) {
                    try {
                        path = DeleteCommand.this.convertPath(workspacePath, workspace, path);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    DeleteCommand.println(out, "D  " + path);
                }
            });
            String relativePath = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)absolutePath);
            workspace.delete(relativePath, force);
        }
    }
}

