/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.ISVNWorkspaceListener;
import org.tmatesoft.svn.core.SVNWorkspaceAdapter;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;
import org.tmatesoft.svn.util.SVNUtil;

public class CommitCommand
extends SVNCommand {
    public void run(final PrintStream out, PrintStream err) throws SVNException {
        this.checkEditorCommand();
        boolean recursive = !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE);
        String[] localPaths = new String[this.getCommandLine().getPathCount()];
        for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            localPaths[i] = this.getCommandLine().getPathAt(i).replace(File.separatorChar, '/');
        }
        final String homePath = localPaths.length == 1 ? localPaths[0] : PathUtil.getFSCommonRoot((String[])localPaths);
        ArrayList<String> pathsList = new ArrayList<String>();
        try {
            for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
                String path = this.getCommandLine().getPathAt(i);
                pathsList.add(new File(path).getCanonicalPath().replace(File.separatorChar, '/'));
            }
        }
        catch (IOException e) {
            err.println("error: " + e.getMessage());
            return;
        }
        DebugLog.log((String)("commit paths: " + pathsList));
        String[] paths = pathsList.toArray(new String[pathsList.size()]);
        String rootPath = pathsList.size() == 1 && new File((String)pathsList.get(0)).isDirectory() ? (String)pathsList.get(0) : PathUtil.getFSCommonRoot((String[])paths);
        DebugLog.log((String)("commit root: " + rootPath));
        final ISVNWorkspace workspace = this.createWorkspace(rootPath);
        Iterator commitPaths = pathsList.iterator();
        while (commitPaths.hasNext()) {
            String commitPath = (String)commitPaths.next();
            ISVNWorkspace ws = SVNUtil.createWorkspace((String)commitPath);
            if (ws != null && ws.getID().equals(workspace.getID())) continue;
            throw new SVNException("can't commit items from different working copies");
        }
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)paths[i]);
        }
        String message = this.getCommitMessage();
        workspace.addWorkspaceListener((ISVNWorkspaceListener)new SVNWorkspaceAdapter(){

            public void committed(String committedPath, int kind) {
                DebugLog.log((String)("commit path: " + committedPath));
                DebugLog.log((String)("home path: " + homePath));
                String verb = "Sending ";
                if (kind == 1) {
                    verb = "Adding ";
                    try {
                        String mimeType = workspace.getPropertyValue(committedPath, "svn:mime-type");
                        if (mimeType != null && !mimeType.startsWith("text")) {
                            verb = verb + " (bin) ";
                        }
                        DebugLog.log((String)("mimetype: " + mimeType));
                    }
                    catch (SVNException e1) {
                        DebugLog.error((Throwable)e1);
                    }
                } else if (kind == 3) {
                    verb = "Deleting ";
                } else if (kind == 7) {
                    verb = "Replacing ";
                }
                try {
                    committedPath = CommitCommand.this.convertPath(homePath, workspace, committedPath);
                }
                catch (IOException e) {
                    // empty catch block
                }
                CommitCommand.println(out, verb + committedPath);
            }
        });
        long revision = workspace.commit(paths, message, recursive, false);
        if (revision >= 0L) {
            out.println("Committed revision " + revision + ".");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCommitMessage() throws SVNException {
        String fileName = (String)this.getCommandLine().getArgumentValue(SVNArgument.FILE);
        if (fileName == null) return (String)this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE);
        FileInputStream is = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            try {
                is = new FileInputStream(fileName);
                while (true) {
                    int r;
                    if ((r = is.read()) < 0) {
                        Object var6_6 = null;
                        break;
                    }
                    if (r == 0) {
                        throw new SVNException("error: commit message contains a zero byte");
                    }
                    bos.write(r);
                }
            }
            catch (IOException e) {
                throw new SVNException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (is != null) {
                    is.close();
                }
                bos.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new SVNException((Throwable)e);
            }
        }
        try {}
        catch (IOException e) {
            throw new SVNException((Throwable)e);
        }
        if (is != null) {
            is.close();
        }
        bos.close();
        return new String(bos.toByteArray());
    }

    private void checkEditorCommand() throws SVNException {
        String editorCommand = (String)this.getCommandLine().getArgumentValue(SVNArgument.EDITOR_CMD);
        if (editorCommand == null) {
            return;
        }
        throw new SVNException("Commit failed. Can't handle external editor " + editorCommand);
    }
}

