/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.IOException;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.ISVNWorkspaceListener;
import org.tmatesoft.svn.core.SVNWorkspaceAdapter;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.SVNAssert;

public class CheckoutCommand
extends SVNCommand {
    public void run(final PrintStream out, PrintStream err) throws SVNException {
        String path;
        String url = this.getCommandLine().getURL(0);
        SVNRepositoryLocation location = SVNRepositoryLocation.parseURL((String)url);
        if (this.getCommandLine().getPathCount() == 1) {
            path = this.getCommandLine().getPathAt(0);
        } else {
            SVNRepository repository = this.createRepository(url);
            repository.testConnection();
            String root = repository.getRepositoryRoot();
            String locationPath = location.getPath();
            SVNAssert.assertTrue((boolean)locationPath.startsWith(root));
            path = locationPath.substring(root.length());
        }
        DebugLog.log((String)("checkout url: " + url));
        DebugLog.log((String)("checkout path: " + path));
        final ISVNWorkspace workspace = this.createWorkspace(path, false);
        long revision = CheckoutCommand.parseRevision(this.getCommandLine(), null, null);
        if (SVNRepositoryLocation.equals((SVNRepositoryLocation)workspace.getLocation(), (SVNRepositoryLocation)location)) {
            workspace.update(revision);
            return;
        }
        final String homePath = path;
        workspace.addWorkspaceListener((ISVNWorkspaceListener)new SVNWorkspaceAdapter(){

            public void updated(String updatedPath, int contentsStatus, int propertiesStatus, long rev) {
                if ("".equals(updatedPath)) {
                    return;
                }
                try {
                    updatedPath = CheckoutCommand.this.convertPath(homePath, workspace, updatedPath);
                }
                catch (IOException e) {
                    // empty catch block
                }
                CheckoutCommand.println(out, "A  " + updatedPath);
            }
        });
        revision = workspace.checkout(location, revision, false, !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE));
        out.println("Checked out revision " + revision + ".");
    }
}

