/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli;

import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.SVNCommandLine;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.ws.fs.FSEntryFactory;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;

public class SVN {
    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            DebugLog.log((String)"invliad arguments!");
            System.err.println("usage: svn commandName commandArguments");
            System.exit(0);
        }
        StringBuffer commandLineString = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            commandLineString.append(args[i] + (i < args.length - 1 ? " " : ""));
        }
        DebugLog.log((String)("command line: " + commandLineString.toString()));
        SVNCommandLine commandLine = null;
        try {
            try {
                commandLine = new SVNCommandLine(args);
            }
            catch (SVNException e) {
                DebugLog.error((Throwable)e);
                System.err.println("error: " + e.getMessage());
                System.exit(1);
            }
            String commandName = commandLine.getCommandName();
            DebugLog.log((String)("COMMAND NAME: " + commandName + " ========================================== "));
            SVNCommand command = SVNCommand.getCommand(commandName);
            DebugLog.log((String)("command: " + command));
            if (command != null) {
                DAVRepositoryFactory.setup();
                SVNRepositoryFactoryImpl.setup();
                FSEntryFactory.setup();
                command.setCommandLine(commandLine);
                try {
                    command.run(System.out, System.err);
                }
                catch (SVNException e) {
                    System.err.println("error: " + e.getMessage());
                    e.printStackTrace(System.err);
                    DebugLog.error((Throwable)e);
                }
            } else {
                System.err.println("error: unknown command name '" + commandName + "'");
                System.exit(1);
            }
        }
        catch (Throwable th) {
            DebugLog.error((Throwable)th);
            System.exit(-1);
        }
        System.exit(0);
    }
}

