/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.java;

import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.xml.QName;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.java.TextNode;
import com.caucho.xsl.java.XslNode;

public class XslText
extends XslNode {
    private String _text = "";
    private String _disableOutputEscaping;

    public void addAttribute(QName name, String value) throws XslParseException {
        if (name.getName().equals("disable-output-escaping")) {
            this._disableOutputEscaping = value;
        } else {
            super.addAttribute(name, value);
        }
    }

    public void addChild(XslNode node) throws XslParseException {
        if (node == null) {
            return;
        }
        if (!(node instanceof TextNode)) {
            throw this.error(L.l("'{0}' is not allowed as an xsl:text child.", node));
        }
        this._text = new CharBuffer().append(this._text).append(((TextNode)node).getText()).toString();
    }

    public void generate(JavaWriter out) throws Exception {
        String var = null;
        if ("yes".equals(this._disableOutputEscaping)) {
            var = new CharBuffer().append("_xsl_out_").append(this._gen.generateId()).toString();
            out.println(new CharBuffer().append("boolean ").append(var).append(" = out.disableEscaping(true);").toString());
        } else if ("no".equals(this._disableOutputEscaping)) {
            var = new CharBuffer().append("_xsl_out_").append(this._gen.generateId()).toString();
            out.println(new CharBuffer().append("boolean ").append(var).append(" = out.disableEscaping(false);").toString());
        } else if (this._disableOutputEscaping != null) {
            throw this.error(L.l("'{0}' is an unknown value for disable-output-escaping.  'yes' and 'no' are the valid values.", this._disableOutputEscaping));
        }
        out.print("out.print(\"");
        out.printJavaString(this._text);
        out.println("\");");
        if (var != null) {
            out.println(new CharBuffer().append("out.disableEscaping(").append(var).append(");").toString());
        }
    }
}

