/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.java;

import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.xml.QName;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.java.XslNode;
import com.caucho.xsl.java.XslTopNode;

public class XslTemplate
extends XslNode
implements XslTopNode {
    private String _match;
    private String _name;
    private String _mode;
    private double _priority = Double.NaN;
    private String _as;
    private String _macroName;

    public void addAttribute(QName name, String value) throws XslParseException {
        if (name.getName().equals("match")) {
            this._match = value;
        } else if (name.getName().equals("name")) {
            this._name = value;
        } else if (name.getName().equals("mode")) {
            this._mode = value;
        } else if (name.getName().equals("priority")) {
            this._priority = Double.parseDouble(value);
        } else if (name.getName().equals("as")) {
            this._as = value;
        } else {
            super.addAttribute(name, value);
        }
    }

    public void endAttributes() throws XslParseException {
        if (this._match == null && this._name == null) {
            throw this.error(L.l("xsl:template needs a 'match' or a 'name' attribute."));
        }
        if (this._name != null) {
            this._macroName = new CharBuffer().append("_xsl_macro_").append(this._gen.toJavaIdentifier(this._name)).append("__").append(this._gen.uniqueId()).toString();
            this._gen.addMacro(this._name, this._macroName);
        }
    }

    public void generate(JavaWriter out) throws Exception {
        String fun = null;
        if (this._match != null) {
            fun = this._gen.createTemplatePattern(this._name, this.parseMatch(this._match), this._mode, this._priority);
            out.println();
            out.print(new CharBuffer().append("// '").append(this._match.replace('\n', ' ')).append("'").toString());
            if (this._mode != null) {
                this._gen.addMode(this._mode);
                out.println(new CharBuffer().append(" mode '").append(this._mode).append("'").toString());
            } else {
                out.println();
            }
            out.printJavaString(new CharBuffer().append("// ").append(this.getFilename()).append(":").append(this.getStartLine()).toString());
            out.println();
            out.println(new CharBuffer().append("private void ").append(fun).append("(XslWriter out, Node inputNode, Env env)").toString());
            out.println("  throws Exception");
            out.println("{");
            out.pushDepth();
            out.println("Object _xsl_tmp;");
            out.println("Node node = inputNode;");
            out.println("int _xsl_top = env.getTop();");
            boolean isRawText = this._gen.getDisableOutputEscaping();
            if (isRawText) {
                out.println("boolean oldEscaping = out.disableEscaping(true);");
            } else {
                out.println("boolean oldEscaping = out.disableEscaping(false);");
            }
            String filename = this.getBaseURI();
            if (filename != null) {
                int pos = this._gen.addStylesheet(filename);
                out.println(new CharBuffer().append("env.setStylesheetEnv(stylesheets[").append(pos).append("]);").toString());
            }
            this._gen.setSelectDepth(0);
            this._gen.clearUnique();
            this.generateChildren(out);
            out.println("out.disableEscaping(oldEscaping);");
            out.println("env.popToTop(_xsl_top);");
            out.popDepth();
            out.println("}");
            out.println();
        }
        if (this._name != null) {
            out.println(new CharBuffer().append("void ").append(this._macroName).append("(XslWriter out, Node inputNode, Env env)").toString());
            out.println("  throws Exception");
            out.println("{");
            out.pushDepth();
            if (this._match == null) {
                out.println("Object _xsl_tmp;");
                out.println("Node node = inputNode;");
                this.generateChildren(out);
            } else {
                out.println(new CharBuffer().append(fun).append("(out, inputNode, env);").toString());
            }
            out.popDepth();
            out.println("}");
        }
    }
}

