/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.util.CharBuffer;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.NodeIterator;
import org.w3c.dom.Node;

public class FromExpr
extends AbstractPattern {
    private Expr _expr;

    public FromExpr(AbstractPattern parent, Expr expr) {
        super(parent);
        this._expr = expr;
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        NodeIterator iter = this._expr.evalNodeSet(node, env);
        while (iter.hasNext()) {
            Node subnode = iter.nextNode();
            if (subnode != node) continue;
            return true;
        }
        return false;
    }

    public NodeIterator createNodeIterator(Node node, ExprEnvironment env, AbstractPattern match) throws XPathException {
        return this._expr.evalNodeSet(node, env);
    }

    public int position(Node node, Env env, AbstractPattern pattern) throws XPathException {
        NodeIterator iter = this._expr.evalNodeSet(node, env);
        int i = 1;
        while (iter.hasNext()) {
            if (iter.next() == node) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int count(Node node, Env env, AbstractPattern pattern) throws XPathException {
        NodeIterator iter = this._expr.evalNodeSet(node, env);
        int count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        return count;
    }

    public String toString() {
        return new CharBuffer().append(this.getPrefix()).append("(").append(this._expr).append(")").toString();
    }
}

