/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.util.CharBuffer;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.NodeIterator;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeListIterator
extends NodeIterator {
    protected NodeIterator _parentIter;
    protected NamedNodeMap _attributeMap;
    protected Node _node;
    protected int _index;
    protected AbstractPattern _match;

    protected AttributeListIterator(ExprEnvironment env) {
        super(env);
    }

    public AttributeListIterator(NodeIterator parentIter, ExprEnvironment env, AbstractPattern match) throws XPathException {
        super(env);
        this._parentIter = parentIter;
        this._match = match;
        this._node = this.findFirstMatchingNode();
    }

    public boolean hasNext() {
        return this._node != null;
    }

    public Node nextNode() throws XPathException {
        Node node = this._node;
        this._node = this.findFirstMatchingNode();
        return node;
    }

    private Node findFirstMatchingNode() throws XPathException {
        Node node = null;
        while (true) {
            Node parent;
            if (node != null && (this._match == null || this._match.match(node, this._env))) {
                ++this._position;
                return node;
            }
            if (this._attributeMap != null && this._index < this._attributeMap.getLength()) {
                node = this._attributeMap.item(this._index++);
                continue;
            }
            if (this._parentIter == null || (parent = this._parentIter.nextNode()) == null) {
                return null;
            }
            if (!(parent instanceof Element)) continue;
            this._position = 0;
            this._size = 0;
            this._index = 0;
            this._attributeMap = ((Element)parent).getAttributes();
        }
    }

    public int getContextSize() {
        if (this._attributeMap == null) {
            return 0;
        }
        return this._attributeMap.getLength();
    }

    public Object clone() {
        AttributeListIterator iter = new AttributeListIterator(this._env);
        iter.copy(this);
        if (this._parentIter != null) {
            iter._parentIter = (NodeIterator)this._parentIter.clone();
        }
        iter._node = this._node;
        iter._index = this._index;
        iter._attributeMap = this._attributeMap;
        iter._match = this._match;
        return iter;
    }

    public String toString() {
        return new CharBuffer().append("AttributeListIterator[").append(this._match).append("]").toString();
    }
}

