/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.log.Log;
import com.caucho.vfs.ByteToCharWriter;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WriterStreamImpl
extends StreamImpl {
    private static Logger log = Log.open(WriterStreamImpl._resin_compat_class_0());
    private Writer _writer;
    private ByteToCharWriter _byteToChar = new ByteToCharWriter();
    private boolean _isClosed;
    private static Class _resin_compat_class_0;

    public void setWriter(Writer writer) {
        this._writer = writer;
        this._byteToChar.setWriter(writer);
        this._isClosed = false;
        try {
            this._byteToChar.setEncoding(null);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public boolean canWrite() {
        return true;
    }

    public void setWriteEncoding(String encoding) {
        try {
            this._byteToChar.setEncoding(encoding);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
        if (this._isClosed) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            this._byteToChar.addByte(buffer[offset + i]);
        }
        this._byteToChar.flush();
    }

    public void flush() throws IOException {
    }

    public void close() {
        this._isClosed = true;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.vfs.WriterStreamImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

