/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TcpStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpPath
extends Path {
    protected String _host;
    protected int _port;
    protected long _timeout;

    TcpPath(TcpPath root, String userPath, Map<String, Object> newAttributes, String host, int port) {
        super(root);
        this.setUserPath(userPath);
        this._host = host;
        this._port = port == 0 ? 80 : port;
    }

    @Override
    protected Path schemeWalk(String userPath, Map<String, Object> newAttributes, String uri, int offset) {
        int i;
        int length = uri.length();
        if (length < 2 + offset || uri.charAt(offset) != '/' || uri.charAt(1 + offset) != '/') {
            throw new RuntimeException("bad scheme");
        }
        CharBuffer buf = new CharBuffer();
        char ch = '\u0000';
        for (i = 2 + offset; i < length && (ch = uri.charAt(i)) != ':' && ch != '/' && ch != '?'; ++i) {
            buf.append(ch);
        }
        String host = buf.toString();
        if (host.length() == 0) {
            throw new RuntimeException("bad host");
        }
        int port = 0;
        if (ch == ':') {
            ++i;
            while (i < length && (ch = uri.charAt(i)) >= '0' && ch <= '9') {
                port = 10 * port + uri.charAt(i) - 48;
                ++i;
            }
        }
        return this.create(this, userPath, newAttributes, host, port);
    }

    protected TcpPath create(TcpPath root, String userPath, Map<String, Object> newAttributes, String host, int port) {
        return new TcpPath(root, userPath, newAttributes, host, port);
    }

    @Override
    public String getScheme() {
        return "tcp";
    }

    @Override
    public String getURL() {
        return new CharBuffer().append(this.getScheme()).append("://").append(this.getHost()).append(":").append(this.getPort()).toString();
    }

    @Override
    public String getPath() {
        return "";
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public StreamImpl openReadImpl() throws IOException {
        return TcpStream.openRead(this, this._timeout);
    }

    @Override
    public StreamImpl openReadWriteImpl() throws IOException {
        return TcpStream.openReadWrite(this, this._timeout);
    }

    @Override
    public String toString() {
        return this.getURL();
    }
}

