/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.config.types.Period;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.QDate;
import com.caucho.util.WeakAlarm;
import com.caucho.vfs.AbstractRolloverLog;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RotateStream
extends StreamImpl
implements AlarmListener {
    private static final Logger log = Log.open(RotateStream._resin_compat_class_0());
    private static HashMap<Path, SoftReference<RotateStream>> _streams = new HashMap();
    private static HashMap<String, SoftReference<RotateStream>> _formatStreams = new HashMap();
    private final AbstractRolloverLog _rolloverLog = new AbstractRolloverLog();
    private final Alarm _alarm = new WeakAlarm(this);
    private QDate _calendar = new QDate(true);
    private volatile boolean _isInit;
    private volatile boolean _isClosed;
    private static Class _resin_compat_class_0;

    private RotateStream(Path path) {
        this._rolloverLog.setPath(path);
    }

    private RotateStream(String formatPath) {
        this._rolloverLog.setPathFormat(formatPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RotateStream create(Path path) {
        HashMap<Path, SoftReference<RotateStream>> hashMap = _streams;
        synchronized (hashMap) {
            RotateStream stream;
            SoftReference<RotateStream> ref = _streams.get(path);
            RotateStream rotateStream = stream = ref != null ? ref.get() : null;
            if (stream == null) {
                stream = new RotateStream(path);
                _streams.put(path, new SoftReference<RotateStream>(stream));
            }
            return stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RotateStream create(String path) {
        HashMap<String, SoftReference<RotateStream>> hashMap = _formatStreams;
        synchronized (hashMap) {
            RotateStream stream;
            SoftReference<RotateStream> ref = _formatStreams.get(path);
            RotateStream rotateStream = stream = ref != null ? ref.get() : null;
            if (stream == null) {
                stream = new RotateStream(path);
                _formatStreams.put(path, new SoftReference<RotateStream>(stream));
            }
            return stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        RotateStream stream;
        SoftReference<RotateStream> streamRef;
        Iterator<SoftReference<RotateStream>> i$;
        HashMap<Object, SoftReference<RotateStream>> hashMap = _streams;
        synchronized (hashMap) {
            i$ = _streams.values().iterator();
            while (i$.hasNext()) {
                streamRef = i$.next();
                try {
                    stream = streamRef.get();
                    if (stream == null) continue;
                    stream.closeImpl();
                }
                catch (Throwable e) {}
            }
            _streams.clear();
        }
        hashMap = _formatStreams;
        synchronized (hashMap) {
            i$ = _formatStreams.values().iterator();
            while (i$.hasNext()) {
                streamRef = i$.next();
                try {
                    stream = streamRef.get();
                    if (stream == null) continue;
                    stream.closeImpl();
                }
                catch (Throwable throwable) {}
            }
            _formatStreams.clear();
        }
    }

    public AbstractRolloverLog getRolloverLog() {
        return this._rolloverLog;
    }

    public void setMaxRolloverCount(int count) {
        log.warning("max-rollover-count is no longer suported.");
    }

    public void setRolloverPeriod(long period) {
        this._rolloverLog.setRolloverPeriod(new Period(period));
    }

    public void setArchiveFormat(String format) {
        this._rolloverLog.setArchiveFormat(format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        RotateStream rotateStream = this;
        synchronized (rotateStream) {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
        }
        this._rolloverLog.init();
        long now = Alarm.getCurrentTime();
        this._alarm.queue(this._rolloverLog.getNextRolloverCheckTime() - now);
    }

    public Path getPath() {
        return this._rolloverLog.getPath();
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
        this._rolloverLog.rollover();
        this._rolloverLog.write(buffer, offset, length);
        this._rolloverLog.rollover();
    }

    public WriteStream getStream() {
        return new WriteStream(this);
    }

    public void flush() throws IOException {
        this._rolloverLog.flush();
        this._rolloverLog.rollover();
        long now = Alarm.getCurrentTime();
        this._alarm.queue(this._rolloverLog.getNextRolloverCheckTime() - now);
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        try {
            this._rolloverLog.flush();
            this._rolloverLog.rollover();
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (!this._isClosed) {
                long now = Alarm.getCurrentTime();
                this._alarm.queue(this._rolloverLog.getNextRolloverCheckTime() - now);
            }
        }
    }

    private void closeImpl() {
        try {
            this._isClosed = true;
            this._rolloverLog.close();
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void finalize() {
        this.closeImpl();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.vfs.RotateStream");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

