/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.NullPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class ReaderWriterStream
extends StreamImpl {
    private static NullPath nullPath;
    private Reader is;
    private Writer os;
    private boolean flushOnNewline;
    private boolean closeChildOnClose = true;
    private int peek1;
    private int peek2;

    public ReaderWriterStream(Reader is, Writer os) {
        this.init(is, os);
        if (nullPath == null) {
            nullPath = new NullPath("stream");
        }
        this.setPath(nullPath);
    }

    public ReaderWriterStream(Reader is, Writer os, Path path) {
        this.init(is, os);
        this.setPath(path);
    }

    public void init(Reader is, Writer os) {
        this.is = is;
        this.os = os;
        this.setPath(nullPath);
        this.peek1 = -1;
        this.peek2 = -1;
    }

    public String getEncoding() {
        if (this.os instanceof OutputStreamWriter) {
            return Encoding.getMimeName(((OutputStreamWriter)this.os).getEncoding());
        }
        return null;
    }

    public boolean canRead() {
        return this.is != null;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (this.is == null) {
            return -1;
        }
        for (int i = 0; i < length; ++i) {
            if (this.peek1 >= 0) {
                buf[offset++] = (byte)this.peek1;
                this.peek1 = this.peek2;
                this.peek2 = -1;
                continue;
            }
            int ch = this.is.read();
            if (ch < 0) {
                return i == 0 ? -1 : i;
            }
            if (ch < 128) {
                buf[offset++] = (byte)ch;
                continue;
            }
            if (ch < 2048) {
                buf[offset++] = (byte)(192 + (ch >> 6));
                this.peek1 = 128 + (ch & 0x3F);
                continue;
            }
            buf[offset++] = (byte)(224 + (ch >> 12));
            this.peek1 = 128 + (ch >> 6 & 0x3F);
            this.peek2 = 128 + (ch & 0x3F);
        }
        return length;
    }

    public boolean canWrite() {
        return this.os != null;
    }

    public boolean getFlushOnNewline() {
        return this.flushOnNewline;
    }

    public void setFlushOnNewline(boolean value) {
        this.flushOnNewline = value;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        int end = offset + length;
        while (offset < end) {
            int ch2;
            int ch1;
            if ((ch1 = buf[offset++] & 0xFF) < 128) {
                this.os.write(ch1);
                continue;
            }
            if ((ch1 & 0xE0) == 192) {
                if (offset >= end) {
                    throw new EOFException("unexpected end of file in utf8 character");
                }
                if (((ch2 = buf[offset++] & 0xFF) & 0xC0) != 128) {
                    throw new CharConversionException("illegal utf8 encoding");
                }
                this.os.write(((ch1 & 0x1F) << 6) + (ch2 & 0x3F));
                continue;
            }
            if ((ch1 & 0xF0) == 224) {
                if (offset + 1 >= end) {
                    throw new EOFException("unexpected end of file in utf8 character");
                }
                ch2 = buf[offset++] & 0xFF;
                int ch3 = buf[offset++] & 0xFF;
                if ((ch2 & 0xC0) != 128) {
                    throw new CharConversionException("illegal utf8 encoding");
                }
                if ((ch3 & 0xC0) != 128) {
                    throw new CharConversionException("illegal utf8 encoding");
                }
                this.os.write(((ch1 & 0x1F) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F));
                continue;
            }
            throw new CharConversionException(new CharBuffer().append("illegal utf8 encoding at (").append(ch1).append(")").toString());
        }
    }

    public void flush() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
    }

    public void setCloseChildOnClose(boolean close) {
        this.closeChildOnClose = close;
    }

    public void close() throws IOException {
        if (this.os != null && this.closeChildOnClose) {
            this.os.close();
            this.os = null;
        }
        if (this.is != null && this.closeChildOnClose) {
            this.is.close();
            this.is = null;
        }
    }
}

