/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PathExistsDependency
implements Dependency {
    private static final Logger log = Log.open(PathExistsDependency._resin_compat_class_0());
    Path _source;
    boolean _exists;
    private static Class _resin_compat_class_0;

    public PathExistsDependency(Path source) {
        if (source instanceof JarPath) {
            source = ((JarPath)source).getContainer();
        }
        this._source = source;
        this._exists = source.exists();
    }

    public PathExistsDependency(Path source, boolean exists) {
        this._source = source;
        this._exists = exists;
    }

    public Path getPath() {
        return this._source;
    }

    public boolean isModified() {
        boolean exists = this._source.exists();
        if (exists == this._exists) {
            return false;
        }
        if (exists) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(new CharBuffer().append(this._source.getNativePath()).append(" has been created.").toString());
            }
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(new CharBuffer().append(this._source.getNativePath()).append(" has been deleted.").toString());
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PathExistsDependency)) {
            return false;
        }
        PathExistsDependency depend = (PathExistsDependency)obj;
        return this._source.equals(depend._source);
    }

    public String toString() {
        return new CharBuffer().append("PathExistsDependency[").append(this._source).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.vfs.PathExistsDependency");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

