/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.QDate;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.HttpStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.XmlParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPath
extends FilesystemPath {
    protected static L10N L = new L10N(HttpPath._resin_compat_class_0());
    protected static LruCache<String, CacheEntry> _cache = new LruCache(1024);
    protected String _host;
    protected int _port;
    protected String _query;
    protected CacheEntry _cacheEntry;
    private static Class _resin_compat_class_0;

    HttpPath(String host, int port) {
        super(null, "/", "/");
        this._root = this;
        this._host = host;
        this._port = port == 0 ? 80 : port;
    }

    HttpPath(FilesystemPath root, String userPath, Map<String, Object> newAttributes, String path, String query) {
        super(root, userPath, path);
        this._host = ((HttpPath)root)._host;
        this._port = ((HttpPath)root)._port;
        this._query = query;
    }

    @Override
    public Path lookupImpl(String userPath, Map<String, Object> newAttributes) {
        if (userPath == null) {
            return this._root.fsWalk(this.getPath(), newAttributes, "/");
        }
        int length = userPath.length();
        int colon = userPath.indexOf(58);
        int slash = userPath.indexOf(47);
        if (colon != -1 && (colon < slash || slash == -1)) {
            return super.lookupImpl(userPath, newAttributes);
        }
        if (slash == 0 && length > 1 && userPath.charAt(1) == '/') {
            return this.schemeWalk(userPath, newAttributes, userPath, 0);
        }
        String newPath = slash == 0 ? HttpPath.normalizePath("/", userPath, 0, '/') : HttpPath.normalizePath(this._pathname, userPath, 0, '/');
        return this._root.fsWalk(userPath, newAttributes, newPath);
    }

    @Override
    protected Path schemeWalk(String userPath, Map<String, Object> attributes, String uri, int offset) {
        int i;
        int length = uri.length();
        if (length < 2 + offset || uri.charAt(offset) != '/' || uri.charAt(offset + 1) != '/') {
            throw new RuntimeException(L.l("bad scheme in `{0}'", uri));
        }
        CharBuffer buf = CharBuffer.allocate();
        char ch = '\u0000';
        for (i = 2 + offset; i < length && (ch = uri.charAt(i)) != ':' && ch != '/' && ch != '?'; ++i) {
            buf.append(ch);
        }
        String host = buf.close();
        if (host.length() == 0) {
            throw new RuntimeException(L.l("bad host in `{0}'", uri));
        }
        int port = 0;
        if (ch == ':') {
            ++i;
            while (i < length && (ch = uri.charAt(i)) >= '0' && ch <= '9') {
                port = 10 * port + uri.charAt(i) - 48;
                ++i;
            }
        }
        if (port == 0) {
            port = 80;
        }
        HttpPath root = this.create(host, port);
        return root.fsWalk(userPath, attributes, uri.substring(i));
    }

    @Override
    protected Path fsWalk(String userPath, Map<String, Object> attributes, String uri) {
        String path;
        String query = null;
        int queryIndex = uri.indexOf(63);
        if (queryIndex >= 0) {
            path = uri.substring(0, queryIndex);
            query = uri.substring(queryIndex + 1);
        } else {
            path = uri;
        }
        if (path.length() == 0) {
            path = "/";
        }
        return this.create(this._root, userPath, attributes, path, query);
    }

    protected HttpPath create(String host, int port) {
        return new HttpPath(host, port);
    }

    protected HttpPath create(FilesystemPath root, String userPath, Map<String, Object> newAttributes, String path, String query) {
        return new HttpPath(root, userPath, newAttributes, path, query);
    }

    @Override
    public String getScheme() {
        return "http";
    }

    @Override
    public String getURL() {
        int port = this.getPort();
        return new CharBuffer().append(this.getScheme()).append("://").append(this.getHost()).append(port == 80 ? "" : new CharBuffer().append(":").append(this.getPort()).toString()).append(this.getPath()).append(this._query == null ? "" : new CharBuffer().append("?").append(this._query).toString()).toString();
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public String getUserPath() {
        return this._userPath;
    }

    @Override
    public String getQuery() {
        return this._query;
    }

    @Override
    public long getLastModified() {
        return this.getCache().lastModified;
    }

    @Override
    public long getLength() {
        return this.getCache().length;
    }

    @Override
    public boolean exists() {
        return this.getCache().lastModified >= 0L;
    }

    @Override
    public boolean isFile() {
        return !this.getPath().endsWith("/") && this.getCache().lastModified >= 0L;
    }

    @Override
    public boolean canRead() {
        return this.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.getPath().endsWith("/") && this.getCache().lastModified >= 0L;
    }

    @Override
    public String[] list() throws IOException {
        try {
            HttpStream stream = (HttpStream)this.openReadWriteImpl();
            stream.setMethod("PROPFIND");
            stream.setAttribute("Depth", "1");
            WriteStream os = new WriteStream(stream);
            os.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            os.println("<propfind xmlns=\"DAV:\"><prop>");
            os.println("<resourcetype/>");
            os.println("</prop></propfind>");
            os.flush();
            ReadStream is = new ReadStream(stream);
            ListHandler handler = new ListHandler(this.getPath());
            XmlParser parser = new XmlParser();
            parser.setContentHandler(handler);
            parser.parse(is);
            is.close();
            os.close();
            stream.close();
            ArrayList<String> names = handler.getNames();
            String[] list = new String[names.size()];
            names.toArray(list);
            return list;
        }
        catch (Exception e) {
            throw new IOException(L.l("list() is not supported by this server"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheEntry getCache() {
        if (this._cacheEntry == null) {
            LruCache<String, CacheEntry> lruCache = _cache;
            synchronized (lruCache) {
                this._cacheEntry = _cache.get(this.getPath());
                if (this._cacheEntry == null) {
                    this._cacheEntry = new CacheEntry();
                    _cache.put(this.getPath(), this._cacheEntry);
                }
            }
        }
        long now = Alarm.getCurrentTime();
        CacheEntry cacheEntry = this._cacheEntry;
        synchronized (cacheEntry) {
            try {
                if (this._cacheEntry.expires > now) {
                    return this._cacheEntry;
                }
                HttpStream stream = (HttpStream)this.openReadImpl();
                stream.setHead(true);
                stream.setSocketTimeout(120000L);
                String status = (String)stream.getAttribute("status");
                if (status.equals("200")) {
                    String lastModified = (String)stream.getAttribute("last-modified");
                    this._cacheEntry.lastModified = 0L;
                    if (lastModified != null) {
                        QDate date;
                        QDate qDate = date = QDate.getGlobalDate();
                        synchronized (qDate) {
                            this._cacheEntry.lastModified = date.parseDate(lastModified);
                        }
                    }
                    String length = (String)stream.getAttribute("content-length");
                    this._cacheEntry.length = 0L;
                    if (length != null) {
                        this._cacheEntry.length = Integer.parseInt(length);
                    }
                } else {
                    this._cacheEntry.lastModified = -1L;
                }
                this._cacheEntry.expires = now + 5000L;
                stream.close();
                return this._cacheEntry;
            }
            catch (Exception e) {
                this._cacheEntry.lastModified = -1L;
                this._cacheEntry.expires = now + 5000L;
                return this._cacheEntry;
            }
        }
    }

    @Override
    public StreamImpl openReadImpl() throws IOException {
        return HttpStream.openRead(this);
    }

    @Override
    public StreamImpl openReadWriteImpl() throws IOException {
        return HttpStream.openReadWrite(this);
    }

    @Override
    public String toString() {
        return this.getURL();
    }

    @Override
    public int hashCode() {
        return 65537 * super.hashCode() + 37 * this._host.hashCode() + this._port;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof HttpPath)) {
            return false;
        }
        HttpPath test = (HttpPath)o;
        if (!this._host.equals(test._host)) {
            return false;
        }
        if (this._port != test._port) {
            return false;
        }
        if (this._query != null && !this._query.equals(test._query)) {
            return false;
        }
        return this._query != null || test._query == null;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.vfs.HttpPath");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListHandler
    extends DefaultHandler {
        String _prefix;
        ArrayList<String> _names = new ArrayList();
        boolean _inHref;

        ListHandler(String prefix) {
            this._prefix = prefix;
        }

        ArrayList<String> getNames() {
            return this._names;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (localName.equals("href")) {
                this._inHref = true;
            }
        }

        @Override
        public void characters(char[] data, int offset, int length) throws SAXException {
            if (!this._inHref) {
                return;
            }
            String href = new String(data, offset, length).trim();
            if (!href.startsWith(this._prefix)) {
                return;
            }
            if ((href = href.substring(this._prefix.length())).startsWith("/")) {
                href = href.substring(1);
            }
            int p = href.indexOf(47);
            if (href.equals("") || p == 0) {
                return;
            }
            if (p < 0) {
                this._names.add(href);
            } else {
                this._names.add(href.substring(0, p));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("href")) {
                this._inHref = false;
            }
        }
    }

    static class CacheEntry {
        long lastModified;
        long length;
        boolean canRead;
        long expires;

        CacheEntry() {
        }
    }
}

