/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.log.Log;
import com.caucho.make.PersistentDependency;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Depend
implements PersistentDependency {
    private static final Logger log = Log.open(Depend._resin_compat_class_0());
    Path _source;
    long _lastModified;
    long _length;
    boolean _requireSource = true;
    boolean _isDigestModified;
    private static Class _resin_compat_class_0;

    public Depend(Path source, long lastModified, long length) {
        this._source = source;
        this._lastModified = lastModified;
        this._length = length;
    }

    public Depend(Path source) {
        if (source instanceof JarPath) {
            source = ((JarPath)source).getContainer();
        }
        this._source = source;
        this._lastModified = source.getLastModified();
        this._length = source.getLength();
    }

    public Depend(Path source, long digest) {
        this(source, digest, true);
    }

    public Depend(Path source, long digest, boolean requireSource) {
        this._source = source;
        long newDigest = source.getCrc64();
        this._requireSource = requireSource;
        if (newDigest != digest && (requireSource || newDigest != -1L)) {
            if (newDigest == -1L) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(new CharBuffer().append(this._source.getNativePath()).append(" source is deleted.").toString());
                }
                this._isDigestModified = true;
            } else {
                this._isDigestModified = true;
            }
        }
        this._lastModified = this._source.getLastModified();
        this._length = this._source.getLength();
    }

    public Path getPath() {
        return this._source;
    }

    public long getLastModified() {
        return this._source.getLastModified();
    }

    public long getLength() {
        return this._source.getLength();
    }

    public boolean getRequireSource() {
        return this._requireSource;
    }

    public void setRequireSource(boolean requireSource) {
        this._requireSource = requireSource;
    }

    public boolean isModified() {
        if (this._isDigestModified) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(new CharBuffer().append(this._source.getNativePath()).append(" digest is modified.").toString());
            }
            return true;
        }
        long sourceLastModified = this._source.getLastModified();
        long sourceLength = this._source.getLength();
        if (!this._requireSource && sourceLastModified == 0L) {
            return false;
        }
        if (sourceLength != this._length) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(new CharBuffer().append(this._source.getNativePath()).append(" length is modified (").append(this._length).append(" -> ").append(sourceLength).append(")").toString());
            }
            return true;
        }
        if (sourceLastModified != this._lastModified) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(new CharBuffer().append(this._source.getNativePath()).append(" time is modified.").toString());
            }
            return true;
        }
        return false;
    }

    public long getDigest() {
        return this._source.getCrc64();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Depend)) {
            return false;
        }
        Depend depend = (Depend)obj;
        return this._source.equals(depend._source);
    }

    public String getJavaCreateString() {
        return new CharBuffer().append("new com.caucho.vfs.Depend(com.caucho.vfs.Vfs.lookup(\"").append(this._source.getPath()).append("\"), ").append(this._source.getCrc64()).append("L)").toString();
    }

    public String toString() {
        return new CharBuffer().append("Depend[").append(this._source).append(" ").append(this._lastModified).append(" ").append(this._source.getLastModified() - this._lastModified).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.vfs.Depend");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

