/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;

public class AbstractRolloverLog {
    protected static final Logger log = Log.open(AbstractRolloverLog._resin_compat_class_0());
    protected static final L10N L = new L10N(AbstractRolloverLog._resin_compat_class_0());
    private static final long DAY = 86400000L;
    private static final long DEFAULT_ROLLOVER_SIZE = 0x3FFFFFFFFFFFFFFFL;
    private static final long DEFAULT_ROLLOVER_CHECK_PERIOD = 600000L;
    private String _rolloverPrefix;
    private String _archiveFormat;
    private long _rolloverPeriod = 4611686018427387000L;
    private long _rolloverSize = 0x3FFFFFFFFFFFFFFFL;
    private long _rolloverCheckPeriod = 600000L;
    private QDate _calendar = QDate.createLocal();
    private Path _pwd = Vfs.lookup();
    protected Path _path;
    protected String _pathFormat;
    private String _format;
    private long _nextPeriodEnd = -1L;
    private long _nextRolloverCheckTime = -1L;
    private WriteStream _os;
    private static Class _resin_compat_class_0;

    public Path getPath() {
        return this._path;
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public Path getPwd() {
        return this._pwd;
    }

    public String getPathFormat() {
        return this._pathFormat;
    }

    public void setPathFormat(String pathFormat) {
        this._pathFormat = pathFormat;
    }

    public void setArchiveFormat(String format) {
        this._archiveFormat = format;
    }

    public String getArchiveFormat() {
        return this._archiveFormat;
    }

    public void setRolloverPeriod(Period period) {
        this._rolloverPeriod = period.getPeriod();
        if (this._rolloverPeriod > 0L) {
            this._rolloverPeriod += 3599999L;
            this._rolloverPeriod -= this._rolloverPeriod % 3600000L;
        } else {
            this._rolloverPeriod = 4611686018427387000L;
        }
    }

    public long getRolloverPeriod() {
        return this._rolloverPeriod;
    }

    public void setRolloverSize(Bytes bytes) {
        long size = bytes.getBytes();
        this._rolloverSize = size < 0L ? 0x3FFFFFFFFFFFFFFFL : size;
    }

    public long getRolloverSize() {
        return this._rolloverSize;
    }

    public void setRolloverCheckPeriod(long period) {
        if (period > 1000L) {
            this._rolloverCheckPeriod = period;
        } else if (period > 0L) {
            this._rolloverCheckPeriod = 1000L;
        }
    }

    public long getRolloverCheckPeriod() {
        return this._rolloverCheckPeriod;
    }

    public void init() throws IOException {
        long now = Alarm.getCurrentTime();
        this._nextRolloverCheckTime = now + this._rolloverCheckPeriod;
        Path path = this.getPath();
        if (path != null) {
            path.getParent().mkdirs();
            this._rolloverPrefix = path.getTail();
            long lastModified = path.getLastModified();
            if (lastModified <= 0L) {
                lastModified = now;
            }
            this._calendar.setGMTTime(lastModified);
            long zone = this._calendar.getZoneOffset();
            this._nextPeriodEnd = Period.periodEnd(lastModified, this.getRolloverPeriod());
        } else {
            this._nextPeriodEnd = Period.periodEnd(now, this.getRolloverPeriod());
        }
        if (this._nextPeriodEnd < this._nextRolloverCheckTime && this._nextPeriodEnd > 0L) {
            this._nextRolloverCheckTime = this._nextPeriodEnd;
        }
        this.rolloverLog(now);
    }

    public long getNextRolloverCheckTime() {
        if (this._nextPeriodEnd < this._nextRolloverCheckTime) {
            return this._nextPeriodEnd;
        }
        return this._nextRolloverCheckTime;
    }

    public boolean isRollover() {
        long now = Alarm.getCurrentTime();
        return this._nextPeriodEnd <= now || this._nextRolloverCheckTime <= now;
    }

    public boolean rollover() {
        long now = Alarm.getCurrentTime();
        if (this._nextPeriodEnd <= now || this._nextRolloverCheckTime <= now) {
            this.rolloverLog(now);
            return true;
        }
        return false;
    }

    protected void write(byte[] buffer, int offset, int length) throws IOException {
        if (this._os == null) {
            this.openLog();
        }
        if (this._os != null) {
            this._os.write(buffer, offset, length);
        }
    }

    protected void flush() throws IOException {
        if (this._os != null) {
            this._os.flush();
        }
    }

    protected void rolloverLog(long now) {
        this._nextRolloverCheckTime = now + this._rolloverCheckPeriod;
        long lastPeriodEnd = this._nextPeriodEnd;
        this._nextPeriodEnd = Period.periodEnd(now, this.getRolloverPeriod());
        Path path = this.getPath();
        if (lastPeriodEnd < now) {
            this.closeLogStream();
            if (this.getPathFormat() == null) {
                Path savedPath = this.getArchivePath(lastPeriodEnd - 1L);
                this.movePathToArchive(savedPath);
            }
        } else if (path != null && this.getRolloverSize() <= path.getLength()) {
            this.closeLogStream();
            if (this.getPathFormat() == null) {
                Path savedPath = this.getArchivePath(this._nextRolloverCheckTime - 1L);
                this.movePathToArchive(savedPath);
            }
        }
        long nextPeriodEnd = this._nextPeriodEnd;
        if (this._nextPeriodEnd < this._nextRolloverCheckTime && this._nextPeriodEnd > 0L) {
            this._nextRolloverCheckTime = this._nextPeriodEnd;
        }
        if (this._os == null) {
            this.openLog();
        }
    }

    private void openLog() {
        this.closeLogStream();
        try {
            WriteStream os = this._os;
            this._os = null;
            if (os != null) {
                os.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        Path path = this.getPath();
        if (path == null) {
            path = this.getPath(Alarm.getCurrentTime());
        }
        try {
            if (!path.getParent().isDirectory()) {
                path.getParent().mkdirs();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        for (int i = 0; i < 3 && this._os == null; ++i) {
            try {
                this._os = path.openAppend();
                continue;
            }
            catch (IOException e) {
                log.fine(L.l("Can't open log '{0}'.\n{1}", (Object)this.getPath(), e.toString()));
            }
        }
        if (this._os == null) {
            log.warning(L.l("Can't open log file '{0}'.", this.getPath()));
        }
    }

    private void closeLogStream() {
        try {
            WriteStream os = this._os;
            this._os = null;
            if (os != null) {
                os.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void movePathToArchive(Path savedPath) {
        WriteStream os;
        Path path = this.getPath();
        String savedName = savedPath.getTail();
        log.info(L.l("Archiving access log to {0}.", savedName));
        try {
            os = this._os;
            this._os = null;
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        try {
            savedPath.getParent().mkdirs();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        try {
            os = savedPath.openWrite();
            OutputStream out = savedName.endsWith(".gz") ? new GZIPOutputStream(os) : (savedName.endsWith(".zip") ? new ZipOutputStream(os) : os);
            try {
                path.writeToStream(out);
            }
            finally {
                try {
                    out.close();
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                try {
                    if (out != os) {
                        os.close();
                    }
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                path.remove();
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    protected Path getPath(long time) {
        String formatString = this.getPathFormat();
        if (formatString == null) {
            throw new IllegalStateException(L.l("getPath requires a format path"));
        }
        String pathString = this.getFormatName(formatString, time);
        return this.getPwd().lookup(pathString);
    }

    protected Path getArchivePath(long time) {
        Path path = this.getPath();
        String archiveFormat = this.getArchiveFormat();
        String name = this.getFormatName(archiveFormat, time);
        Path newPath = path.getParent().lookup(name);
        if (newPath.exists()) {
            if (archiveFormat == null) {
                archiveFormat = new CharBuffer().append(this._rolloverPrefix).append(".%Y%m%d.%H%M").toString();
            } else if (!archiveFormat.contains("%H")) {
                archiveFormat = new CharBuffer().append(archiveFormat).append(".%H%M").toString();
            } else if (!archiveFormat.contains("%M")) {
                archiveFormat = new CharBuffer().append(archiveFormat).append(".%M").toString();
            }
            name = this.getFormatName(archiveFormat, time);
            newPath = path.getParent().lookup(name);
        }
        return newPath;
    }

    protected String getFormatName(String format, long time) {
        if (time <= 0L) {
            time = Alarm.getCurrentTime();
        }
        if (format != null) {
            return QDate.formatLocal(time, format);
        }
        if (this.getRolloverPeriod() % 86400000L == 0L) {
            return new CharBuffer().append(this._rolloverPrefix).append(".").append(QDate.formatLocal(time, "%Y%m%d")).toString();
        }
        return new CharBuffer().append(this._rolloverPrefix).append(".").append(QDate.formatLocal(time, "%Y%m%d.%H")).toString();
    }

    public void close() throws IOException {
        if (this._os != null) {
            WriteStream os = this._os;
            this._os = null;
            os.close();
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.vfs.AbstractRolloverLog");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

