/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.TimeUnit;
import java.util.logging.Logger;

public class Semaphore {
    private static final Logger log = Logger.getLogger(Semaphore._resin_compat_class_0().getName());
    private volatile int _permits;
    private static Class _resin_compat_class_0;

    public Semaphore(int permits, boolean fair) {
        this._permits = permits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        long ms = unit.toMillis(timeout);
        long now = System.currentTimeMillis();
        long expire = ms + now;
        Semaphore semaphore = this;
        synchronized (semaphore) {
            do {
                if (this._permits > 0) {
                    --this._permits;
                    return true;
                }
                now = System.currentTimeMillis();
                long delta = expire - now;
                if (delta <= 0L) continue;
                this.wait(delta);
                if (this._permits <= 0) continue;
                --this._permits;
                return true;
            } while (System.currentTimeMillis() < expire);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Semaphore semaphore = this;
        synchronized (semaphore) {
            ++this._permits;
            this.notifyAll();
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.util.Semaphore");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

