/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CacheListener;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LruCache<K, V> {
    private static final Integer NULL = new Integer(0);
    private CacheItem[] _entries;
    private int _capacity;
    private int _capacity1;
    private int _mask;
    private int _size1;
    private CacheItem<K, V> _head1;
    private CacheItem<K, V> _tail1;
    private int _size2;
    private CacheItem<K, V> _head2;
    private CacheItem<K, V> _tail2;
    private volatile long _hitCount;
    private volatile long _missCount;

    public LruCache(int initialCapacity) {
        int capacity;
        for (capacity = 16; capacity < 2 * initialCapacity; capacity *= 2) {
        }
        this._entries = new CacheItem[capacity];
        this._mask = capacity - 1;
        this._capacity = initialCapacity;
        this._capacity1 = this._capacity / 2;
    }

    public int size() {
        return this._size1 + this._size2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int i;
        ArrayList<CacheListener> listeners = null;
        LruCache lruCache = this;
        synchronized (lruCache) {
            for (int i2 = this._entries.length - 1; i2 >= 0; --i2) {
                CacheItem item = this._entries[i2];
                if (item != null && item._value instanceof CacheListener) {
                    if (listeners == null) {
                        listeners = new ArrayList<CacheListener>();
                    }
                    listeners.add((CacheListener)item._value);
                }
                this._entries[i2] = null;
            }
            this._size1 = 0;
            this._head1 = null;
            this._tail1 = null;
            this._size2 = 0;
            this._head2 = null;
            this._tail2 = null;
        }
        int n = i = listeners != null ? listeners.size() - 1 : -1;
        while (i >= 0) {
            CacheListener listener = (CacheListener)listeners.get(i);
            listener.removeEvent();
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Object okey = key;
        if (okey == null) {
            okey = NULL;
        }
        int hash = okey.hashCode() & this._mask;
        LruCache lruCache = this;
        synchronized (lruCache) {
            for (int count = this._size1 + this._size2 + 1; count >= 0; --count) {
                CacheItem item = this._entries[hash];
                if (item == null) {
                    ++this._missCount;
                    return null;
                }
                if (item._key == key || item._key.equals(key)) {
                    this.updateLru(item);
                    ++this._hitCount;
                    return item._value;
                }
                hash = hash + 1 & this._mask;
            }
            ++this._missCount;
        }
        return null;
    }

    public V put(K key, V value) {
        V oldValue = this.put(key, value, true);
        if (oldValue instanceof CacheListener) {
            ((CacheListener)oldValue).removeEvent();
        }
        return oldValue;
    }

    public V putIfNew(K key, V value) {
        V oldValue = this.put(key, value, false);
        if (oldValue != null) {
            return oldValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V put(K key, V value, boolean replace) {
        Object okey = key;
        if (okey == null) {
            okey = NULL;
        }
        while (this._capacity <= this._size1 + this._size2) {
            this.removeTail();
        }
        int hash = key.hashCode() & this._mask;
        Object oldValue = null;
        LruCache lruCache = this;
        synchronized (lruCache) {
            for (int count = this._size1 + this._size2 + 1; count > 0; --count) {
                CacheItem<K, V> item = this._entries[hash];
                if (item == null) {
                    this._entries[hash] = item = new CacheItem<K, V>(key, value);
                    ++this._size1;
                    item._next = this._head1;
                    if (this._head1 != null) {
                        this._head1._prev = item;
                    } else {
                        this._tail1 = item;
                    }
                    this._head1 = item;
                    return null;
                }
                if (item._key == okey || item._key.equals(okey)) {
                    this.updateLru(item);
                    oldValue = item._value;
                    if (replace) {
                        item._value = value;
                    }
                    if (value != oldValue) break;
                    oldValue = null;
                    break;
                }
                hash = hash + 1 & this._mask;
            }
        }
        if (replace && oldValue instanceof CacheListener) {
            ((CacheListener)oldValue).removeEvent();
        }
        return null;
    }

    private void updateLru(CacheItem<K, V> item) {
        CacheItem prev = item._prev;
        CacheItem next = item._next;
        if (item._isOnce) {
            item._isOnce = false;
            if (prev != null) {
                prev._next = next;
            } else {
                this._head1 = next;
            }
            if (next != null) {
                next._prev = prev;
            } else {
                this._tail1 = prev;
            }
            item._prev = null;
            if (this._head2 != null) {
                this._head2._prev = item;
            } else {
                this._tail2 = item;
            }
            item._next = this._head2;
            this._head2 = item;
            --this._size1;
            ++this._size2;
        } else {
            if (prev == null) {
                return;
            }
            prev._next = next;
            item._prev = null;
            item._next = this._head2;
            this._head2._prev = item;
            this._head2 = item;
            if (next != null) {
                next._prev = prev;
            } else {
                this._tail2 = prev;
            }
        }
    }

    public boolean removeTail() {
        CacheItem<K, V> tail;
        if (this._capacity1 <= this._size1) {
            tail = this._tail1 != null ? this._tail1 : this._tail2;
        } else {
            CacheItem<K, V> cacheItem = tail = this._tail2 != null ? this._tail2 : this._tail1;
        }
        if (tail == null) {
            return false;
        }
        this.remove(tail._key);
        return true;
    }

    public boolean removeLongestTail() {
        CacheItem<K, V> tail;
        if (this._size1 <= this._size2) {
            tail = this._tail2 != null ? this._tail2 : this._tail1;
        } else {
            CacheItem<K, V> cacheItem = tail = this._tail1 != null ? this._tail1 : this._tail2;
        }
        if (tail == null) {
            return false;
        }
        this.remove(tail._key);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        int count;
        Object okey = key;
        if (okey == null) {
            okey = NULL;
        }
        int hash = key.hashCode() & this._mask;
        V value = null;
        LruCache lruCache = this;
        synchronized (lruCache) {
            for (count = this._size1 + this._size2 + 1; count > 0; --count) {
                CacheItem item = this._entries[hash];
                if (item == null) {
                    return null;
                }
                if (item._key == okey || item._key.equals(okey)) {
                    int nextHash;
                    CacheItem nextItem;
                    this._entries[hash] = null;
                    CacheItem prev = item._prev;
                    CacheItem next = item._next;
                    if (item._isOnce) {
                        --this._size1;
                        if (prev != null) {
                            prev._next = next;
                        } else {
                            this._head1 = next;
                        }
                        if (next != null) {
                            next._prev = prev;
                        } else {
                            this._tail1 = prev;
                        }
                    } else {
                        --this._size2;
                        if (prev != null) {
                            prev._next = next;
                        } else {
                            this._head2 = next;
                        }
                        if (next != null) {
                            next._prev = prev;
                        } else {
                            this._tail2 = prev;
                        }
                    }
                    value = item._value;
                    for (int i = 1; i <= count && (nextItem = this._entries[nextHash = hash + i & this._mask]) != null; ++i) {
                        this._entries[nextHash] = null;
                        this.refillEntry(nextItem);
                    }
                    break;
                }
                hash = hash + 1 & this._mask;
            }
        }
        if (count < 0) {
            throw new RuntimeException("internal cache error");
        }
        if (value instanceof CacheListener) {
            ((CacheListener)value).removeEvent();
        }
        return value;
    }

    private void refillEntry(CacheItem<K, V> item) {
        int baseHash = item._key.hashCode();
        for (int count = 0; count < this._size1 + this._size2 + 1; ++count) {
            int hash = baseHash + count & this._mask;
            if (this._entries[hash] != null) continue;
            this._entries[hash] = item;
            return;
        }
    }

    public Iterator<K> keys() {
        KeyIterator iter = new KeyIterator(this);
        iter.init(this);
        return iter;
    }

    public Iterator<K> keys(Iterator<K> oldIter) {
        KeyIterator iter = (KeyIterator)oldIter;
        iter.init(this);
        return oldIter;
    }

    public Iterator<V> values() {
        ValueIterator iter = new ValueIterator(this);
        iter.init(this);
        return iter;
    }

    public Iterator<V> values(Iterator<V> oldIter) {
        ValueIterator iter = (ValueIterator)oldIter;
        iter.init(this);
        return oldIter;
    }

    public Iterator<Entry<K, V>> iterator() {
        return new EntryIterator();
    }

    public long getHitCount() {
        return this._hitCount;
    }

    public long getMissCount() {
        return this._missCount;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryIterator
    implements Iterator<Entry<K, V>>,
    Entry<K, V> {
        private int _i = -1;

        EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            int i;
            CacheItem[] entries = LruCache.this._entries;
            int length = entries.length;
            for (i = this._i + 1; i < length && entries[i] == null; ++i) {
            }
            this._i = i - 1;
            return i < length;
        }

        @Override
        public Entry<K, V> next() {
            int i;
            CacheItem[] entries = LruCache.this._entries;
            int length = entries.length;
            for (i = this._i + 1; i < length && entries[i] == null; ++i) {
            }
            this._i = i;
            if (this._i < length) {
                return this;
            }
            return null;
        }

        @Override
        public K getKey() {
            if (this._i < LruCache.this._entries.length) {
                CacheItem entry = LruCache.this._entries[this._i];
                return entry != null ? (Object)entry._key : null;
            }
            return null;
        }

        @Override
        public V getValue() {
            if (this._i < LruCache.this._entries.length) {
                CacheItem entry = LruCache.this._entries[this._i];
                return entry != null ? (Object)entry._value : null;
            }
            return null;
        }

        @Override
        public void remove() {
            CacheItem entry;
            if (this._i < LruCache.this._entries.length && (entry = LruCache.this._entries[this._i]) != null) {
                LruCache.this.remove(entry._key);
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Entry<K, V> {
        public K getKey();

        public V getValue();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValueIterator<K, V>
    implements Iterator<V> {
        private LruCache<K, V> _cache;
        private int _i = -1;

        ValueIterator(LruCache<K, V> cache) {
            this.init(cache);
        }

        void init(LruCache<K, V> cache) {
            this._cache = cache;
            this._i = -1;
        }

        @Override
        public boolean hasNext() {
            int i;
            CacheItem[] entries = ((LruCache)this._cache)._entries;
            int length = entries.length;
            for (i = this._i + 1; i < length; ++i) {
                if (entries[i] == null) continue;
                this._i = i - 1;
                return true;
            }
            this._i = i;
            return false;
        }

        @Override
        public V next() {
            int i;
            CacheItem[] entries = ((LruCache)this._cache)._entries;
            int length = entries.length;
            for (i = this._i + 1; i < length; ++i) {
                CacheItem entry = entries[i];
                if (entry == null) continue;
                this._i = i;
                return entry._value;
            }
            this._i = i;
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KeyIterator<K, V>
    implements Iterator<K> {
        private LruCache<K, V> _cache;
        private int _i = -1;

        KeyIterator(LruCache<K, V> cache) {
            this._cache = cache;
        }

        void init(LruCache<K, V> cache) {
            this._cache = cache;
            this._i = -1;
        }

        @Override
        public boolean hasNext() {
            CacheItem[] entries = ((LruCache)this._cache)._entries;
            int length = entries.length;
            ++this._i;
            while (this._i < length) {
                if (entries[this._i] != null) {
                    --this._i;
                    return true;
                }
                ++this._i;
            }
            return false;
        }

        @Override
        public K next() {
            CacheItem[] entries = ((LruCache)this._cache)._entries;
            int length = entries.length;
            ++this._i;
            while (this._i < length) {
                CacheItem entry = entries[this._i];
                if (entry != null) {
                    return entry._key;
                }
                ++this._i;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheItem<K, V> {
        CacheItem<K, V> _prev;
        CacheItem<K, V> _next;
        K _key;
        V _value;
        int _index;
        boolean _isOnce;

        CacheItem(K key, V value) {
            this._key = key;
            this._value = value;
            this._isOnce = true;
        }
    }
}

