/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CacheListener;
import com.caucho.util.ClockCacheItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongKeyLruCache<V> {
    private static final Logger log = Logger.getLogger(LongKeyLruCache._resin_compat_class_0().getName());
    private static final Integer NULL = new Integer(0);
    private CacheItem<V>[] _entries;
    private int _capacity;
    private int _capacity1;
    private int _mask;
    private int _size1;
    private CacheItem<V> _head1;
    private CacheItem<V> _tail1;
    private int _size2;
    private CacheItem<V> _head2;
    private CacheItem<V> _tail2;
    private volatile long _hitCount;
    private volatile long _missCount;
    private static Class _resin_compat_class_0;

    public LongKeyLruCache(int initialCapacity) {
        int capacity;
        for (capacity = 16; capacity < 8 * initialCapacity; capacity *= 2) {
        }
        this._entries = new CacheItem[capacity];
        this._mask = capacity - 1;
        this._capacity = initialCapacity;
        this._capacity1 = this._capacity / 2;
    }

    public int size() {
        return this._size1 + this._size2;
    }

    public int getCapacity() {
        return this._capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int newCapacity) {
        LongKeyLruCache longKeyLruCache = this;
        synchronized (longKeyLruCache) {
            int capacity;
            for (capacity = this._entries.length; capacity < 8 * newCapacity; capacity *= 2) {
            }
            if (capacity == this._entries.length) {
                return;
            }
            CacheItem<V>[] oldEntries = this._entries;
            this._entries = new CacheItem[capacity];
            this._mask = capacity - 1;
            this._capacity = newCapacity;
            this._capacity1 = this._capacity / 2;
            for (int i = 0; i < oldEntries.length; ++i) {
                if (oldEntries[i] == null) continue;
                this.refillEntry(oldEntries[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int i;
        ArrayList<CacheListener> listeners = null;
        LongKeyLruCache longKeyLruCache = this;
        synchronized (longKeyLruCache) {
            for (int i2 = this._entries.length - 1; i2 >= 0; --i2) {
                CacheItem<V> item = this._entries[i2];
                if (item != null && item._value instanceof CacheListener) {
                    if (listeners == null) {
                        listeners = new ArrayList<CacheListener>();
                    }
                    listeners.add((CacheListener)item._value);
                }
                this._entries[i2] = null;
            }
            this._size1 = 0;
            this._head1 = null;
            this._tail1 = null;
            this._size2 = 0;
            this._head2 = null;
            this._tail2 = null;
        }
        int n = i = listeners == null ? -1 : listeners.size() - 1;
        while (i >= 0) {
            CacheListener listener = (CacheListener)listeners.get(i);
            listener.removeEvent();
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long key) {
        int hash = LongKeyLruCache.hash(key) & this._mask;
        LongKeyLruCache longKeyLruCache = this;
        synchronized (longKeyLruCache) {
            for (int count = this._size1 + this._size2 + 1; count >= 0; --count) {
                CacheItem<V> item = this._entries[hash];
                if (item == null) {
                    ++this._missCount;
                    return null;
                }
                if (item._key == key) {
                    this.updateLru(item);
                    ++this._hitCount;
                    return item._value;
                }
                hash = hash + 1 & this._mask;
            }
            ++this._missCount;
        }
        return null;
    }

    public V put(long key, V value) {
        V oldValue = this.put(key, value, true);
        if (oldValue instanceof CacheListener) {
            ((CacheListener)oldValue).removeEvent();
        }
        return oldValue;
    }

    public V putIfNew(long key, V value) {
        V oldValue = this.put(key, value, false);
        if (oldValue != null) {
            return oldValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V put(long key, V value, boolean replace) {
        for (int max = 32; max > 0 && this._capacity <= this._size1 + this._size2 && this.removeTail(); --max) {
        }
        int hash = LongKeyLruCache.hash(key) & this._mask;
        Object oldValue = null;
        LongKeyLruCache longKeyLruCache = this;
        synchronized (longKeyLruCache) {
            for (int count = this._size1 + this._size2 + 1; count > 0; --count) {
                CacheItem<V> item = this._entries[hash];
                if (item == null) {
                    this._entries[hash] = item = new CacheItem<V>(key, value);
                    ++this._size1;
                    item._next = this._head1;
                    if (this._head1 != null) {
                        this._head1._prev = item;
                    } else {
                        this._tail1 = item;
                    }
                    this._head1 = item;
                    return null;
                }
                if (item._key == key) {
                    this.updateLru(item);
                    oldValue = item._value;
                    if (!replace) break;
                    item._value = value;
                    break;
                }
                hash = hash + 1 & this._mask;
            }
        }
        if (replace && oldValue instanceof CacheListener) {
            ((CacheListener)oldValue).removeEvent();
        }
        return null;
    }

    private void updateLru(CacheItem<V> item) {
        CacheItem prev = item._prev;
        CacheItem next = item._next;
        if (item._isOnce) {
            item._isOnce = false;
            if (prev != null) {
                prev._next = next;
            } else {
                this._head1 = next;
            }
            if (next != null) {
                next._prev = prev;
            } else {
                this._tail1 = prev;
            }
            item._prev = null;
            if (this._head2 != null) {
                this._head2._prev = item;
            } else {
                this._tail2 = item;
            }
            item._next = this._head2;
            this._head2 = item;
            --this._size1;
            ++this._size2;
        } else {
            if (prev == null) {
                return;
            }
            prev._next = next;
            item._prev = null;
            item._next = this._head2;
            this._head2._prev = item;
            this._head2 = item;
            if (next != null) {
                next._prev = prev;
            } else {
                this._tail2 = prev;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTail() {
        CacheItem<V> tail = this._capacity1 <= this._size1 ? this._tail1 : this._tail2;
        for (int max = 32; max > 0; --max) {
            if (tail == null) {
                return false;
            }
            Object value = tail._value;
            LongKeyLruCache longKeyLruCache = this;
            synchronized (longKeyLruCache) {
                if (value instanceof ClockCacheItem) {
                    ClockCacheItem item = (ClockCacheItem)value;
                    item.clearUsed();
                    if (item.isUsed()) {
                        tail = tail._prev;
                        continue;
                    }
                }
                value = this.removeImpl(tail._key);
            }
            if (value instanceof CacheListener) {
                ((CacheListener)value).removeEvent();
            }
            return true;
        }
        log.fine("LRU-Cache can't remove tail because the tail values are busy.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(long key) {
        V value = null;
        LongKeyLruCache longKeyLruCache = this;
        synchronized (longKeyLruCache) {
            value = this.removeImpl(key);
        }
        if (value instanceof CacheListener) {
            ((CacheListener)value).removeEvent();
        }
        return value;
    }

    private V removeImpl(long key) {
        int count;
        int hash = LongKeyLruCache.hash(key) & this._mask;
        V value = null;
        for (count = this._size1 + this._size2 + 1; count > 0; --count) {
            CacheItem<V> item = this._entries[hash];
            if (item == null) {
                return null;
            }
            if (item._key == key) {
                int nextHash;
                CacheItem<V> nextItem;
                this._entries[hash] = null;
                CacheItem prev = item._prev;
                CacheItem next = item._next;
                if (item._isOnce) {
                    --this._size1;
                    if (prev != null) {
                        prev._next = next;
                    } else {
                        this._head1 = next;
                    }
                    if (next != null) {
                        next._prev = prev;
                    } else {
                        this._tail1 = prev;
                    }
                } else {
                    --this._size2;
                    if (prev != null) {
                        prev._next = next;
                    } else {
                        this._head2 = next;
                    }
                    if (next != null) {
                        next._prev = prev;
                    } else {
                        this._tail2 = prev;
                    }
                }
                value = item._value;
                for (int i = 1; i <= count && (nextItem = this._entries[nextHash = hash + i & this._mask]) != null; ++i) {
                    this._entries[nextHash] = null;
                    this.refillEntry(nextItem);
                }
                break;
            }
            hash = hash + 1 & this._mask;
        }
        if (count < 0) {
            throw new RuntimeException("internal cache error");
        }
        return value;
    }

    private void refillEntry(CacheItem<V> item) {
        int baseHash = LongKeyLruCache.hash(item._key);
        for (int count = 0; count < this._size1 + this._size2 + 1; ++count) {
            int hash = baseHash + count & this._mask;
            if (this._entries[hash] != null) continue;
            this._entries[hash] = item;
            return;
        }
    }

    private static int hash(long key) {
        long hash = key;
        hash = 65537L * hash + (key >>> 8);
        hash = 65537L * hash + (key >>> 16);
        hash = 65537L * hash + (key >>> 32);
        hash = 65537L * hash + (key >>> 48);
        return (int)hash;
    }

    public Iterator<V> values() {
        ValueIterator iter = new ValueIterator(this);
        iter.init(this);
        return iter;
    }

    public Iterator<V> values(Iterator<V> oldIter) {
        ValueIterator iter = (ValueIterator)oldIter;
        iter.init(this);
        return oldIter;
    }

    public long getHitCount() {
        return this._hitCount;
    }

    public long getMissCount() {
        return this._missCount;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.util.LongKeyLruCache");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValueIterator<V>
    implements Iterator<V> {
        private LongKeyLruCache<V> _cache;
        private int _i = -1;

        ValueIterator(LongKeyLruCache<V> cache) {
            this.init(cache);
        }

        void init(LongKeyLruCache<V> cache) {
            this._cache = cache;
            this._i = -1;
        }

        @Override
        public boolean hasNext() {
            int i;
            CacheItem[] entries = ((LongKeyLruCache)this._cache)._entries;
            int length = entries.length;
            for (i = this._i + 1; i < length; ++i) {
                if (entries[i] == null) continue;
                this._i = i - 1;
                return true;
            }
            this._i = i;
            return false;
        }

        @Override
        public V next() {
            int i;
            CacheItem[] entries = ((LongKeyLruCache)this._cache)._entries;
            int length = entries.length;
            for (i = this._i + 1; i < length; ++i) {
                CacheItem entry = entries[i];
                if (entry == null) continue;
                this._i = i;
                return entry._value;
            }
            this._i = i;
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheItem<V> {
        CacheItem<V> _prev;
        CacheItem<V> _next;
        long _key;
        V _value;
        int _index;
        boolean _isOnce;

        CacheItem(long key, V value) {
            this._key = key;
            this._value = value;
            this._isOnce = true;
        }
    }
}

